/***************************************************************************

  CTimer.cpp

  (c) 2000-2003 Benot Minisini <gambas@users.sourceforge.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************/

#define __CTIMER_CPP



#include <qapplication.h>

#include "gambas.h"
#include "main.h"
#include "CWidget.h"
#include "CTimer.h"

/*#define DEBUG_CBUTTON*/


DECLARE_EVENT(EVENT_Timer);

#if 0
BEGIN_METHOD(CTIMER_new, GB_OBJECT parent)
  
  if (MISSING(parent))
    THIS = new MyTimer(ME);
  else
    THIS = new MyTimer(ME, QWIDGET(VARG(parent)));

END_METHOD
#endif

BEGIN_METHOD_VOID(CTIMER_new)

  //qDebug("CTIMER_new: %p", THIS);
  TIMER = new MyTimer(THIS);

END_METHOD


BEGIN_METHOD_VOID(CTIMER_free)

  //qDebug("CTIMER_free: %p", THIS);
  
  if (TIMER)
    delete TIMER;

END_METHOD


BEGIN_PROPERTY(CTIMER_delay)

  if (READ_PROPERTY)
    GB.ReturnInteger(TIMER->delay());
  else
    TIMER->setDelay(VPROP(GB_INTEGER));

END_PROPERTY


BEGIN_PROPERTY(CTIMER_enabled)

  if (READ_PROPERTY)
    GB.ReturnBoolean(TIMER->isEnabled());
  else
    TIMER->setEnabled(VPROP(GB_BOOLEAN));

END_PROPERTY


GB_DESC CTimerDesc[] =
{
  GB_DECLARE("Timer", sizeof(CTIMER)),

  GB_METHOD("_new", NULL, CTIMER_new, NULL), //"[(Parent)Container;]"),
  GB_METHOD("_free", NULL, CTIMER_free, NULL),

  GB_PROPERTY("Enabled", "b", CTIMER_enabled),
  GB_PROPERTY("Delay", "i", CTIMER_delay),

  GB_CONSTANT("_Properties", "s", CTIMER_PROPERTIES),
  GB_CONSTANT("_DefaultEvent", "s", "Timer"),

  GB_EVENT("Timer", NULL, NULL, &EVENT_Timer),

  GB_END_DECLARE
};


MyTimer::MyTimer(CTIMER *ob, QObject *parent /* = 0 */) : QObject(parent)
{
  _ob = ob;
  _enabled = false;
  _delay = 1000;
}

MyTimer::~MyTimer()
{
  if (_enabled)
    killTimer(id);

  _ob->timer = NULL;
  GB.Detach(_ob);
}

void MyTimer::setEnabled(bool e)
{
  if (_enabled == e)
    return;

  _enabled = e;

  if (_delay <= 0)
    return;
  
  if (_enabled)
  {
    //qDebug("startTimer: %d", _delay);
    id = startTimer(_delay);
  }
  else
  {
    //qDebug("killTimer: %d", _delay);
    killTimer(id);
  }
}


void MyTimer::setDelay(long d)
{
  bool e = _enabled;

  if (e)
    setEnabled(false);

  _delay = d;

  setEnabled(e);
}


void MyTimer::timerEvent(QTimerEvent *e)
{
  if (GB.CanRaise(_ob, EVENT_Timer))
    GB.Raise(_ob, EVENT_Timer, 0);
  else
    setEnabled(false);
}
