/* $Id: become_a_nobody.c,v 1.2 2002/06/20 03:23:24 massie Exp $ */
#include <ganglia/become_a_nobody.h>
#include <ganglia/error.h>
#include <stdio.h>

void
become_a_nobody( const char *username )
{
   int rval;
   struct passwd *pw;
 
   pw = getpwnam(username);
   if ( pw == NULL )
     {
       err_quit("user '%s' does not exist\n\n", username);
     }

   rval = getuid();
   if ( rval != pw->pw_uid )  
     {
       if ( rval != 0 )
         {
           err_quit("Must be root to setuid to \"%s\"\n\n", username);
         }

       rval = setuid(pw->pw_uid); 
       if ( rval < 0 )
         {
           err_quit("exiting. setuid '%s' error", username);
         }
     }
}
