/**
 * @file debug_msg.c Debug Message function
 */
/* $Id: debug_msg.c,v 1.4 2003/05/06 17:49:23 sacerdoti Exp $ */
#include "gangliaconf.h"

int debug_level = 0;

/**
 * @fn void debug_msg(const char *format, ...)
 * Prints the message to STDERR if DEBUG is #defined
 * @param format The format of the msg (see printf manpage)
 * @param ... Optional arguments
 */
void
debug_msg(const char *format, ...)
{
   if (debug_level > 1 && format)
      {
         va_list ap;
         va_start(ap, format);
         vfprintf(stderr, format, ap);
         fprintf(stderr,"\n");
         va_end(ap);
      } 
   return;
}
