/*
  File autogenerated by gengetopt version 2.22.4
  generated with the following command:
  gengetopt --c-extension=c.in --input ./cmdline.sh 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef FIX_UNUSED
#define FIX_UNUSED(X) (void) (X) /* avoid warnings for unused params */
#endif

#include <getopt.h>

#include "cmdline.h"

const char *gengetopt_args_info_purpose = "The Ganglia Metric Client (gmetric) announces a metric\non the list of defined send channels defined in a configuration file";

const char *gengetopt_args_info_usage = "Usage: gmetric [OPTIONS]...";

const char *gengetopt_args_info_description = "";

const char *gengetopt_args_info_help[] = {
  "  -h, --help            Print help and exit",
  "  -V, --version         Print version and exit",
  "  -c, --conf=STRING     The configuration file to use for finding send channels \n                           (default=`/usr/local/etc/gmond.conf')",
  "  -n, --name=STRING     Name of the metric",
  "  -v, --value=STRING    Value of the metric",
  "  -t, --type=STRING     Either \n                          string|int8|uint8|int16|uint16|int32|uint32|float|double",
  "  -u, --units=STRING    Unit of measure for the value e.g. Kilobytes, Celcius  \n                          (default=`')",
  "  -s, --slope=STRING    Either zero|positive|negative|both  (default=`both')",
  "  -x, --tmax=INT        The maximum time in seconds between gmetric calls  \n                          (default=`60')",
  "  -d, --dmax=INT        The lifetime in seconds of this metric  (default=`0')",
  "  -g, --group=STRING    Group of the metric",
  "  -C, --cluster=STRING  Cluster of the metric",
  "  -D, --desc=STRING     Description of the metric",
  "  -T, --title=STRING    Title of the metric",
  "  -S, --spoof=STRING    IP address and name of host/device (colon separated) we \n                          are spoofing  (default=`')",
  "  -H, --heartbeat       spoof a heartbeat message (use with spoof option)",
    0
};

typedef enum {ARG_NO
  , ARG_STRING
  , ARG_INT
} cmdline_parser_arg_type;

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error);


static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->conf_given = 0 ;
  args_info->name_given = 0 ;
  args_info->value_given = 0 ;
  args_info->type_given = 0 ;
  args_info->units_given = 0 ;
  args_info->slope_given = 0 ;
  args_info->tmax_given = 0 ;
  args_info->dmax_given = 0 ;
  args_info->group_given = 0 ;
  args_info->cluster_given = 0 ;
  args_info->desc_given = 0 ;
  args_info->title_given = 0 ;
  args_info->spoof_given = 0 ;
  args_info->heartbeat_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  FIX_UNUSED (args_info);
  args_info->conf_arg = gengetopt_strdup ("/usr/local/etc/gmond.conf");
  args_info->conf_orig = NULL;
  args_info->name_arg = NULL;
  args_info->name_orig = NULL;
  args_info->value_arg = NULL;
  args_info->value_orig = NULL;
  args_info->type_arg = NULL;
  args_info->type_orig = NULL;
  args_info->units_arg = gengetopt_strdup ("");
  args_info->units_orig = NULL;
  args_info->slope_arg = gengetopt_strdup ("both");
  args_info->slope_orig = NULL;
  args_info->tmax_arg = 60;
  args_info->tmax_orig = NULL;
  args_info->dmax_arg = 0;
  args_info->dmax_orig = NULL;
  args_info->group_arg = NULL;
  args_info->group_orig = NULL;
  args_info->cluster_arg = NULL;
  args_info->cluster_orig = NULL;
  args_info->desc_arg = NULL;
  args_info->desc_orig = NULL;
  args_info->title_arg = NULL;
  args_info->title_orig = NULL;
  args_info->spoof_arg = gengetopt_strdup ("");
  args_info->spoof_orig = NULL;
  
}

static
void init_args_info(struct gengetopt_args_info *args_info)
{


  args_info->help_help = gengetopt_args_info_help[0] ;
  args_info->version_help = gengetopt_args_info_help[1] ;
  args_info->conf_help = gengetopt_args_info_help[2] ;
  args_info->name_help = gengetopt_args_info_help[3] ;
  args_info->value_help = gengetopt_args_info_help[4] ;
  args_info->type_help = gengetopt_args_info_help[5] ;
  args_info->units_help = gengetopt_args_info_help[6] ;
  args_info->slope_help = gengetopt_args_info_help[7] ;
  args_info->tmax_help = gengetopt_args_info_help[8] ;
  args_info->dmax_help = gengetopt_args_info_help[9] ;
  args_info->group_help = gengetopt_args_info_help[10] ;
  args_info->cluster_help = gengetopt_args_info_help[11] ;
  args_info->desc_help = gengetopt_args_info_help[12] ;
  args_info->title_help = gengetopt_args_info_help[13] ;
  args_info->spoof_help = gengetopt_args_info_help[14] ;
  args_info->heartbeat_help = gengetopt_args_info_help[15] ;
  
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n",
     (strlen(CMDLINE_PARSER_PACKAGE_NAME) ? CMDLINE_PARSER_PACKAGE_NAME : CMDLINE_PARSER_PACKAGE),
     CMDLINE_PARSER_VERSION);
}

static void print_help_common(void) {
  cmdline_parser_print_version ();

  if (strlen(gengetopt_args_info_purpose) > 0)
    printf("\n%s\n", gengetopt_args_info_purpose);

  if (strlen(gengetopt_args_info_usage) > 0)
    printf("\n%s\n", gengetopt_args_info_usage);

  printf("\n");

  if (strlen(gengetopt_args_info_description) > 0)
    printf("%s\n\n", gengetopt_args_info_description);
}

void
cmdline_parser_print_help (void)
{
  int i = 0;
  print_help_common();
  while (gengetopt_args_info_help[i])
    printf("%s\n", gengetopt_args_info_help[i++]);
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);
}

void
cmdline_parser_params_init(struct cmdline_parser_params *params)
{
  if (params)
    { 
      params->override = 0;
      params->initialize = 1;
      params->check_required = 1;
      params->check_ambiguity = 0;
      params->print_errors = 1;
    }
}

struct cmdline_parser_params *
cmdline_parser_params_create(void)
{
  struct cmdline_parser_params *params = 
    (struct cmdline_parser_params *)malloc(sizeof(struct cmdline_parser_params));
  cmdline_parser_params_init(params);  
  return params;
}

static void
free_string_field (char **s)
{
  if (*s)
    {
      free (*s);
      *s = 0;
    }
}


static void
cmdline_parser_release (struct gengetopt_args_info *args_info)
{

  free_string_field (&(args_info->conf_arg));
  free_string_field (&(args_info->conf_orig));
  free_string_field (&(args_info->name_arg));
  free_string_field (&(args_info->name_orig));
  free_string_field (&(args_info->value_arg));
  free_string_field (&(args_info->value_orig));
  free_string_field (&(args_info->type_arg));
  free_string_field (&(args_info->type_orig));
  free_string_field (&(args_info->units_arg));
  free_string_field (&(args_info->units_orig));
  free_string_field (&(args_info->slope_arg));
  free_string_field (&(args_info->slope_orig));
  free_string_field (&(args_info->tmax_orig));
  free_string_field (&(args_info->dmax_orig));
  free_string_field (&(args_info->group_arg));
  free_string_field (&(args_info->group_orig));
  free_string_field (&(args_info->cluster_arg));
  free_string_field (&(args_info->cluster_orig));
  free_string_field (&(args_info->desc_arg));
  free_string_field (&(args_info->desc_orig));
  free_string_field (&(args_info->title_arg));
  free_string_field (&(args_info->title_orig));
  free_string_field (&(args_info->spoof_arg));
  free_string_field (&(args_info->spoof_orig));
  
  

  clear_given (args_info);
}


static void
write_into_file(FILE *outfile, const char *opt, const char *arg, const char *values[])
{
  FIX_UNUSED (values);
  if (arg) {
    fprintf(outfile, "%s=\"%s\"\n", opt, arg);
  } else {
    fprintf(outfile, "%s\n", opt);
  }
}


int
cmdline_parser_dump(FILE *outfile, struct gengetopt_args_info *args_info)
{
  int i = 0;

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot dump options to stream\n", CMDLINE_PARSER_PACKAGE);
      return EXIT_FAILURE;
    }

  if (args_info->help_given)
    write_into_file(outfile, "help", 0, 0 );
  if (args_info->version_given)
    write_into_file(outfile, "version", 0, 0 );
  if (args_info->conf_given)
    write_into_file(outfile, "conf", args_info->conf_orig, 0);
  if (args_info->name_given)
    write_into_file(outfile, "name", args_info->name_orig, 0);
  if (args_info->value_given)
    write_into_file(outfile, "value", args_info->value_orig, 0);
  if (args_info->type_given)
    write_into_file(outfile, "type", args_info->type_orig, 0);
  if (args_info->units_given)
    write_into_file(outfile, "units", args_info->units_orig, 0);
  if (args_info->slope_given)
    write_into_file(outfile, "slope", args_info->slope_orig, 0);
  if (args_info->tmax_given)
    write_into_file(outfile, "tmax", args_info->tmax_orig, 0);
  if (args_info->dmax_given)
    write_into_file(outfile, "dmax", args_info->dmax_orig, 0);
  if (args_info->group_given)
    write_into_file(outfile, "group", args_info->group_orig, 0);
  if (args_info->cluster_given)
    write_into_file(outfile, "cluster", args_info->cluster_orig, 0);
  if (args_info->desc_given)
    write_into_file(outfile, "desc", args_info->desc_orig, 0);
  if (args_info->title_given)
    write_into_file(outfile, "title", args_info->title_orig, 0);
  if (args_info->spoof_given)
    write_into_file(outfile, "spoof", args_info->spoof_orig, 0);
  if (args_info->heartbeat_given)
    write_into_file(outfile, "heartbeat", 0, 0 );
  

  i = EXIT_SUCCESS;
  return i;
}

int
cmdline_parser_file_save(const char *filename, struct gengetopt_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  i = cmdline_parser_dump(outfile, args_info);
  fclose (outfile);

  return i;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  cmdline_parser_release (args_info);
}

/** @brief replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = 0;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char **argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser_ext (int argc, char **argv, struct gengetopt_args_info *args_info,
                   struct cmdline_parser_params *params)
{
  int result;
  result = cmdline_parser_internal (argc, argv, args_info, params, 0);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser2 (int argc, char **argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;
  struct cmdline_parser_params params;
  
  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  result = cmdline_parser_internal (argc, argv, args_info, &params, 0);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required (struct gengetopt_args_info *args_info, const char *prog_name)
{
  FIX_UNUSED (args_info);
  FIX_UNUSED (prog_name);
  return EXIT_SUCCESS;
}


static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see cmdline_parser_params.check_ambiguity
 * @param override @see cmdline_parser_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
               unsigned int *field_given, unsigned int *prev_given, 
               char *value, const char *possible_values[],
               const char *default_value,
               cmdline_parser_arg_type arg_type,
               int check_ambiguity, int override,
               int no_free, int multiple_option,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  char *stop_char = 0;
  const char *val = value;
  int found;
  char **string_field;
  FIX_UNUSED (field);

  stop_char = 0;
  found = 0;

  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: `--%s' (`-%c') option given more than once%s\n", 
               package_name, long_opt, short_opt,
               (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: `--%s' option given more than once%s\n", 
               package_name, long_opt,
               (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

  FIX_UNUSED (default_value);
    
  if (field_given && *field_given && ! override)
    return 0;
  if (prev_given)
    (*prev_given)++;
  if (field_given)
    (*field_given)++;
  if (possible_values)
    val = possible_values[found];

  switch(arg_type) {
  case ARG_INT:
    if (val) *((int *)field) = strtol (val, &stop_char, 0);
    break;
  case ARG_STRING:
    if (val) {
      string_field = (char **)field;
      if (!no_free && *string_field)
        free (*string_field); /* free previous string */
      *string_field = gengetopt_strdup (val);
    }
    break;
  default:
    break;
  };

  /* check numeric conversion */
  switch(arg_type) {
  case ARG_INT:
    if (val && !(stop_char && *stop_char == '\0')) {
      fprintf(stderr, "%s: invalid numeric value: %s\n", package_name, val);
      return 1; /* failure */
    }
    break;
  default:
    ;
  };

  /* store the original value */
  switch(arg_type) {
  case ARG_NO:
    break;
  default:
    if (value && orig_field) {
      if (no_free) {
        *orig_field = value;
      } else {
        if (*orig_field)
          free (*orig_field); /* free previous string */
        *orig_field = gengetopt_strdup (value);
      }
    }
  };

  return 0; /* OK */
}


int
cmdline_parser_internal (
  int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  int error = 0;
  struct gengetopt_args_info local_args_info;
  
  int override;
  int initialize;
  int check_required;
  int check_ambiguity;
  
  package_name = argv[0];
  
  override = params->override;
  initialize = params->initialize;
  check_required = params->check_required;
  check_ambiguity = params->check_ambiguity;

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = params->print_errors;
  optopt = '?';

  while (1)
    {
      int option_index = 0;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "conf",	1, NULL, 'c' },
        { "name",	1, NULL, 'n' },
        { "value",	1, NULL, 'v' },
        { "type",	1, NULL, 't' },
        { "units",	1, NULL, 'u' },
        { "slope",	1, NULL, 's' },
        { "tmax",	1, NULL, 'x' },
        { "dmax",	1, NULL, 'd' },
        { "group",	1, NULL, 'g' },
        { "cluster",	1, NULL, 'C' },
        { "desc",	1, NULL, 'D' },
        { "title",	1, NULL, 'T' },
        { "spoof",	1, NULL, 'S' },
        { "heartbeat",	0, NULL, 'H' },
        { 0,  0, 0, 0 }
      };

      c = getopt_long (argc, argv, "hVc:n:v:t:u:s:x:d:g:C:D:T:S:H", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          cmdline_parser_print_help ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          cmdline_parser_print_version ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'c':	/* The configuration file to use for finding send channels.  */
        
        
          if (update_arg( (void *)&(args_info->conf_arg), 
               &(args_info->conf_orig), &(args_info->conf_given),
              &(local_args_info.conf_given), optarg, 0, "/usr/local/etc/gmond.conf", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "conf", 'c',
              additional_error))
            goto failure;
        
          break;
        case 'n':	/* Name of the metric.  */
        
        
          if (update_arg( (void *)&(args_info->name_arg), 
               &(args_info->name_orig), &(args_info->name_given),
              &(local_args_info.name_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "name", 'n',
              additional_error))
            goto failure;
        
          break;
        case 'v':	/* Value of the metric.  */
        
        
          if (update_arg( (void *)&(args_info->value_arg), 
               &(args_info->value_orig), &(args_info->value_given),
              &(local_args_info.value_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "value", 'v',
              additional_error))
            goto failure;
        
          break;
        case 't':	/* Either string|int8|uint8|int16|uint16|int32|uint32|float|double.  */
        
        
          if (update_arg( (void *)&(args_info->type_arg), 
               &(args_info->type_orig), &(args_info->type_given),
              &(local_args_info.type_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "type", 't',
              additional_error))
            goto failure;
        
          break;
        case 'u':	/* Unit of measure for the value e.g. Kilobytes, Celcius.  */
        
        
          if (update_arg( (void *)&(args_info->units_arg), 
               &(args_info->units_orig), &(args_info->units_given),
              &(local_args_info.units_given), optarg, 0, "", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "units", 'u',
              additional_error))
            goto failure;
        
          break;
        case 's':	/* Either zero|positive|negative|both.  */
        
        
          if (update_arg( (void *)&(args_info->slope_arg), 
               &(args_info->slope_orig), &(args_info->slope_given),
              &(local_args_info.slope_given), optarg, 0, "both", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "slope", 's',
              additional_error))
            goto failure;
        
          break;
        case 'x':	/* The maximum time in seconds between gmetric calls.  */
        
        
          if (update_arg( (void *)&(args_info->tmax_arg), 
               &(args_info->tmax_orig), &(args_info->tmax_given),
              &(local_args_info.tmax_given), optarg, 0, "60", ARG_INT,
              check_ambiguity, override, 0, 0,
              "tmax", 'x',
              additional_error))
            goto failure;
        
          break;
        case 'd':	/* The lifetime in seconds of this metric.  */
        
        
          if (update_arg( (void *)&(args_info->dmax_arg), 
               &(args_info->dmax_orig), &(args_info->dmax_given),
              &(local_args_info.dmax_given), optarg, 0, "0", ARG_INT,
              check_ambiguity, override, 0, 0,
              "dmax", 'd',
              additional_error))
            goto failure;
        
          break;
        case 'g':	/* Group of the metric.  */
        
        
          if (update_arg( (void *)&(args_info->group_arg), 
               &(args_info->group_orig), &(args_info->group_given),
              &(local_args_info.group_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "group", 'g',
              additional_error))
            goto failure;
        
          break;
        case 'C':	/* Cluster of the metric.  */
        
        
          if (update_arg( (void *)&(args_info->cluster_arg), 
               &(args_info->cluster_orig), &(args_info->cluster_given),
              &(local_args_info.cluster_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "cluster", 'C',
              additional_error))
            goto failure;
        
          break;
        case 'D':	/* Description of the metric.  */
        
        
          if (update_arg( (void *)&(args_info->desc_arg), 
               &(args_info->desc_orig), &(args_info->desc_given),
              &(local_args_info.desc_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "desc", 'D',
              additional_error))
            goto failure;
        
          break;
        case 'T':	/* Title of the metric.  */
        
        
          if (update_arg( (void *)&(args_info->title_arg), 
               &(args_info->title_orig), &(args_info->title_given),
              &(local_args_info.title_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "title", 'T',
              additional_error))
            goto failure;
        
          break;
        case 'S':	/* IP address and name of host/device (colon separated) we are spoofing.  */
        
        
          if (update_arg( (void *)&(args_info->spoof_arg), 
               &(args_info->spoof_orig), &(args_info->spoof_given),
              &(local_args_info.spoof_given), optarg, 0, "", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "spoof", 'S',
              additional_error))
            goto failure;
        
          break;
        case 'H':	/* spoof a heartbeat message (use with spoof option).  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->heartbeat_given),
              &(local_args_info.heartbeat_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "heartbeat", 'H',
              additional_error))
            goto failure;
        
          break;

        case 0:	/* Long option with no short option */
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */




  cmdline_parser_release (&local_args_info);

  if ( error )
    return (EXIT_FAILURE);

  return 0;

failure:
  
  cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}
