''' -*- python -*-                        vim:set ts=4 sw=4:

    FILE: "/home/life/projects/garchiver/garchiver-0.5/src/zip.py"
    LAST MODIFICATION: "Wed, 26 Sep 2001 02:19:53 +0200 (life)"

    Copyright (C) 2000 by Eckard Meyer
    Changes and fixes made by Danie Roux, 2001

    $Id: zip.py,v 1.33 2001/07/04 13:00:09 uid43216 Exp $
'''

from archive import *
import os
import string
import popen2
# Testing Files and directories
import stat
# System information
import sys

# Used for Multiple Language Support
import gettext
_ = gettext.gettext

from settings import *

class Zip (Archive):

    def __init__ (self, name, cb1, cb2, cb3):
        '''
        Inits the archive with it's filename. This is the constructor of the ZIP class
        called from the GUI to init all variables used futher down the class
        name: Full path and name to archive
        '''
        Archive.__init__ (self, name, cb1, cb2, cb3)

        self.list_cmd = PS ('unzip_path') +  ' -Zl '
        self.extract_cmd = PS ('unzip_path') + ' -u '
        self.add_cmd = PS ('zip_path') + ' -r '
        self.view_cmd = PS ('unzip_path') +  ' -p '
        self.remove_cmd = PS ('zip_path') + ' -d '

        # When this is TRUE, the files can be returned without executing
        self.listed = FALSE

        self.files = []
        self.folders = []
        self.new_archive = FALSE # By default

    def available (self):
        # TODO Make it possible to extract files even though you do not
        # have zip. It's time to create a new class of archive:
        # Extractable.
        return os.access (PS ('zip_path'), os.X_OK)

    def new (self):
        ''' Creates a brand new archive.'''
        self.new_archive = TRUE

    def list (self):
        if self.listed: return self.files
        if self.new_archive: return []

        self.files = []

        errors_in_stdin = FALSE

        self.log = self.list_cmd + ' ' + self.name + '\n'

        self.error_log = ''

         # Construct the system call parameters
        cmd = self.list_cmd + '"' + self.name + '"'

        # connect to the OS pipes to execute the command
        (child_in, child_out, child_err) = popen2.popen3 (cmd)

        child_out.close ()

        # Get header information out of the way. And if the archive
        # doesn't exist, as is the case when a new one is created, there
        # will also be one line of text, and the while will thus never be
        # executed
        child_in.readline ()

        while 1:
            line = child_in.readline ()
            if line == '': raise 'No line read! Something wrong in zip.py.'

            line = string.strip (line)
            self.log = self.log + '\n' + line

            try:
                # split into a number of fields
                try:
                    (Permissions, na, os, size, end_flag, compressed_size, \
                        na2, date, time, pathname) = string.split (line, None, 9)

                except ValueError:
                    # Hit the end of the listing. This would be useful
                    # information for the status bar TODO
                    # Reason I'm not returning it just like this, is cause
                    # we may want to translate it
                    if (line [-1:] == '%'): # It is the end
                        (no_files, na1, bytes, na2, na3, \
                            bytes_compressed, na4, na5, ratio) = \
                                string.split (line)
                        break
                    # No, crc error or something. Raise it
                    else:
                        # Do ugly quit loop
                        raise ValueError

                if (Permissions [0] == 'd'): # Directory
                    self.folders.append (pathname)

                elif (Permissions [0] == 'l'): # Link
                    # TODO think of a strategy for links
                    pass

                else: # File
                    pos = string.rfind (pathname, '/')
                    if pos != -1:
                        path = pathname [:pos]
                        name = pathname [pos+1:]
                    else:
                        path = ''
                        name = pathname

                    self.files.append \
                        ([name, size, path, date, time, Permissions, \
                            compressed_size])

            except:
                stdin_errs = child_in.readlines ()
                try: self.log = self.log + reduce (lambda x, y: x+y, stdin_errs)
                except: pass
                errors_in_stdin = TRUE
                break

        errs = child_err.readlines ()

        try:
            self.error (reduce (lambda x, y: x+y, errs), self.log)
        except:
            if errors_in_stdin:
                self.error (_("Error occurred! See Log."), self.log)

        # The length of the list
        self.number_of_files = len (self.files)

        self.listed = TRUE

        # Return the list containing all the files
        return self.files

    def list_dir (self):
        ''' list builds self.folders as well. So call it '''

        if not self.listed: self.list ()
        if self.new_archive: return []

        return self.folders

    def extract (self, target_dir, with_path, files):
        '''
        Call this with a path and a tuple of files
        target_dir : Where to extract the archive to
        with_path: boolean which tells whether the files should be
                    extracted with full paths or not.
        files: The individual files to extract. If this is the empty
                list [], extract everything
        '''

        if self.new_archive: 
            self.error (_("Can't extract from this archive, it's brand new!'"))
            return

        self.log = ''
        self.error_log = ''

        # Create a copy of the current working directory
        old_dir = os.getcwd ()
        # Change to the directory specified by the user
        os.chdir (target_dir)

        if not with_path: flags = " -j "
        else: flags = ""

        # This command overrides existing files
        if (files == []):
            # Create the command
            cmd = self.extract_cmd + flags + '"' + self.name + '"'
            self.log = cmd + '\n'
            # connect to the OS pipes to execute the command
            (child_in, child_out, child_err) = popen2.popen3 (cmd)
            lines = child_in.readlines ()
            child_in.close ()
            err = child_err.readlines ()
            child_err.close ()

        else:
            i = 0
            while i < len (files):
                temp = files[i]
                if temp[0] == '/':
                    cmd = self.extract_cmd + flags + '"' + self.name + '" ' + temp[1:]
                else:
                    cmd = self.extract_cmd + flags + '"' + self.name + '" ' + files[i]
                self.log = self.log + '\n' + cmd
                # connect to the OS pipes to execute the command
                (child_in, child_out, child_err) = popen2.popen3 (cmd)
                lines = child_in.readlines ()
                child_in.close ()
                err = child_err.readlines ()
                child_err.close ()
                i = i + 1

        # Change to the old directory were we started off
        os.chdir (old_dir)

        # TODO Nowhere does any of the actions gets parsed ???
        if self.error_log != '':
            self.error (self.error_log, self.log)
            self.error_log = ''

    def list_headers (self):
        ''' Used by the GUI to add more fields to the file listing widget
        '''
        return [_("Permissions"), ("Compressed size")]

    def _add_and_remove_meat (self, action_cmd, files):
        ''' Shared code between add and remove. All that differs here is
            the cmd. '''

        self.listed = FALSE

        self.log = ''
        self.error_log = ''

        all_files = reduce (lambda x, y: x + '" "' + y, files)
        all_files = '"' + all_files + '"'

        cmd = action_cmd + '"'+ self.name + '" ' + all_files

        self.log = self.log + cmd + '\n'

        (child_in, child_out, child_err) = popen2.popen3 (cmd)

        child_out.close ()

        lines = child_in.readlines ()
        err = child_err.readlines ()

        try: self.log = self.log + '\n' + reduce (lambda x, y: x + y, lines)
        except: pass

        child_in.close ()
        child_err.close ()

        if err != []:
            self.error (reduce (lambda x, y: x + y, err), self.log)
            self.error_log = ''

    def remove (self, files):
        self._add_and_remove_meat (self.remove_cmd, files)

    def add (self, files, from_where_to_add = '/', where_in_archive = '/', flags = ''):
        # Save the current directory
        old = os.getcwd ()
        os.chdir (from_where_to_add)

        self._add_and_remove_meat (self.add_cmd + flags, files)

        # Change back to the old directory
        os.chdir (old)

        self.new_archive = FALSE

    def get_log (self):
        '''
        Return the log file so that the GUI can display it on
        the request of the user in a dialog box
        '''
        return self.log

    def view (self, file):
        '''
        Simply create a tmp file to be viewed on user request
        file : File to be viewed
        '''
        tmp = self.make_tempfile (file)
        cmd = self.view_cmd + '"' + self.name + '" "' + file + '" >' + tmp
        self.log = cmd + '\n'

        (child_in, child_out, child_err) = popen2.popen3 (cmd)
        child_out.close ()

        lines = child_in.readlines ()
        child_in.close ()
        err = child_err.readlines ()
        child_err.close ()

        if err != []:
            self.error (reduce (lambda x, y: x + y, err), self.log)

        return tmp

if __name__ == '__main__':
    zip = Zip ('test.zip', None, None, None)
    zip.add (['tests/file1', 'tests/file2'])
