/* sqlqueryexec.h
 *
 * Copyright (C) 2001 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __SQL_QUERY_EXEC__
#define __SQL_QUERY_EXEC__

#include <gnome.h>
#include "sqlqueryenv.h"
#include "sqlqueryres.h"

#ifdef __cplusplus
extern "C"
{
#endif				/* __cplusplus */

#define SQL_QUERY_EXEC(obj)          GTK_CHECK_CAST (obj, sql_query_exec_get_type(), SqlQueryExec)
#define SQL_QUERY_EXEC_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, sql_query_exec_get_type (), SqlQueryExecClass)
#define IS_SQL_QUERY_EXEC(obj)       GTK_CHECK_TYPE (obj, sql_query_exec_get_type ())

	typedef struct _ExecEntity ExecEntity;
	typedef struct _SqlQueryExec SqlQueryExec;
	typedef struct _SqlQueryExecClass SqlQueryExecClass;

	struct _ExecEntity
	{
		GtkWidget *entity;
		GtkWidget *dlg;
	};

	/* struct for the object's data */
	struct _SqlQueryExec
	{
		GtkObject object;

		SqlQuery *q;	/* q is a copy of env->q, so here is a ref to the q to be used */
		SqlQueryEnv *env;
		SqlQueryRes *qres;

		/* private data */
		GtkWidget *missing_data_dlg;	/* dialog to ask for missing values */
		GSList *missing_data;
		gchar *query;	/* query once it has been created */
		GSList *exec_entities;
	};

	/* struct for the object's class */
	struct _SqlQueryExecClass
	{
		GtkObjectClass parent_class;

		void (*not_valid) (SqlQueryExec * qe);
	};

	/* generic widget's functions */
	guint sql_query_exec_get_type (void);
	GtkObject *sql_query_exec_new (SqlQueryEnv * env);

	/* services */
	void sql_query_exec_run (SqlQueryExec * exec);
	GtkWidget *sql_query_exec_get_consult_widget (SqlQueryExec * exec);
	GtkWidget *sql_query_exec_get_consult_grid (SqlQueryExec * exec);
	GtkWidget *sql_query_exec_get_insert_widget (SqlQueryExec * exec);

	/* helper function to build forms or grids */
	GtkWidget *sql_query_exec_get_action_buttons (SqlQueryExec * exec);
#ifdef __cplusplus
}
#endif				/* __cplusplus */

#endif
