import os
import shutil
import sys
import string

from Tkinter import *
from folder import folder
from tempfile import mkstemp

def EDDM(screen,checkfile,trans,cubmanbin,formchkbin,cubegenbin):

    screen.write("Starting EDDM.py\n")

    # Create the output directory if necessary
    gaussdir=folder(screen,checkfile)

    # Parse the transitions (and try to catch some possible errors)
    list=[]
    temp=trans.split(',')
    try:
        for x in temp:
            t=x.split('-')
            if len(t)==1:
                list.append(int(t[0]))
            elif len(t)==2:
                list+=range(int(t[0]),int(t[1])+1)
            else:
                screen.write("There's something wrong with the specified range.\n")
                return False
    except ValueError: # Raised by int("a") or int("1.5")
        screen.write("You need to use integers to specify the range.\n")
        return False

    screen.write("You specified the following transitions: %s\n" % " ".join(map(str,list)) )

# Format the checkpoint file
    extension=os.path.splitext(checkfile.filename)[1]
    
    if extension==".chk":
        t="%s %s %s" % (formchkbin,checkfile.filename,os.path.join(gaussdir,"chkpoint.fch"))
        screen.write("Formatting %s with the following command:\n   %s\n" % (checkfile.filename,t) )        
        os.system(t)
        formchk=os.path.join(gaussdir,"chkpoint.fch")
        if not os.path.isfile(formchk):
            screen.write("Formatting the checkpoint file failed. \
Try formatting it yourself using formchk, and then open \
the formatted file using GaussSum.")
            return False
    elif extension==".fch":
        formchk=checkfile.filename
    else:
        screen.write( "You need to use a checkpoint file. It may be either formatted or \
unformatted. %s is neither.\n" % checkfile.filename )
        return False

# Get information from UVData.txt
    uvdata=os.path.join(gaussdir,"UVData.txt")
    try:
        inputfile=open(uvdata,"r")
    except IOError:
        screen.write("Can't open %s! This file is necessary for EDDM.py. \
It is created by UVVis.py from a TD-DFT calculation.\n" % uvdata)
        return False
    
    # HOMO will be the Gaussian03 number for the HOMO
    HOMO=int(inputfile.readline().strip().split()[2])
    UVinfo=inputfile.readlines()
    inputfile.close()
    
# For every transition, calculate the EDDM
    for x in list:
        if x>len(UVinfo):
            screen.write("UVData.txt does not contain information on transition number %d\n" % x)
            return False
        line=UVinfo[x]
        screen.write("Calculating EDDM for transition number %d\n\n" % x)
        screen.write(UVinfo[0]+line)

        temp=line.strip().split('\t')

        data=temp[5]

        if len(temp[6])>0: # if there are minor contributions
            data+=","+temp[6] # e.g. "H-2->LUMO (74%), H-2->L+2 (12%), H-1->L+1 (12%)"

        contrib=data.split(',') # e.g. "H-2->LUMO (74%)"

        con=[]
        totalcon=0
        for y in contrib:
            temp=y.split() # "H-2->LUMO","(74%)"
            moretemp=temp[0].split("->") # "H-2","LUMO"
            before=level(moretemp[0],HOMO)
            after=level(moretemp[1],HOMO)
            percent=int(temp[1].strip("()%"))/100. # 0.74
            if percent<0:
                percent=-percent # i.e. ignore the phase!
            totalcon=totalcon+percent
            con.append([before,after,percent])
        screen.write("The contributions add to "+str(totalcon)+".\n")
                
        # Create the MO cube files
        screen.write("Creating any neccesary MO cube files\n")
        for i in range(len(con)):
            before=con[i][0]; after=con[i][1]
            beforecub=os.path.join(gaussdir,"mo"+before+".cub")
            aftercub=os.path.join(gaussdir,"mo"+after+".cub")
            if os.path.isfile(beforecub)==False:
                screen.write("Creating %s\n" % beforecub)
                t="%s 0 MO=%s %s %s -2 h" % (cubegenbin,before,formchk,beforecub)
                os.system(t)
            if os.path.isfile(aftercub)==False:
                screen.write("Creating %s\n" % aftercub)
                t="%s 0 MO=%s %s %s -2 h" % (cubegenbin,after,formchk,aftercub)                
                os.system(t)

                
        # Square them
        screen.write("Squaring the cube files, if the square does not exist\n")
        for i in range(len(con)):
            before=con[i][0]; after=con[i][1]
            if os.path.isfile(os.path.join(gaussdir,"sq"+before+".cub"))==False:
                cubman(screen,gaussdir,["sq","mo"+before+".cub","y","sq"+before+".cub","y"],cubmanbin)
            if os.path.isfile(os.path.join(gaussdir,"sq"+after+".cub"))==False:
                cubman(screen,gaussdir,["sq","mo"+after+".cub","y","sq"+after+".cub","y"],cubmanbin)

        # Create the first before and after
        screen.write("\nRunning cubman with the following parameters:\n")
        before=con[0][0]; after=con[0][1]; scale=str(con[0][2]/(totalcon*totalcon))
        cubman(screen,gaussdir,["sc","sq"+before+".cub","y","before.cub","y",scale],cubmanbin)
        cubman(screen,gaussdir,["sc","sq"+after+".cub","y","after.cub","y",scale],cubmanbin)

        # Add the rest of the contribs
        for i in range(1,len(con)):
            before=con[i][0]; after=con[i][1]; scale=str(con[i][2]/(totalcon*totalcon))
            cubman(screen,gaussdir,["sc","sq"+before+".cub","y","tmp.cub","y",scale],cubmanbin)
            cubman(screen,gaussdir,["a","tmp.cub","y","before.cub","y","tmp2.cub","y"],cubmanbin)
            shutil.move(os.path.join(gaussdir,"tmp2.cub"),os.path.join(gaussdir,"before.cub"))
            cubman(screen,gaussdir,["sc","sq"+after+".cub","y","tmp.cub","y",scale],cubmanbin)
            cubman(screen,gaussdir,["a","tmp.cub","y","after.cub","y","tmp2.cub","y"],cubmanbin)
            shutil.move(os.path.join(gaussdir,"tmp2.cub"),os.path.join(gaussdir,"after.cub"))

            os.remove(os.path.join(gaussdir,"tmp.cub"))

        # Create the EDDM
        screen.write("Creating the EDDM\n\n")
        cubman(screen,gaussdir,["su","before.cub","y","after.cub","y","trans"+str(x)+".cub","y"],cubmanbin)
        os.remove(os.path.join(gaussdir,"before.cub"))
        os.remove(os.path.join(gaussdir,"after.cub"))

    if formchk=="chkpoint.fch":
        os.remove(os.path.join(gaussdir,"chkpoint.fch"))
    screen.write("Finishing EDDM.py\n")


def level(name,HOMO):
    if name=="HOMO":
        return str(HOMO)
    elif name=="LUMO":
        return str(HOMO+1)

    start=name[0:2]
    end=int(name[2:])

    if start=="H-":
        return str(HOMO-end)
    else:
        return str(HOMO+end+1)
        
        
def cubman(screen,gaussdir,list,cubmanbin):
    # Runs cubman
    screen.write(" ".join(list)+"\n")
    tmpfiledes,tmpfilename=mkstemp()
    tmpfile=open(tmpfilename,"w")
    for x in list:
        if x.find(".cub")>=0: # modify all the filenames
            x=os.path.join(gaussdir,x)
        tmpfile.write(x+"\n")
    tmpfile.close()
    stdout,stdin,stderr=os.popen3("cat %s | %s" % (tmpfilename,cubmanbin) )
    temp=string.join(stdin.readlines())
    os.close(tmpfiledes)
    os.remove(tmpfilename)

# The start
if __name__=="__main__": # SCF.py is being run (not imported)

    EDDM(sys.stdout,"tmp","1,2-5,7")

