/*
 * Gnome-biff program
 * Version:  2.6
 * Copyright (C) 2000-2001  Nicolas Rougier
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifdef USE_GNOME
#  include <gnome.h>
#  include <applet-widget.h>
#endif
#include <gtk/gtk.h>

#ifndef __CALLBACKS_H
#define __CALLBACKS_H

/* Mailbox toplevel */
gboolean on_Mailbox_delete (GtkObject *object, GdkEvent *event, gpointer user_data);
void on_TitleEntry_changed (GtkEditable *editable, gpointer user_data);
void on_ProtocolRadioFile_toggled (GtkToggleButton *togglebutton, gpointer user_data);
void on_ProtocolRadioMaildir_toggled (GtkToggleButton *togglebutton, gpointer user_data);
void on_ProtocolRadioPop3_toggled (GtkToggleButton *togglebutton, gpointer user_data);
void on_ProtocolRadioImap4_toggled (GtkToggleButton *togglebutton, gpointer user_data);
void on_ProtocolRadioMh_toggled (GtkToggleButton *togglebutton, gpointer user_data);
void on_UserEntry_changed (GtkEditable *editable, gpointer user_data);
void on_PasswordEntry_changed (GtkEditable *editable, gpointer user_data);
void on_AddressEntry_changed (GtkEditable *editable, gpointer user_data);
void on_AddressButton_clicked (GtkButton  *button, gpointer user_data);
void on_PollTimeSpin_changed (GtkEditable *editable, gpointer user_data);
void on_PopTimeSpin_changed (GtkEditable *editable, gpointer user_data);
void on_PopupGeometryXSpin_changed (GtkEditable *editable, gpointer user_data);
void on_PopupGeometryYSpin_changed (GtkEditable *editable, gpointer user_data);
void on_WindowGeometryXSpin_changed (GtkEditable *editable, gpointer user_data);
void on_WindowGeometryYSpin_changed (GtkEditable *editable, gpointer user_data);
void on_OptionsNoDateCheck_toggled (GtkToggleButton *togglebutton, gpointer user_data);
void on_OptionsNoPopupCheck_toggled (GtkToggleButton *togglebutton, gpointer user_data);
void on_OptionsNoTitleCheck_toggled (GtkToggleButton *togglebutton, gpointer user_data);
void on_OptionsNoSoundCheck_toggled (GtkToggleButton *togglebutton, gpointer user_data);
void on_SoundButton_clicked (GtkButton *button, gpointer user_data);
void on_SoundPlayButton_clicked (GtkButton *button, gpointer user_data);
void on_FontButton_clicked (GtkButton *button, gpointer user_data);
gboolean on_MailEventBox_button_press_event (GtkWidget *widget, GdkEventButton *event, gpointer user_data);
gboolean on_NoMailEventBox_button_press_event (GtkWidget *widget, GdkEventButton *event, gpointer user_data);
void on_OkButton_clicked (GtkButton *button, gpointer user_data);
void on_QuitButton_clicked (GtkButton *button, gpointer user_data);
void on_SuspendButton_clicked (GtkButton *button, gpointer user_data);

/* Font selection dialog */
gboolean on_FontSelectionDialog_delete (GtkObject *object, GdkEvent *event, gpointer user_data);
void on_FontSelectionDialogOkButton_clicked (GtkButton *button, gpointer user_data);
void on_FontSelectionDialogCancelButton_clicked (GtkButton *button, gpointer user_data);
void on_FontSelectionDialogApplyButton_clicked (GtkButton *button, gpointer user_data);

/* File selection dialog */
gboolean on_FileSelectionDialog_delete (GtkObject *object, GdkEvent *event, gpointer user_data);
void on_FileSelectionDialogOkButton_clicked (GtkButton *button, gpointer user_data);
void on_FileSelectionDialogCancelButton_clicked (GtkButton *button, gpointer user_data);

/* Popup */
gboolean on_Popup_button_press_event (GtkWidget *widget, GdkEventCrossing *event, gpointer user_data);
gboolean on_Popup_enter_notify_event (GtkWidget *widget, GdkEventCrossing *event, gpointer user_data);
gboolean on_Popup_leave_notify_event (GtkWidget *widget, GdkEventCrossing *event, gpointer user_data);

/* Window */
gboolean on_Window_leave_notify_event (GtkWidget *widget, GdkEventCrossing *event, gpointer user_data);
gboolean on_WindowDrawingArea_expose (GtkWidget *widget, GdkEventExpose *event, gpointer user_data);
gboolean on_WindowDrawingArea_configure (GtkWidget *widget, GdkEventConfigure *event, gpointer user_data);
gboolean on_WindowDrawingArea_button_press (GtkWidget *widget, GdkEventButton *event,  gpointer user_data);
gboolean on_WindowDrawingArea_button_release (GtkWidget *widget, GdkEventButton *event,  gpointer user_data);


/* Applet */
gboolean on_Applet_remove_event (GtkWidget *widget, GdkEvent *event, gpointer user_data);
void on_Applet_PropertiesMenu_selection (GtkWidget *widget, gpointer user_data);
gboolean on_AppletEventBox_button_press_event (GtkWidget *widget, GdkEventButton *event, gpointer user_data);
gboolean on_AppletEventBox_button_release_event (GtkWidget *widget, GdkEventButton *event, gpointer user_data);
#ifdef USE_GNOME
void on_Applet_AboutMenu_selection (GtkWidget *widget, gpointer user_data);
void on_Applet_change_pixel_size (GtkWidget *widget, int size, gpointer user_data);
void on_Applet_change_orient (GtkWidget *widget, PanelOrientType orient, gpointer user_data);
#endif

/* Timer */
gboolean on_TimeoutPoll_event (gpointer user_data);
gboolean on_TimeoutPop_event (gpointer user_data);

#endif /* __CALLBACKS_H */
