/* Checker stubs for functions defined in libpq
   Copyright (C) 1999 Free Software Foundation, Inc.
   Written by Ben Pfaff <blp@gnu.org>.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA. */

#include "available-stubs.h"

#include <libpq-fe.h>
#include "checker_api.h"

#if 0
/* Broken in Debian woody. */
#include <libpq-int.h>
#else
struct pg_conn { int x; };
struct pg_result { int x; };
#endif

#define CHKR_CHECK_STREAM(s) \
  stubs_chkr_check_addr (s, sizeof (FILE), CHKR_TW, "stream")

#ifdef HAVE_PQconnectdb
/* From `/usr/include/postgresql/libpq-fe.h:153'.  */
PGconn * chkr_stub_PQconnectdb (const char * arg0) __asm__ (CHKR_PREFIX ("PQconnectdb"));
PGconn *
chkr_stub_PQconnectdb (const char *conninfo)
{
  /* This function requires a stub */
  if (conninfo)
    stubs_chkr_check_str (conninfo, CHKR_RO, "conninfo");
  {
    PGconn * res;
    res = PQconnectdb (conninfo);
    if (res)
      stubs_chkr_set_right (res, sizeof *res, CHKR_RO);
    return res;
  }
}
#endif /* HAVE_PQconnectdb */

#ifdef HAVE_PQsetdbLogin
/* From `/usr/include/postgresql/libpq-fe.h:157'.  */
PGconn * chkr_stub_PQsetdbLogin (const char * arg0, const char * arg1, const char * arg2, const char * arg3, const char * arg4, const char * arg5, const char * arg6) __asm__ (CHKR_PREFIX ("PQsetdbLogin"));
PGconn *
chkr_stub_PQsetdbLogin (const char *pghost, const char *pgport, const char *pgoptions, const char *pgtty, const char *dbName, const char *login, const char *pwd)
{
  /* This function requires a stub */
  if (pghost)
    stubs_chkr_check_str (pghost, CHKR_RO, "pghost");
  if (pgport)
    stubs_chkr_check_str (pgport, CHKR_RO, "pgport");
  if (pgoptions)
    stubs_chkr_check_str (pgoptions, CHKR_RO, "pgoptions");
  if (pgtty)
    stubs_chkr_check_str (pgtty, CHKR_RO, "pgtty");
  if (dbName)
    stubs_chkr_check_str (dbName, CHKR_RO, "dbName");
  if (login)
    stubs_chkr_check_str (login, CHKR_RO, "login");
  if (pwd)
    stubs_chkr_check_str (pwd, CHKR_RO, "pwd");
  
  {
    PGconn * res;
    res = PQsetdbLogin (pghost, pgport, pgoptions, pgtty, dbName, login, pwd);
    if (res)
      stubs_chkr_set_right (res, sizeof *res, CHKR_RO);
    return res;
  }
}
#endif /* HAVE_PQsetdbLogin */

#ifdef HAVE_PQconndefaults
/* From `/usr/include/postgresql/libpq-fe.h:162'.  */
PQconninfoOption * chkr_stub_PQconndefaults (void ) __asm__ (CHKR_PREFIX ("PQconndefaults"));
PQconninfoOption *
chkr_stub_PQconndefaults (void )
{
  PQconninfoOption * res;
  res = PQconndefaults ();
  if (res)
    stubs_chkr_set_right (res, sizeof *res, CHKR_RW);
  return res;
}
#endif /* HAVE_PQconndefaults */

#ifdef HAVE_PQfinish
/* From `/usr/include/postgresql/libpq-fe.h:165'.  */
void chkr_stub_PQfinish (PGconn * arg0) __asm__ (CHKR_PREFIX ("PQfinish"));
void
chkr_stub_PQfinish (PGconn * conn)
{
  stubs_chkr_check_addr (conn, sizeof (PGconn), CHKR_RO, "conn");
#if USE_BI_JUMP
  __builtin_jump (PQfinish);
#else
  PQfinish (conn);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_PQfinish */

#ifdef HAVE_PQreset
/* From `/usr/include/postgresql/libpq-fe.h:171'.  */
void chkr_stub_PQreset (PGconn * arg0) __asm__ (CHKR_PREFIX ("PQreset"));
void
chkr_stub_PQreset (PGconn * conn)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (conn, sizeof (PGconn), CHKR_RO, "conn");
#if USE_BI_JUMP
  __builtin_jump (PQreset);
#else
  PQreset (conn);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_PQreset */

#ifdef HAVE_PQrequestCancel
/* From `/usr/include/postgresql/libpq-fe.h:174'.  */
int chkr_stub_PQrequestCancel (PGconn * arg0) __asm__ (CHKR_PREFIX ("PQrequestCancel"));
int
chkr_stub_PQrequestCancel (PGconn * conn)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (conn, sizeof (PGconn), CHKR_RO, "conn");
#if USE_BI_JUMP
  __builtin_jump (PQrequestCancel);
#else
  return PQrequestCancel (conn);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_PQrequestCancel */

#ifdef HAVE_PQdb
/* From `/usr/include/postgresql/libpq-fe.h:177'.  */
char * chkr_stub_PQdb (PGconn * arg0) __asm__ (CHKR_PREFIX ("PQdb"));
char *
chkr_stub_PQdb (PGconn * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGconn), CHKR_RO, "conn");
  {
    char * res;
    res = PQdb (arg0);
    if (res)
      stubs_chkr_set_right (res, strlen (res) + 1, CHKR_RO);
    return res;
  }
}
#endif /* HAVE_PQdb */

#ifdef HAVE_PQuser
/* From `/usr/include/postgresql/libpq-fe.h:178'.  */
char * chkr_stub_PQuser (PGconn * arg0) __asm__ (CHKR_PREFIX ("PQuser"));
char *
chkr_stub_PQuser (PGconn * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGconn), CHKR_RO, "conn");
  {
    char * res;
    res = PQuser (arg0);
    if (res)
      stubs_chkr_set_right (res, strlen (res) + 1, CHKR_RO);
    return res;
  }
}
#endif /* HAVE_PQuser */

#ifdef HAVE_PQpass
/* From `/usr/include/postgresql/libpq-fe.h:179'.  */
char * chkr_stub_PQpass (PGconn * arg0) __asm__ (CHKR_PREFIX ("PQpass"));
char *
chkr_stub_PQpass (PGconn * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGconn), CHKR_RO, "conn");
  {
    char * res;
    res = PQpass (arg0);
    if (res)
      stubs_chkr_set_right (res, strlen (res) + 1, CHKR_RO);
    return res;
  }
}
#endif /* HAVE_PQpass */

#ifdef HAVE_PQhost
/* From `/usr/include/postgresql/libpq-fe.h:180'.  */
char * chkr_stub_PQhost (PGconn * arg0) __asm__ (CHKR_PREFIX ("PQhost"));
char *
chkr_stub_PQhost (PGconn * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGconn), CHKR_RO, "conn");
  {
    char * res;
    res = PQhost (arg0);
    if (res)
      stubs_chkr_set_right (res, strlen (res) + 1, CHKR_RO);
    return res;
  }
}
#endif /* HAVE_PQhost */

#ifdef HAVE_PQport
/* From `/usr/include/postgresql/libpq-fe.h:181'.  */
char * chkr_stub_PQport (PGconn * arg0) __asm__ (CHKR_PREFIX ("PQport"));
char *
chkr_stub_PQport (PGconn * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGconn), CHKR_RO, "conn");
  {
    char * res;
    res = PQport (arg0);
    if (res)
      stubs_chkr_set_right (res, strlen (res) + 1, CHKR_RO);
    return res;
  }
}
#endif /* HAVE_PQport */

#ifdef HAVE_PQtty
/* From `/usr/include/postgresql/libpq-fe.h:182'.  */
char * chkr_stub_PQtty (PGconn * arg0) __asm__ (CHKR_PREFIX ("PQtty"));
char *
chkr_stub_PQtty (PGconn * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGconn), CHKR_RO, "conn");
  {
    char * res;
    res = PQtty (arg0);
    if (res)
      stubs_chkr_set_right (res, strlen (res) + 1, CHKR_RO);
    return res;
  }
}
#endif /* HAVE_PQtty */

#ifdef HAVE_PQoptions
/* From `/usr/include/postgresql/libpq-fe.h:183'.  */
char * chkr_stub_PQoptions (PGconn * arg0) __asm__ (CHKR_PREFIX ("PQoptions"));
char *
chkr_stub_PQoptions (PGconn * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGconn), CHKR_RO, "conn");
  {
    char * res;
    res = PQoptions (arg0);
    if (res)
      stubs_chkr_set_right (res, strlen (res) + 1, CHKR_RO);
    return res;
  }
}
#endif /* HAVE_PQoptions */

#ifdef HAVE_PQstatus
/* From `/usr/include/postgresql/libpq-fe.h:184'.  */
ConnStatusType chkr_stub_PQstatus (PGconn * arg0) __asm__ (CHKR_PREFIX ("PQstatus"));
ConnStatusType
chkr_stub_PQstatus (PGconn * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGconn), CHKR_RO, "conn");
#if USE_BI_JUMP
  __builtin_jump (PQstatus);
#else
  return PQstatus (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_PQstatus */

#ifdef HAVE_PQerrorMessage
/* From `/usr/include/postgresql/libpq-fe.h:185'.  */
char * chkr_stub_PQerrorMessage (PGconn * arg0) __asm__ (CHKR_PREFIX ("PQerrorMessage"));
char *
chkr_stub_PQerrorMessage (PGconn * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGconn), CHKR_RO, "conn");
  {
    char * res;
    res = PQerrorMessage (arg0);
    if (res)
      stubs_chkr_set_right (res, strlen (res) + 1, CHKR_RO);
    return res;
  }
}
#endif /* HAVE_PQerrorMessage */

#ifdef HAVE_PQsocket
/* From `/usr/include/postgresql/libpq-fe.h:186'.  */
int chkr_stub_PQsocket (PGconn * arg0) __asm__ (CHKR_PREFIX ("PQsocket"));
int
chkr_stub_PQsocket (PGconn * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGconn), CHKR_RO, "conn");
  {
    int res = PQsocket (arg0);
    fd_returned_by_system (res);
    return res;
  }
}
#endif /* HAVE_PQsocket */

#ifdef HAVE_PQbackendPID
/* From `/usr/include/postgresql/libpq-fe.h:187'.  */
int chkr_stub_PQbackendPID (PGconn * arg0) __asm__ (CHKR_PREFIX ("PQbackendPID"));
int
chkr_stub_PQbackendPID (PGconn * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGconn), CHKR_RO, "conn");
#if USE_BI_JUMP
  __builtin_jump (PQbackendPID);
#else
  return PQbackendPID (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_PQbackendPID */

#ifdef HAVE_PQtrace
/* From `/usr/include/postgresql/libpq-fe.h:190'.  */
void chkr_stub_PQtrace (PGconn * arg0, FILE * arg1) __asm__ (CHKR_PREFIX ("PQtrace"));
void
chkr_stub_PQtrace (PGconn * arg0, FILE * arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGconn), CHKR_RO, "conn");
  CHKR_CHECK_STREAM (arg1);
#if USE_BI_JUMP
  __builtin_jump (PQtrace);
#else
  PQtrace (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_PQtrace */

#ifdef HAVE_PQuntrace
/* From `/usr/include/postgresql/libpq-fe.h:191'.  */
void chkr_stub_PQuntrace (PGconn * arg0) __asm__ (CHKR_PREFIX ("PQuntrace"));
void
chkr_stub_PQuntrace (PGconn * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGconn), CHKR_RO, "conn");
#if USE_BI_JUMP
  __builtin_jump (PQuntrace);
#else
  PQuntrace (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_PQuntrace */

#ifdef HAVE_PQsetNoticeProcessor
/* From `/usr/include/postgresql/libpq-fe.h:196'.  */
void chkr_stub_PQsetNoticeProcessor (PGconn * arg0, PQnoticeProcessor arg1, void * arg2) __asm__ (CHKR_PREFIX ("PQsetNoticeProcessor"));
void
chkr_stub_PQsetNoticeProcessor (PGconn * arg0, PQnoticeProcessor arg1, void * arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGconn), CHKR_RO, "conn");
#if USE_BI_JUMP
  __builtin_jump (PQsetNoticeProcessor);
#else
  PQsetNoticeProcessor (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_PQsetNoticeProcessor */

#ifdef HAVE_PQexec
/* From `/usr/include/postgresql/libpq-fe.h:201'.  */
PGresult * chkr_stub_PQexec (PGconn * arg0, const char * arg1) __asm__ (CHKR_PREFIX ("PQexec"));
PGresult *
chkr_stub_PQexec (PGconn * arg0, const char * arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGconn), CHKR_RO, "conn");
  stubs_chkr_check_str (arg1, CHKR_RO, "query");
  {
    PGresult * res;
    res = PQexec (arg0, arg1);
    if (res)
      stubs_chkr_set_right (res, sizeof *res, CHKR_RO);
    return res;
  }
}
#endif /* HAVE_PQexec */

#ifdef HAVE_PQnotifies
/* From `/usr/include/postgresql/libpq-fe.h:202'.  */
PGnotify * chkr_stub_PQnotifies (PGconn * arg0) __asm__ (CHKR_PREFIX ("PQnotifies"));
PGnotify *
chkr_stub_PQnotifies (PGconn * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGconn), CHKR_RO, "arg0");
  {
    PGnotify * res;
    res = PQnotifies (arg0);
    if (res)
      stubs_chkr_set_right (res, sizeof *res, CHKR_RO);
    return res;
  }
}
#endif /* HAVE_PQnotifies */

#ifdef HAVE_PQsendQuery
/* From `/usr/include/postgresql/libpq-fe.h:205'.  */
int chkr_stub_PQsendQuery (PGconn * arg0, const char * arg1) __asm__ (CHKR_PREFIX ("PQsendQuery"));
int
chkr_stub_PQsendQuery (PGconn * arg0, const char * arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGconn), CHKR_RO, "conn");
  stubs_chkr_check_str (arg1, CHKR_RO, "query");
#if USE_BI_JUMP
  __builtin_jump (PQsendQuery);
#else
  return PQsendQuery (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_PQsendQuery */

#ifdef HAVE_PQgetResult
/* From `/usr/include/postgresql/libpq-fe.h:206'.  */
PGresult * chkr_stub_PQgetResult (PGconn * arg0) __asm__ (CHKR_PREFIX ("PQgetResult"));
PGresult *
chkr_stub_PQgetResult (PGconn * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGconn), CHKR_RO, "conn");
  {
    PGresult * res;
    res = PQgetResult (arg0);
    if (res)
      stubs_chkr_set_right (res, sizeof *res, CHKR_RO);
    return res;
  }
}
#endif /* HAVE_PQgetResult */

#ifdef HAVE_PQisBusy
/* From `/usr/include/postgresql/libpq-fe.h:209'.  */
int chkr_stub_PQisBusy (PGconn * arg0) __asm__ (CHKR_PREFIX ("PQisBusy"));
int
chkr_stub_PQisBusy (PGconn * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGconn), CHKR_RO, "conn");
#if USE_BI_JUMP
  __builtin_jump (PQisBusy);
#else
  return PQisBusy (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_PQisBusy */

#ifdef HAVE_PQconsumeInput
/* From `/usr/include/postgresql/libpq-fe.h:210'.  */
int chkr_stub_PQconsumeInput (PGconn * arg0) __asm__ (CHKR_PREFIX ("PQconsumeInput"));
int
chkr_stub_PQconsumeInput (PGconn * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGconn), CHKR_RO, "conn");
#if USE_BI_JUMP
  __builtin_jump (PQconsumeInput);
#else
  return PQconsumeInput (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_PQconsumeInput */

#ifdef HAVE_PQgetline
/* From `/usr/include/postgresql/libpq-fe.h:213'.  */
int chkr_stub_PQgetline (PGconn * arg0, char * arg1, int arg2) __asm__ (CHKR_PREFIX ("PQgetline"));
int
chkr_stub_PQgetline (PGconn * arg0, char * arg1, int arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGconn), CHKR_RO, "conn");
  stubs_chkr_check_addr (arg1, arg2, CHKR_WO, "string");
  {
    int res;
    res = PQgetline (arg0, arg1, arg2);
    if (res)
      stubs_chkr_set_right (arg1, strlen (arg1) + 1, CHKR_RW);
    return res;
  }
}
#endif /* HAVE_PQgetline */

#ifdef HAVE_PQputline
/* From `/usr/include/postgresql/libpq-fe.h:214'.  */
int chkr_stub_PQputline (PGconn * arg0, const char * arg1) __asm__ (CHKR_PREFIX ("PQputline"));
int
chkr_stub_PQputline (PGconn * arg0, const char * arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGconn), CHKR_RO, "conn");
  stubs_chkr_check_str (arg1, CHKR_RO, "string");
#if USE_BI_JUMP
  __builtin_jump (PQputline);
#else
  return PQputline (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_PQputline */

#undef HAVE_PQgetlineAsync /* Undocumented function. */
#ifdef HAVE_PQgetlineAsync
/* From `/usr/include/postgresql/libpq-fe.h:215'.  */
int chkr_stub_PQgetlineAsync (PGconn * arg0, char * arg1, int arg2) __asm__ (CHKR_PREFIX ("PQgetlineAsync"));
int
chkr_stub_PQgetlineAsync (PGconn * arg0, char * arg1, int arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGconn), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (char), CHKR_XX, "arg1");
#if USE_BI_JUMP
  __builtin_jump (PQgetlineAsync);
#else
  return PQgetlineAsync (arg0, arg1, arg2);
  {
    int res;
    res = PQgetlineAsync (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_PQgetlineAsync */

#undef HAVE_PQputnbytes /* Undocumented function. */
#ifdef HAVE_PQputnbytes
/* From `/usr/include/postgresql/libpq-fe.h:216'.  */
int chkr_stub_PQputnbytes (PGconn * arg0, const char * arg1, int arg2) __asm__ (CHKR_PREFIX ("PQputnbytes"));
int
chkr_stub_PQputnbytes (PGconn * arg0, const char * arg1, int arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGconn), CHKR_XX, "arg0");
  stubs_chkr_check_addr (arg1, sizeof (char), CHKR_RO, "arg1");
#if USE_BI_JUMP
  __builtin_jump (PQputnbytes);
#else
  return PQputnbytes (arg0, arg1, arg2);
  {
    int res;
    res = PQputnbytes (arg0, arg1, arg2);
    return res;
  }
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_PQputnbytes */

#ifdef HAVE_PQendcopy
/* From `/usr/include/postgresql/libpq-fe.h:217'.  */
int chkr_stub_PQendcopy (PGconn * arg0) __asm__ (CHKR_PREFIX ("PQendcopy"));
int
chkr_stub_PQendcopy (PGconn * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGconn), CHKR_RO, "conn");
#if USE_BI_JUMP
  __builtin_jump (PQendcopy);
#else
  return PQendcopy (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_PQendcopy */

#ifdef HAVE_PQfn
/* From `/usr/include/postgresql/libpq-fe.h:229'.  */
PGresult * chkr_stub_PQfn (PGconn * arg0, int arg1, int * arg2, int * arg3, int arg4, PQArgBlock * arg5, int arg6) __asm__ (CHKR_PREFIX ("PQfn"));
PGresult *
chkr_stub_PQfn (PGconn * arg0, int arg1, int * arg2, int * arg3, int arg4, PQArgBlock * arg5, int arg6)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGconn), CHKR_RO, "conn");
  stubs_chkr_check_addr (arg2, sizeof (int), CHKR_WO, "result_buf");
  stubs_chkr_check_addr (arg3, sizeof (int), CHKR_WO, "result_len");
  stubs_chkr_check_addr (arg5, sizeof (PQArgBlock), CHKR_RO, "args");
  {
    PGresult * res;
    res = PQfn (arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    if (res)
      stubs_chkr_set_right (res, sizeof *res, CHKR_RW);
    return res;
  }
}
#endif /* HAVE_PQfn */

#ifdef HAVE_PQresultStatus
/* From `/usr/include/postgresql/libpq-fe.h:232'.  */
ExecStatusType chkr_stub_PQresultStatus (PGresult * arg0) __asm__ (CHKR_PREFIX ("PQresultStatus"));
ExecStatusType
chkr_stub_PQresultStatus (PGresult * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGresult), CHKR_RO, "result");
#if USE_BI_JUMP
  __builtin_jump (PQresultStatus);
#else
  return PQresultStatus (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_PQresultStatus */

#ifdef HAVE_PQresultErrorMessage
/* From `/usr/include/postgresql/libpq-fe.h:233'.  */
const char * chkr_stub_PQresultErrorMessage (PGresult * arg0) __asm__ (CHKR_PREFIX ("PQresultErrorMessage"));
const char *
chkr_stub_PQresultErrorMessage (PGresult * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGresult), CHKR_RO, "result");
  {
    const char * res;
    res = PQresultErrorMessage (arg0);
    if (res)
      stubs_chkr_set_right (res, strlen (res) + 1, CHKR_RO);
    return res;
  }
}
#endif /* HAVE_PQresultErrorMessage */

#ifdef HAVE_PQntuples
/* From `/usr/include/postgresql/libpq-fe.h:234'.  */
int chkr_stub_PQntuples (PGresult * arg0) __asm__ (CHKR_PREFIX ("PQntuples"));
int
chkr_stub_PQntuples (PGresult * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGresult), CHKR_RO, "result");
#if USE_BI_JUMP
  __builtin_jump (PQntuples);
#else
  return PQntuples (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_PQntuples */

#ifdef HAVE_PQnfields
/* From `/usr/include/postgresql/libpq-fe.h:235'.  */
int chkr_stub_PQnfields (PGresult * arg0) __asm__ (CHKR_PREFIX ("PQnfields"));
int
chkr_stub_PQnfields (PGresult * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGresult), CHKR_RO, "result");
#if USE_BI_JUMP
  __builtin_jump (PQnfields);
#else
  return PQnfields (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_PQnfields */

#ifdef HAVE_PQbinaryTuples
/* From `/usr/include/postgresql/libpq-fe.h:236'.  */
int chkr_stub_PQbinaryTuples (PGresult * arg0) __asm__ (CHKR_PREFIX ("PQbinaryTuples"));
int
chkr_stub_PQbinaryTuples (PGresult * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGresult), CHKR_RO, "result");
#if USE_BI_JUMP
  __builtin_jump (PQbinaryTuples);
#else
  return PQbinaryTuples (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_PQbinaryTuples */

#ifdef HAVE_PQfname
/* From `/usr/include/postgresql/libpq-fe.h:237'.  */
char * chkr_stub_PQfname (PGresult * arg0, int arg1) __asm__ (CHKR_PREFIX ("PQfname"));
char *
chkr_stub_PQfname (PGresult * arg0, int arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGresult), CHKR_RO, "result");
  {
    char * res;
    res = PQfname (arg0, arg1);
    if (res)
      stubs_chkr_set_right (res, strlen (res) + 1, CHKR_RO);
    return res;
  }
}
#endif /* HAVE_PQfname */

#ifdef HAVE_PQfnumber
/* From `/usr/include/postgresql/libpq-fe.h:238'.  */
int chkr_stub_PQfnumber (PGresult * arg0, const char * arg1) __asm__ (CHKR_PREFIX ("PQfnumber"));
int
chkr_stub_PQfnumber (PGresult * arg0, const char * arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGresult), CHKR_RO, "result");
  stubs_chkr_check_str (arg1, CHKR_RO, "field_name");
#if USE_BI_JUMP
  __builtin_jump (PQfnumber);
#else
  return PQfnumber (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_PQfnumber */

#ifdef HAVE_PQftype
/* From `/usr/include/postgresql/libpq-fe.h:239'.  */
Oid chkr_stub_PQftype (PGresult * arg0, int arg1) __asm__ (CHKR_PREFIX ("PQftype"));
Oid
chkr_stub_PQftype (PGresult * arg0, int arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGresult), CHKR_RO, "result");
#if USE_BI_JUMP
  __builtin_jump (PQftype);
#else
  return PQftype (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_PQftype */

#ifdef HAVE_PQfsize
/* From `/usr/include/postgresql/libpq-fe.h:240'.  */
int chkr_stub_PQfsize (PGresult * arg0, int arg1) __asm__ (CHKR_PREFIX ("PQfsize"));
int
chkr_stub_PQfsize (PGresult * arg0, int arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGresult), CHKR_RO, "result");
#if USE_BI_JUMP
  __builtin_jump (PQfsize);
#else
  return PQfsize (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_PQfsize */

#ifdef HAVE_PQfmod
/* From `/usr/include/postgresql/libpq-fe.h:241'.  */
int chkr_stub_PQfmod (PGresult * arg0, int arg1) __asm__ (CHKR_PREFIX ("PQfmod"));
int
chkr_stub_PQfmod (PGresult * arg0, int arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGresult), CHKR_RO, "result");
#if USE_BI_JUMP
  __builtin_jump (PQfmod);
#else
  return PQfmod (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_PQfmod */

#ifdef HAVE_PQcmdStatus
/* From `/usr/include/postgresql/libpq-fe.h:242'.  */
char * chkr_stub_PQcmdStatus (PGresult * arg0) __asm__ (CHKR_PREFIX ("PQcmdStatus"));
char *
chkr_stub_PQcmdStatus (PGresult * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGresult), CHKR_RO, "result");
  {
    char * res;
    res = PQcmdStatus (arg0);
    if (res)
      stubs_chkr_set_right (res, strlen (res) + 1, CHKR_RO);
    return res;
  }
}
#endif /* HAVE_PQcmdStatus */

#ifdef HAVE_PQoidStatus
/* From `/usr/include/postgresql/libpq-fe.h:243'.  */
const char * chkr_stub_PQoidStatus (PGresult * arg0) __asm__ (CHKR_PREFIX ("PQoidStatus"));
const char *
chkr_stub_PQoidStatus (PGresult * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGresult), CHKR_RO, "result");
  {
    const char * res;
    res = PQoidStatus (arg0);
    if (res)
      stubs_chkr_set_right (res, strlen (res) + 1, CHKR_RO);
    return res;
  }
}
#endif /* HAVE_PQoidStatus */

#ifdef HAVE_PQcmdTuples
/* From `/usr/include/postgresql/libpq-fe.h:244'.  */
const char * chkr_stub_PQcmdTuples (PGresult * arg0) __asm__ (CHKR_PREFIX ("PQcmdTuples"));
const char *
chkr_stub_PQcmdTuples (PGresult * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGresult), CHKR_RO, "result");
  {
    const char * res;
    res = PQcmdTuples (arg0);
    if (res)
      stubs_chkr_set_right (res, strlen (res) + 1, CHKR_RO);
    return res;
  }
}
#endif /* HAVE_PQcmdTuples */

#ifdef HAVE_PQgetvalue
/* From `/usr/include/postgresql/libpq-fe.h:245'.  */
char * chkr_stub_PQgetvalue (PGresult * arg0, int arg1, int arg2) __asm__ (CHKR_PREFIX ("PQgetvalue"));
char *
chkr_stub_PQgetvalue (PGresult * arg0, int arg1, int arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGresult), CHKR_RO, "result");
  {
    char * res;
    res = PQgetvalue (arg0, arg1, arg2);
    if (res)
      stubs_chkr_set_right (res, PQgetlength (arg0, arg1, arg2) + 1, CHKR_RW);
    return res;
  }
}
#endif /* HAVE_PQgetvalue */

#ifdef HAVE_PQgetlength
/* From `/usr/include/postgresql/libpq-fe.h:246'.  */
int chkr_stub_PQgetlength (PGresult * arg0, int arg1, int arg2) __asm__ (CHKR_PREFIX ("PQgetlength"));
int
chkr_stub_PQgetlength (PGresult * arg0, int arg1, int arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGresult), CHKR_RO, "result");
#if USE_BI_JUMP
  __builtin_jump (PQgetlength);
#else
  return PQgetlength (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_PQgetlength */

#ifdef HAVE_PQgetisnull
/* From `/usr/include/postgresql/libpq-fe.h:247'.  */
int chkr_stub_PQgetisnull (PGresult * arg0, int arg1, int arg2) __asm__ (CHKR_PREFIX ("PQgetisnull"));
int
chkr_stub_PQgetisnull (PGresult * arg0, int arg1, int arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGresult), CHKR_RO, "result");
#if USE_BI_JUMP
  __builtin_jump (PQgetisnull);
#else
  return PQgetisnull (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_PQgetisnull */

#ifdef HAVE_PQclear
/* From `/usr/include/postgresql/libpq-fe.h:250'.  */
void chkr_stub_PQclear (PGresult * arg0) __asm__ (CHKR_PREFIX ("PQclear"));
void
chkr_stub_PQclear (PGresult * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGresult), CHKR_RO, "arg0");
  stubs_chkr_set_right (arg0, sizeof (PGresult), CHKR_UN);
#if USE_BI_JUMP
  __builtin_jump (PQclear);
#else
  PQclear (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_PQclear */

#ifdef HAVE_PQmakeEmptyPGresult
/* From `/usr/include/postgresql/libpq-fe.h:256'.  */
PGresult * chkr_stub_PQmakeEmptyPGresult (PGconn * arg0, ExecStatusType arg1) __asm__ (CHKR_PREFIX ("PQmakeEmptyPGresult"));
PGresult *
chkr_stub_PQmakeEmptyPGresult (PGconn * arg0, ExecStatusType arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGconn), CHKR_RO, "conn");
  {
    PGresult * res;
    res = PQmakeEmptyPGresult (arg0, arg1);
    if (res)
      stubs_chkr_set_right (res, sizeof *res, CHKR_RO);
    return res;
  }
}
#endif /* HAVE_PQmakeEmptyPGresult */

#ifdef HAVE_PQprint
/* From `/usr/include/postgresql/libpq-fe.h:262'.  */
void chkr_stub_PQprint (FILE * arg0, PGresult * arg1, PQprintOpt * arg2) __asm__ (CHKR_PREFIX ("PQprint"));
void
chkr_stub_PQprint (FILE * arg0, PGresult * arg1, PQprintOpt * arg2)
{
  /* This function requires a stub */
  CHKR_CHECK_STREAM (arg0);
  stubs_chkr_check_addr (arg1, sizeof (PGresult), CHKR_RO, "result");
  stubs_chkr_check_addr (arg2, sizeof (PQprintOpt), CHKR_RO, "ps");
#if USE_BI_JUMP
  __builtin_jump (PQprint);
#else
  PQprint (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_PQprint */

#ifdef HAVE_PQdisplayTuples
/* From `/usr/include/postgresql/libpq-fe.h:275'.  */
void chkr_stub_PQdisplayTuples (PGresult * arg0, FILE * arg1, int arg2, const char * arg3, int arg4, int arg5) __asm__ (CHKR_PREFIX ("PQdisplayTuples"));
void
chkr_stub_PQdisplayTuples (PGresult * arg0, FILE * arg1, int arg2, const char * arg3, int arg4, int arg5)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGresult), CHKR_RO, "result");
  CHKR_CHECK_STREAM (arg1);
  stubs_chkr_check_str (arg3, CHKR_RO, "fieldSep");
#if USE_BI_JUMP
  __builtin_jump (PQdisplayTuples);
#else
  PQdisplayTuples (arg0, arg1, arg2, arg3, arg4, arg5);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_PQdisplayTuples */

#ifdef HAVE_PQprintTuples
/* From `/usr/include/postgresql/libpq-fe.h:283'.  */
void chkr_stub_PQprintTuples (PGresult * arg0, FILE * arg1, int arg2, int arg3, int arg4) __asm__ (CHKR_PREFIX ("PQprintTuples"));
void
chkr_stub_PQprintTuples (PGresult * arg0, FILE * arg1, int arg2, int arg3, int arg4)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGresult), CHKR_RO, "result");
  CHKR_CHECK_STREAM (arg1);
#if USE_BI_JUMP
  __builtin_jump (PQprintTuples);
#else
  PQprintTuples (arg0, arg1, arg2, arg3, arg4);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_PQprintTuples */

#ifdef HAVE_PQmblen
/* From `/usr/include/postgresql/libpq-fe.h:287'.  */
int chkr_stub_PQmblen (unsigned char * arg0, int arg1) __asm__ (CHKR_PREFIX ("PQmblen"));
int
chkr_stub_PQmblen (unsigned char * arg0, int arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_str (arg0, CHKR_RO, "string");
#if USE_BI_JUMP
  __builtin_jump (PQmblen);
#else
  return PQmblen (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_PQmblen */

#ifdef HAVE_lo_open
/* From `/usr/include/postgresql/libpq-fe.h:292'.  */
int chkr_stub_lo_open (PGconn * arg0, Oid arg1, int arg2) __asm__ (CHKR_PREFIX ("lo_open"));
int
chkr_stub_lo_open (PGconn * arg0, Oid arg1, int arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGconn), CHKR_RO, "conn");
#if USE_BI_JUMP
  __builtin_jump (lo_open);
#else
  return lo_open (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_lo_open */

#ifdef HAVE_lo_close
/* From `/usr/include/postgresql/libpq-fe.h:293'.  */
int chkr_stub_lo_close (PGconn * arg0, int arg1) __asm__ (CHKR_PREFIX ("lo_close"));
int
chkr_stub_lo_close (PGconn * arg0, int arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGconn), CHKR_RO, "conn");
#if USE_BI_JUMP
  __builtin_jump (lo_close);
#else
  return lo_close (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_lo_close */

#ifdef HAVE_lo_read
/* From `/usr/include/postgresql/libpq-fe.h:294'.  */
int chkr_stub_lo_read (PGconn * arg0, int arg1, char * arg2, int arg3) __asm__ (CHKR_PREFIX ("lo_read"));
int
chkr_stub_lo_read (PGconn * arg0, int arg1, char * arg2, int arg3)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGconn), CHKR_RO, "conn");
  if (arg3 != 0)
    stubs_chkr_check_addr (arg2, arg3, CHKR_WO, "buf");
#if USE_BI_JUMP
  __builtin_jump (lo_read);
#else
  return lo_read (arg0, arg1, arg2, arg3);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_lo_read */

#ifdef HAVE_lo_write
/* From `/usr/include/postgresql/libpq-fe.h:295'.  */
int chkr_stub_lo_write (PGconn * arg0, int arg1, char * arg2, int arg3) __asm__ (CHKR_PREFIX ("lo_write"));
int
chkr_stub_lo_write (PGconn * arg0, int arg1, char * arg2, int arg3)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGconn), CHKR_RO, "conn");
  stubs_chkr_check_addr (arg2, arg3, CHKR_RO, "buf");
#if USE_BI_JUMP
  __builtin_jump (lo_write);
#else
  return lo_write (arg0, arg1, arg2, arg3);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_lo_write */

#ifdef HAVE_lo_lseek
/* From `/usr/include/postgresql/libpq-fe.h:296'.  */
int chkr_stub_lo_lseek (PGconn * arg0, int arg1, int arg2, int arg3) __asm__ (CHKR_PREFIX ("lo_lseek"));
int
chkr_stub_lo_lseek (PGconn * arg0, int arg1, int arg2, int arg3)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGconn), CHKR_RO, "conn");
#if USE_BI_JUMP
  __builtin_jump (lo_lseek);
#else
  return lo_lseek (arg0, arg1, arg2, arg3);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_lo_lseek */

#ifdef HAVE_lo_creat
/* From `/usr/include/postgresql/libpq-fe.h:297'.  */
Oid chkr_stub_lo_creat (PGconn * arg0, int arg1) __asm__ (CHKR_PREFIX ("lo_creat"));
Oid
chkr_stub_lo_creat (PGconn * arg0, int arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGconn), CHKR_RO, "conn");
#if USE_BI_JUMP
  __builtin_jump (lo_creat);
#else
  return lo_creat (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_lo_creat */

#ifdef HAVE_lo_tell
/* From `/usr/include/postgresql/libpq-fe.h:298'.  */
int chkr_stub_lo_tell (PGconn * arg0, int arg1) __asm__ (CHKR_PREFIX ("lo_tell"));
int
chkr_stub_lo_tell (PGconn * arg0, int arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGconn), CHKR_RO, "conn");
#if USE_BI_JUMP
  __builtin_jump (lo_tell);
#else
  return lo_tell (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_lo_tell */

#ifdef HAVE_lo_unlink
/* From `/usr/include/postgresql/libpq-fe.h:299'.  */
int chkr_stub_lo_unlink (PGconn * arg0, Oid arg1) __asm__ (CHKR_PREFIX ("lo_unlink"));
int
chkr_stub_lo_unlink (PGconn * arg0, Oid arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGconn), CHKR_RO, "conn");
#if USE_BI_JUMP
  __builtin_jump (lo_unlink);
#else
  return lo_unlink (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_lo_unlink */

#ifdef HAVE_lo_import
/* From `/usr/include/postgresql/libpq-fe.h:300'.  */
Oid chkr_stub_lo_import (PGconn * arg0, char * arg1) __asm__ (CHKR_PREFIX ("lo_import"));
Oid
chkr_stub_lo_import (PGconn * arg0, char * arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGconn), CHKR_RO, "conn");
  stubs_chkr_check_str (arg1, CHKR_RO, "filename");
#if USE_BI_JUMP
  __builtin_jump (lo_import);
#else
  return lo_import (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_lo_import */

#ifdef HAVE_lo_export
/* From `/usr/include/postgresql/libpq-fe.h:301'.  */
int chkr_stub_lo_export (PGconn * arg0, Oid arg1, char * arg2) __asm__ (CHKR_PREFIX ("lo_export"));
int
chkr_stub_lo_export (PGconn * arg0, Oid arg1, char * arg2)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (PGconn), CHKR_RO, "conn");
  stubs_chkr_check_str (arg2, CHKR_RO, "filename");
#if USE_BI_JUMP
  __builtin_jump (lo_export);
#else
  return lo_export (arg0, arg1, arg2);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_lo_export */

