/*
** Copyright (C) 17 Feb 2001 Jonas Munsin <jmunsin@iki.fi>
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <gtk/gtk.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>

#include "generic_output_handler.h"

int handle_output(gpointer data) {
	fd_set rset;
	struct timeval tv;
	int result, max;
	two_pipe_handlers *handlers = (two_pipe_handlers*)data;
	pipe_handler *chan1 = handlers->ph1;
	pipe_handler *chan2 = handlers->ph2;

	if (!((chan1->status) || (chan2->status))) {
		g_warning("%s::%i: status of each fd is invalid!", __FILE__, __LINE__);
		return FALSE;
	}

	tv.tv_sec = 0;
	tv.tv_usec = 0;

	FD_ZERO(&rset);
	max = -1;

	if (chan1->status) {
		FD_SET(chan1->fd, &rset);
		max = chan1->fd;
	}
	if (chan2->status) {
		FD_SET(chan2->fd, &rset);
		if (-1 == max)
			max = chan2->fd;
		else
			max = chan1->fd>chan2->fd ? chan1->fd : chan2->fd;
	}

	result = select(max + 1, &rset, NULL, NULL, &tv);

	if (result < 0)
		g_warning("%s::%i: select returned negative!", __FILE__, __LINE__);
	else if (result == 0)
		return TRUE;

	if (chan1->status && FD_ISSET(chan1->fd, &rset))
		chan1->status = chan1->callback(chan1->fd);
	if (chan2->status && FD_ISSET(chan2->fd, &rset))
		chan2->status = chan2->callback(chan2->fd);

	if (!(chan1->status || chan2->status)) {
		handlers->end_callback();
		return FALSE;
	} else
		return TRUE;
	return 0;
}

