/*  Note: You are free to use whatever license you want.
    Eventually you will be able to edit it within Glade. */

/*  gcrontab
 *  Copyright (C) <YEAR> <AUTHORS>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <sys/types.h>
#include <sys/stat.h>
              

#include <glib.h>
#include <gtk/gtk.h>
#include "gcrontabsrc.h"
#include "gcrontabsig.h"


GList 
      *minute=NULL,
      *hour=NULL,
      *day=NULL,
      *month=NULL,      
      *wday=NULL,
      *lsts[5];

GtkWidget *win_main;
GtkWidget *win_citem;
GtkWidget *win_cmmd;
GtkWidget *win_sel;
GtkWidget *win_edit;
GtkWidget *win_msg;
GtkWidget *win_cal;

int TXTDIRTY=0;
char *FILENAME=NULL;

gint GRDSELROW=-1,GRDLNSELROW=-1,GRDSELCOL=-1;

char CRONTABLN[1000]="";
char *FNAME=NULL;

void Open(void);
void SvAs(void);
int  SvCronFile();
void Message(char *title, char *msg);
int  LdCronFile(char *lname,int fullpath);

void 
Message(char *title, char *msg)
{
           win_msg=create_win_msg (title,msg);
           gtk_window_set_modal(GTK_WINDOW(win_msg),1);           
           gtk_widget_show(win_msg);
}


static void
filllst(GList **lst,const char *fmt,int from, int to)
{
   int i;
   char aux[20],*s;
   
   for(i=from;i<=to;i++)
      {
          sprintf(aux,fmt,i);
          s=(char *)strdup(aux);
          *lst=g_list_append(*lst,s);
      }
}

void initlsts(void)
{
    wday=g_list_append(wday,"Mon");
    wday=g_list_append(wday,"Tue");    
    wday=g_list_append(wday,"Wed");
    wday=g_list_append(wday,"Thu");        
    wday=g_list_append(wday,"Fri");    
    wday=g_list_append(wday,"Sat");    
    wday=g_list_append(wday,"Sun");    
    
    month=g_list_append(month,"Jan");
    month=g_list_append(month,"Feb");    
    month=g_list_append(month,"Mar");       
    month=g_list_append(month,"Apr");           
    month=g_list_append(month,"May");           
    month=g_list_append(month,"Jun");           
    month=g_list_append(month,"Jul");           
    month=g_list_append(month,"Aug");           
    month=g_list_append(month,"Sep");           
    month=g_list_append(month,"Oct");           
    month=g_list_append(month,"Nov");           
    month=g_list_append(month,"Dec");           
    
    filllst(&minute,"%02d",0,59);
    filllst(&hour,"%02d",0,23);    
    filllst(&day,"%d",1,31);    
    
    lsts[0]=(GList *)minute;
    lsts[1]=(GList *)hour;
    lsts[2]=(GList *)day;
    lsts[3]=(GList *)month;
    lsts[4]=(GList *)wday;     
}    


void initcmbs(GList *lst)
{
    GtkCombo *cmb;
 
    cmb=(GtkCombo *)gtk_object_get_data(GTK_OBJECT(win_citem), "cmb_from");   
    gtk_combo_set_popdown_strings(cmb,lst);
    
    cmb=(GtkCombo*)gtk_object_get_data(GTK_OBJECT(win_citem), "cmb_to");    
    gtk_combo_set_popdown_strings(cmb,lst);    
}


void
EditFile(char *fname, int status)
   {
        GtkText *edt_text;      
        char cmmd[255];        
        FILE *pf;     
        struct stat ssb;
           
           TXTDIRTY=0; 
           
           stat(fname,&ssb);
           if(!S_ISREG(ssb.st_mode)) return;
           
	   win_edit=create_win_edit ();
           gtk_window_set_modal((GtkWindow *)win_edit,1);           
           
           edt_text=GTK_TEXT(gtk_object_get_data(GTK_OBJECT(win_edit), "edt_text"));              
           gtk_text_set_line_wrap (edt_text, TRUE);                      
           gtk_text_freeze (edt_text);
           
           pf=fopen(fname,"r");
           if(pf)
               {
                     fgets(cmmd,254,pf);
                     while(!feof(pf))
                        {
                            gtk_text_insert(edt_text,NULL,NULL,NULL,cmmd,strlen(cmmd));
                            fgets(cmmd,254,pf);                            
                        }
              
                      fclose(pf);
               }
               
           gtk_text_thaw (edt_text);
           gtk_text_set_editable (edt_text, status);           
           
	   gtk_widget_show(win_edit);   
    }


int
main (int argc, char *argv[])
{
  char errmsg[200];
  gtk_set_locale ();
  gtk_init (&argc, &argv);
  
  initlsts();

  /*
   * The following code was added by Glade to create one of each component
   * (except popup menus), just so that you see something after building
   * the project. Delete any components that you don't want shown initially.
   */

  add_pixmap_directory("/usr/share/gcrontab");
  add_pixmap_directory("/usr/local/share/gcrontab");  
  win_main=create_win_main ();
  
  if(!LdCronFile(getlogin(),0)) {
     sprintf(errmsg,"\n\n    Can't open cron file for %s.    \n\n",getlogin());
     Message("Warning !!",errmsg);
  }
    
  gtk_widget_show (win_main);

  gtk_main ();
  return 0;
}

void
on_chk_to_toggled                      (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
    gpointer frame;

    frame=gtk_object_get_data(GTK_OBJECT(win_citem), "frame1");
    if(gtk_toggle_button_get_active(togglebutton))    
        gtk_widget_set_sensitive(GTK_WIDGET(frame),1);
    else
        gtk_widget_set_sensitive(GTK_WIDGET(frame),0);
}

void 
Add (void)
{

}

void
on_btn_add_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
    gpointer from,to,chk,lst,sbt;
    char *tpl[3],aux[10]; 
    GtkCList *grd_cron;           

    
    from=gtk_object_get_data(GTK_OBJECT(win_citem), "cmb_from");
    chk=gtk_object_get_data(GTK_OBJECT(win_citem), "chk_to");    
    lst=gtk_object_get_data(GTK_OBJECT(win_citem), "grd_cron");        

    tpl[0]=(char *)strdup(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(from)->entry)));
    if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(chk)))
       {        
             to=gtk_object_get_data(GTK_OBJECT(win_citem), "cmb_to");    
             tpl[1]=(char *)strdup(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(to)->entry)));
             chk=gtk_object_get_data(GTK_OBJECT(win_citem), "chk_step");    
             if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(chk)))
                {
                    sbt=(gpointer)gtk_object_get_data(GTK_OBJECT(win_citem), "sbt_step");
                    sprintf(aux,"%d",gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(sbt)));
                    tpl[2]=(char *)strdup(aux);
                }
                else
                    tpl[2]=(char *)strdup("");
       }                
    else                    
       {       
           tpl[1]=(char *)strdup("");
           tpl[2]=(char *)strdup("");       
       }
       

      
      grd_cron=gtk_object_get_data(GTK_OBJECT(win_citem), "grd_cronln");        
      gtk_clist_append(grd_cron,tpl);                 
 
}

void
on_btn_del_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
      GtkCList *grd_cronln;       
      
      if(GRDSELROW>-1)
          {
              grd_cronln=gtk_object_get_data(GTK_OBJECT(win_citem), "grd_cronln");        
              gtk_clist_remove (grd_cronln, GRDLNSELROW);
          }
   
}

void
on_btn_accept_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
    gchar *txt;
    int i;    
    GtkCList *grd_cron, *grd_cronln;

    
    strcpy(CRONTABLN,"");
    grd_cronln=gtk_object_get_data(GTK_OBJECT(win_citem), "grd_cronln");                             
    
    if(grd_cronln->rows>0){
	    for(i=0;i<grd_cronln->rows;i++)
        	{
	           gtk_clist_get_text(grd_cronln,i,0,&txt);
        	   strcat(CRONTABLN,txt);
	           gtk_clist_get_text(grd_cronln,i,1,&txt);           
           
	           if(strcmp(txt,""))
        	       {
        	           strcat(CRONTABLN,"-");                              
                	   strcat(CRONTABLN,txt);                              
	               }
               
        	   gtk_clist_get_text(grd_cronln,i,2,&txt);           
           
	           if(strcmp(txt,""))
        	       {
                	   strcat(CRONTABLN,"/");                              
	                   strcat(CRONTABLN,txt);                              
        	       }               
               
	           if(i+1<grd_cronln->rows)
        	       strcat(CRONTABLN,",");           
	        }
	}
    else
       {
          strcpy(CRONTABLN,"*");
       }
    grd_cron=gtk_object_get_data(GTK_OBJECT(win_main), "grd_cron");        
    gtk_clist_set_text(grd_cron, GRDSELROW, GRDSELCOL, CRONTABLN);
    
    gtk_widget_destroy(win_citem);    
}


void
on_btn_cancel_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
    gtk_widget_destroy(win_citem);
}



void
on_open_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   Open();
}


void
on_save_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  SvCronFile();  
}


void
on_saveas_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   SvAs();
}

void About(void)
{
   Message("About gcrontab",
           "\ngcrontab ver 0.6.6\n\nA.L.Delgado 2000\naldelgado@arquired.es\n    http://www.arquired.es/users/aldelgado/proy/gcrontab   \n\n");
}


void 
Help(void)
{
   About();
}

void
on_hlp_activate                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   Help();
}




void
on_about_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   About();
}


void
on_file_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void 
Quit(void)
{
   gtk_main_quit();
}

void
on_quit_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   Quit();
}


int 
ReadLn(FILE *pf,char *s)
   {
	   int i=0;
	   s[i++]=fgetc(pf);
	   while ( !feof(pf) && s[i-1]!='\n' )
	      s[i++]=fgetc(pf);
	   s[i-1]='\0';
	   return(1);
   }

int 
IsComentLn(char *IN_line)
   {
	   int i=0;
	   while(i<strlen(IN_line))
	      if(IN_line[i]=='#')
	         return(1);
	      else
	         if(IN_line[i]==' ')
	            i++;
	         else
	            return(0);       
	   return(0);
   }




int 
LdCronFile(char *lname,int fullpath)
    {
       FILE *pf;
       char s[255],f[5][30],*tpl[6];
       int i,j=0;
       GtkCList *grd_cron;       
       char *cronpath[2]={
                         "/var/spool/cron/",
                         "/var/spool/cron/crontabs/",                         
                        };
       
       
       pf=NULL;        
       if(!fullpath){
          for(i=0;i<2&&!pf;i++){
             FNAME=(char *)malloc((strlen(cronpath[i])+strlen(lname)+1));
             strcpy(FNAME,cronpath[i]);
             strcat(FNAME,lname);          
             pf=fopen(FNAME,"r");          
             if(!pf)
               {
/*                  g_print("FNAME: %s\n ",FNAME); */
                  free(FNAME);
                  FNAME=NULL;
               }
          }
       }else{
          struct stat ssb;
          
          stat(lname,&ssb);
          
          if(S_ISREG(ssb.st_mode)){
             FNAME=strdup(lname);
             pf=fopen(FNAME,"r");                    
          }else{
             return(0);
          }
       }
       
       if(!pf) return(0);
              
     

       grd_cron=gtk_object_get_data(GTK_OBJECT(win_main), "grd_cron");  
       gtk_clist_clear(grd_cron);
       gtk_clist_freeze(grd_cron);          
       
       j=0;
       while(!feof(pf))
           {
           ReadLn(pf,s);
           if(!s[0])
              goto ext;
              
           if(!IsComentLn(s))
               {
/*                   g_print("%s\n",s);    */
                   sscanf(s,"%s %s %s %s %s %[^,]",f[0],f[1],f[2],f[3],f[4],f[5]);
                   for(i=0;i<6;i++) tpl[i]=strdup(f[i]);
                   gtk_clist_append(grd_cron,tpl);
               }
           }
   ext: gtk_clist_thaw(grd_cron);   
        return(1);
    }



int 
SvCronFile()
    {
       FILE *pf;
       gchar *txt;
       int i,j=0;
       GtkCList *grd_cron;       
       
       if(!FNAME)
       {
          Message("Error","\n\n    No file to save !!!    \n\n");
          return(0);
       }
       
       pf=fopen(FNAME,"w");
       if(!pf){
          Message("Write Error","\n\n    Can't write file    \n\n");          
          return(0);
/*       }else{
          Message("Writing to",FNAME);          */
       }

       grd_cron=gtk_object_get_data(GTK_OBJECT(win_main), "grd_cron");         
       for(j=0;j<grd_cron->rows;j++)
          {
             for(i=0;i<6;i++)
                 {
                    gtk_clist_get_text(grd_cron,j,i,&txt);             
                    fputs(txt,pf);
                    if(i<5)
                        fputc(' ',pf);
                 }
              fputc('\n',pf);
          }
          
       fclose(pf);
       return(1);   
    }


void
SvAs (void)
{
  win_sel=create_win_filesel(on_ok_button_save_clicked);
  gtk_widget_show(GTK_WIDGET(win_sel));
}

void 
Open(void)
{
  win_sel=create_win_filesel(on_ok_button_open_clicked);
  gtk_widget_show(GTK_WIDGET(win_sel));  
}

void
DelLine (void)
{
      GtkCList *grd_cron;       
      
      if(GRDSELROW>-1)
          {
              grd_cron=GTK_CLIST(gtk_object_get_data(GTK_OBJECT(win_main), "grd_cron"));        
              gtk_clist_remove (grd_cron, GRDSELROW);
          }

}

void
on_btn_delline_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
   DelLine();
}

void 
AddLine (void)
{
      char *tpl[6];
      int i; 
      GtkCList *grd_cron;       
      
      grd_cron=gtk_object_get_data(GTK_OBJECT(win_main), "grd_cron");        
      for(i=0;i<5;i++) tpl[i]=(char *)strdup("*");
      tpl[i]=(char *)strdup("None");
      
      gtk_clist_append(grd_cron,tpl);
}


void
on_btn_addline_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
   AddLine();
}


void
on_grd_cron_select_row                 (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
    GRDSELROW=row;   
}



void
on_grd_cron_unselect_row               (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
    GRDSELROW=-1;   
}

void 
ShowCitem(GList *l,int col)
{
    if(GRDSELROW<=-1) return;
    GRDSELCOL=col;
    
    win_citem = create_win_citem ();
    gtk_window_set_modal(GTK_WINDOW(win_citem),1);                   
    initcmbs(l);        
    gtk_widget_show (win_citem);
}

void
ShowAction(void)
{
    if(GRDSELROW<=-1) return;
    GRDSELCOL=5;
     
    win_cmmd = create_dlg_command();
    gtk_window_set_modal(GTK_WINDOW(win_cmmd),1);                   
    gtk_widget_show (win_cmmd);                
}

void
on_grd_cron_click_column               (GtkCList        *clist,
                                        gint             column,
                                        gpointer         user_data)
{
    if(column<5)
       ShowCitem(lsts[column],column);        
    else
       ShowAction();
}



void
on_grd_cron_click_column_after         (GtkCList        *clist,
                                        gint             column,
                                        gpointer         user_data)
{
       
}


void
on_grd_cronln_select_row               (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
   GRDLNSELROW=row;
}


void
on_grd_cronln_unselect_row             (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
   GRDLNSELROW=-1;
}



void
on_chk_step_toggled                    (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
    gpointer sbt;

    sbt=gtk_object_get_data(GTK_OBJECT(win_citem), "sbt_step");
    if(gtk_toggle_button_get_active(togglebutton))    
        gtk_widget_set_sensitive(GTK_WIDGET(sbt),1);
    else
        gtk_widget_set_sensitive(GTK_WIDGET(sbt),0);
}


void
on_btn_acceptcmmd_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
    gchar *txt;
    GtkCList *grd_cron;
    GtkEntry *edt_cmmd;
    
    edt_cmmd=gtk_object_get_data(GTK_OBJECT(win_cmmd), "edt_command");        
    txt=gtk_entry_get_text(edt_cmmd);
    grd_cron=gtk_object_get_data(GTK_OBJECT(win_main), "grd_cron");        
    
    gtk_clist_set_text(grd_cron, GRDSELROW, 5, txt);
    gtk_widget_destroy(win_cmmd);    
}


void
on_btn_cancelcmd_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
    gtk_widget_destroy(win_cmmd);    
}



void
on_btn_close_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
   FILE *pf;
   guint l;
   gchar *txt;
   GtkText *edt_text;
   struct stat buf;
   
   gtk_widget_hide(win_edit);
   if(TXTDIRTY)
       {
           pf=fopen(FILENAME,"w");
           edt_text=gtk_object_get_data(GTK_OBJECT(win_edit), "edt_text");   
           l=gtk_text_get_length(edt_text);
           txt=gtk_editable_get_chars(GTK_EDITABLE(edt_text),0,l);
           fwrite(txt,1,l,pf);
           fclose(pf);           
           stat(FILENAME,&buf);
           chmod(FILENAME,(buf.st_mode)|S_IXUSR);
           free(FILENAME);
           free(txt);           
       }
   gtk_widget_destroy(win_edit);
}


void
on_ok_button1_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkEntry *edt_action;
  
  FILENAME=(char *)strdup(gtk_file_selection_get_filename (GTK_FILE_SELECTION (win_sel)));
  
  
  gtk_widget_destroy(win_sel);
  
  edt_action=gtk_object_get_data(GTK_OBJECT(win_cmmd), "edt_command");   
  gtk_entry_set_text(edt_action,FILENAME);  
  EditFile(FILENAME, TRUE);  
}

void
on_ok_button_save_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  FILENAME=(char *)strdup(gtk_file_selection_get_filename (GTK_FILE_SELECTION (win_sel)));
  gtk_widget_destroy(win_sel);    
  if(FNAME) free(FNAME);
  FNAME=(char *)strdup(FILENAME);  
  SvCronFile();  
}


void
on_ok_button_open_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  FILENAME=(char *)strdup(gtk_file_selection_get_filename (GTK_FILE_SELECTION (win_sel)));

/*  g_print("<%s>",FILENAME);*/
  if(!FILENAME[0]) return;

  gtk_widget_destroy(win_sel);

  if(!LdCronFile(FILENAME,1))
     Message("Error","\n\n    Can't read crontab file.    \n\n");  
}


void
on_cancel_button1_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
   FILENAME=NULL;
   gtk_widget_destroy(win_sel);   
}


void
on_btn_xtra_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
   gchar *cmmd;
   GtkRadioButton *rbt;
   GtkEntry *edt;
    
   rbt=gtk_object_get_data(GTK_OBJECT(win_cmmd), "rbt_command");      
   if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(rbt)))    
      {
          edt=gtk_object_get_data(GTK_OBJECT(win_cmmd), "edt_command");            
          cmmd=gtk_entry_get_text(edt);             
          
          system(cmmd);
      }
   else
      {
        win_sel=create_win_filesel(on_ok_button1_clicked);
        gtk_window_set_modal(GTK_WINDOW(win_sel),1); 

        if(FILENAME) free(FILENAME);    
        gtk_widget_show (win_sel);              
      }
}


void
on_edt_text_changed                    (GtkEditable     *editable,
                                        gpointer         user_data)
{
   TXTDIRTY=1;
}

void
on_btn_msgok_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
   gtk_widget_destroy(win_msg);
}


void
on_btn_tbrexit_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
   Quit();
}


void
on_btn_tbropen_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
   Open();
}


void
on_btn_tbrsave_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  SvCronFile();  
}


void
on_btn_tbradd_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  AddLine();
}


void
on_btn_tbrdel_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
   DelLine();
}


void
on_btn_tbrhelp_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
   Help();
}


void 
New (void)
{
     GtkCList *grd_cron;       
     
     if(FNAME) free(FNAME);
     FNAME=NULL;

     grd_cron=gtk_object_get_data(GTK_OBJECT(win_main), "grd_cron");  
     gtk_clist_clear(grd_cron);
}

void
on_new_activate                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   New();
}


void
on_btn_tbrnew_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
   New();
}


gboolean
on_win_main_delete_event              (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  Quit();  
  return FALSE;
}


void
on_stdbars_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   static int status=1;
   GtkWidget *tbr;
   tbr=gtk_object_get_data(GTK_OBJECT(win_main), "handlebox4");         
   if(status)
      gtk_widget_hide(tbr);      
   else   
      gtk_widget_show(tbr);
      
   status=!status;
}


void
on_timebar_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   static int status=1;
   GtkWidget *tbr;
   tbr=gtk_object_get_data(GTK_OBJECT(win_main), "handlebox5");         
   if(status)
      gtk_widget_hide(tbr);      
   else   
      gtk_widget_show(tbr);
      
   status=!status;
}


void
on_btn_minute_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
   ShowCitem(lsts[0],0);        
}


void
on_btn_hour_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
   ShowCitem(lsts[1],1);        
}


void
on_btn_dayofmonth_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
   ShowCitem(lsts[2],2);        
}


void
on_btn_month_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
   ShowCitem(lsts[3],3);        
}


void
on_btn_dayofweek_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
   ShowCitem(lsts[4],4);        
}


void
on_btn_action_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
   ShowAction();
}


void
on_cal_selday_day_selected             (GtkCalendar     *calendar,
                                        gpointer         user_data)
{

}


void
on_btn_okcal_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
   guint yy,mm,dd;
   gpointer cal;
   GtkCList *grd_cron;   
   char aux[10],*auxp;
   
   cal=gtk_object_get_data(GTK_OBJECT(win_cal), "cal_selday");   
   gtk_calendar_get_date(GTK_CALENDAR(cal),&yy,&mm,&dd);
   grd_cron=gtk_object_get_data(GTK_OBJECT(win_main), "grd_cron");           
   
   sprintf(aux,"%d",dd);    
   auxp=(char*)strdup(aux);       
   gtk_clist_set_text(grd_cron, GRDSELROW, 2, auxp);   
   
   auxp=(gpointer)g_list_nth_data(month,mm);
   gtk_clist_set_text(grd_cron, GRDSELROW, 3, auxp);   
   
   gtk_widget_destroy(win_cal);   
}


void
on_btn_cancelcal_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
   gtk_widget_destroy(win_cal);
}


void
on_btn_calendar_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
      if(GRDSELROW<=-1) return;
      win_cal=create_win_cal();
      gtk_window_set_modal(GTK_WINDOW(win_cal),1);           
      gtk_widget_show(win_cal);   
}

