; NSIS for GCstar ( http://www.gcstar.org/ )
; Based on Frozen Bubble NSIS

; Helper defines
!define PRODUCT_NAME "GCstar"
!define PRODUCT_VERSION "0.5.0"
!define PRODUCT_PUBLISHER "Tian"
!define PRODUCT_WEB_SITE "http://www.gcstar.org/"
!define PRODUCT_DIR_REGKEY "Software\Microsoft\Windows\CurrentVersion\App Paths\${PRODUCT_NAME}"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"
!define PRODUCT_STARTMENU_REGVAL "NSIS:StartMenuDir"
;Check current version on http://www.activestate.com/Products/Download/Download.plex?id=ActivePerl
!define PERL_VERSION "5.8.7.813-MSWin32-x86-148120"

; MUI 1.67 compatible ------
!include "MUI.nsh"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "img\icon_install.ico"
!define MUI_UNICON "img\icon_uninstall.ico"
!define MUI_HEADERIMAGE
!define MUI_HEADERIMAGE_RIGHT
!define MUI_HEADERIMAGE_BITMAP "img\banner_top.bmp"
!define MUI_HEADERIMAGE_UNBITMAP "img\uninstall_top.bmp"

!define MUI_COMPONENTSPAGE_CHECKBITMAP "img\checks.bmp"

!define MUI_FINISHPAGE_RUN
!define MUI_FINISHPAGE_RUN_FUNCTION "LaunchGCstar"
!define MUI_FINISHPAGE_RUN_TEXT "$(FINISH_LAUNCH)"

!define MUI_FINISHPAGE_LINK "$(FINISH_WEBSITE)"
!define MUI_FINISHPAGE_LINK_LOCATION "${PRODUCT_WEB_SITE}"
!define MUI_FINISHPAGE_LINK_COLOR "1C86EE"

;COLORS
!define MUI_BGCOLOR "FFFFFF"
!define MUI_LICENSEPAGE_BGCOLOR "FFFFFF"
!define MUI_INSTALLCOLORS "1C86EE FFFFFF"
!define MUI_INSTFILESPAGE_COLORS "1C86EE FFFFFF"

; Language Selection Dialog Settings
!define MUI_LANGDLL_REGISTRY_ROOT "${PRODUCT_UNINST_ROOT_KEY}"
!define MUI_LANGDLL_REGISTRY_KEY "${PRODUCT_UNINST_KEY}"
!define MUI_LANGDLL_REGISTRY_VALUENAME "NSIS:Language"

; Welcome page
!define MUI_WELCOMEFINISHPAGE_BITMAP "img\banner_left.bmp"
!insertmacro MUI_PAGE_WELCOME
; License page
!define MUI_LICENSEPAGE_CHECKBOX
!insertmacro MUI_PAGE_LICENSE "gcstar\LICENSE"
; Components page
!insertmacro MUI_PAGE_COMPONENTS
; Directory page
!insertmacro MUI_PAGE_DIRECTORY
; Start menu page
var ICONS_GROUP
;!define MUI_STARTMENUPAGE_NODISABLE
!define MUI_STARTMENUPAGE_DEFAULTFOLDER "GCstar"
!define MUI_STARTMENUPAGE_REGISTRY_ROOT "${PRODUCT_UNINST_ROOT_KEY}"
!define MUI_STARTMENUPAGE_REGISTRY_KEY "${PRODUCT_UNINST_KEY}"
!define MUI_STARTMENUPAGE_REGISTRY_VALUENAME "${PRODUCT_STARTMENU_REGVAL}"
!insertmacro MUI_PAGE_STARTMENU Application $ICONS_GROUP
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; MUI end ------

; Languages
!include "gcs_lang.nsh"

${LANG_LOAD} "English"
${LANG_LOAD} "French"

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "${PRODUCT_NAME}_${PRODUCT_VERSION}_Setup.exe"
InstallDir "$PROGRAMFILES\GCstar"
InstallDirRegKey HKLM "${PRODUCT_DIR_REGKEY}" ""
ShowInstDetails hide
ShowUnInstDetails hide

InstType "$(INSTALL_APP_DEP)"
InstType "$(INSTALL_APP_ONLY)"
InstType "$(INSTALL_FULL)"

Function .onInit
  !define MUI_LANGDLL_ALWAYSSHOW
  !insertmacro MUI_LANGDLL_DISPLAY

  ;Prevent Multiple Instances:
  System::Call 'kernel32::CreateMutexA(i 0, i 0, t "GCstarSetup") i .r1 ?e'
  Pop $R0
  StrCmp $R0 0 +3
  MessageBox MB_OK|MB_ICONEXCLAMATION "$(PRE_MULTIPLE)"
  Abort

  ReadRegStr $0 HKLM "Software\Perl" BinDir
  StrCmp $0 "" NoPerl
    SectionSetFlags 2 16
    SectionSetInstTypes 2 0
    ;SectionSetText 2 ""
    Goto TestRemove

  NoPerl:
    ;SectionSetInstTypes 2 7
    SectionSetFlags 2 25
  
  TestRemove:
    ReadRegStr $R0 HKLM \
     "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}" \
     "UninstallString"
    StrCmp $R0 "" NoRemove
      Return
    NoRemove:
      SectionSetText 0 ""    ; and make invisible so user doesn't see it
      Return
FunctionEnd

Function LaunchGCstar
  SetOutPath "$INSTDIR\bin"
  Exec "$\"$INSTDIR\bin\gcstar.bat$\""
FunctionEnd

Section "$(SEC_UN)" SEC01
  SectionIn 3
  ReadRegStr $R0 HKLM \
  "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}" \
  "UninstallString"
  StrCmp $R0 "" NoRemove  
  call RemovePrevious
 NoRemove:
SectionEnd

SectionGroup  "$(SEC_DEPENDENCIES)" GroupSec00

Section "!$(SEC_ACTIVEPERL)" SEC00
  SectionIn 1 2 3 RO
  ReadRegStr $0 HKLM "Software\Perl" BinDir
  StrCmp $0 "" 0 GotPerl
    call ConnectInternet
    NSISdl::download \
      /TRANSLATE "$(DOWNLOAD_DOWNLOADING)" \
                 "$(DOWNLOAD_CONNECTING)" \
                 "$(DOWNLOAD_SECOND)" \
                 "$(DOWNLOAD_MINUTE)" \
                 "$(DOWNLOAD_HOUR)" \
                 "$(DOWNLOAD_PLURAL)" \
                 "$(DOWNLOAD_PROGRESS)" \
                 "$(DOWNLOAD_REMAINING)" \
      "http://downloads.activestate.com/ActivePerl/Windows/5.8/ActivePerl-${PERL_VERSION}.msi" \
      "$TEMP\perl-installer.msi"
    Pop $R0 ;Get the return value
    StrCmp $R0 "success" 0 +3  
    ExecWait 'msiexec /i $TEMP\perl-installer.msi'
    IfErrors 0 +6
      Delete $TEMP\perl-installer.msi
      MessageBox MB_YESNO|MB_ICONEXCLAMATION "$(PERL_INSTALLERROR)" IDNO +2
      ExecShell open http://www.activestate.com/Products/ActivePerl/
      Abort

    Delete $TEMP\perl-installer.msi
  GotPerl:
SectionEnd

SectionGroup "GTK-Perl" GroupSec01

Section "$(SEC_LIB)" SEC03
  SectionIn 1 3
  SetOutPath "$INSTDIR\usr"
  SetOverwrite try
  File /r "usr\*"
  Push $4
  Call IsNT
  Pop $1
  StrCmp $1 0 SkipProfileSelection
  ;Call select_NT_profile
  ;Pop  $4
  StrCpy $4 "all"
 SkipProfileSelection:
  ;Push "$INSTDIR\usr\lib"
  ;Call AddToPath
  Push "$INSTDIR\usr\bin"
  Call AddToPath
  Pop $4
SectionEnd

Section "$(SEC_PPM)" SEC04
  SectionIn 1 3
  SetOutPath "$TEMP"
  SetOverwrite on
  File "gtk-perl\*"

  ReadRegStr $0 HKLM "Software\Perl" BinDir
  ExecWait "$0 -e $\" \
  	$$| = 1; \
  	print '$(PERL_VERIFYING)$\n'; \
  	`ppm repository add GCstar_current .`; \
    $$file=(glob 'Gtk2*.tgz')[0]; \
    ($$newVersion = $$file) =~ s/.*?Gtk2-([0-9.]*)\.tgz/$$1/; \
    ($$query = `ppm query Gtk2`); \
    $$installedVersion = 0; \
    if ($$query =~ /\[([0-9.]+)\]/) \
    { \
    	$$installedVersion = $$1; \
    } \
    if (!$$installedVersion) \
    { \
        print '$(PERL_INSTALLING) ExtUtils-Depends...$\n'; \
        `ppm install ExtUtils-Depends.ppd`; \
    	print '$(PERL_INSTALLING) ExtUtils-PkgConfig...$\n'; \
	    `ppm install ExtUtils-PkgConfig.ppd`; \
    	print '$(PERL_INSTALLING) Glib...$\n'; \
	    `ppm install Glib.ppd`; \
    	print '$(PERL_INSTALLING) Gtk2...$\n'; \
	    `ppm install Gtk2.ppd`; \
    } \
    elsif ($$installedVersion ne $$newVersion) \
    { \
    	print '$(PERL_UPDATING) Gtk2. $(PERL_WAIT)$\n'; \
    	`ppm install Gtk2.ppd -force`; \
    } \
    `ppm repository delete GCstar_current`; \
    exit 0 \
  $\"" $1
  
  StrCmp $1 0 "" Failed
  Delete "$TEMP\ExtUtils-Depends*"
  Delete "$TEMP\ExtUtils-PkgConfig*"
  Delete "$TEMP\Glib*"
  Delete "$TEMP\Gtk2*"
  Return
  
  Failed:
  MessageBox MB_OK|MB_ICONSTOP "Installation failed. Please install \
Gtk-Perl manually and run this installer again."
  Abort
SectionEnd

SectionGroupEnd
SectionGroupEnd

Section "!GCstar" SEC02
  SectionIn 1 2 3 RO
  SetOutPath "$INSTDIR"
  SetOverwrite try
  File /r "gcstar\*"
  
  Call SetFileAssociation
  
  SetOutPath "$INSTDIR\bin"
  File "gcstar.bat"
  File "update.bat"

  ReadRegStr $0 HKLM "Software\Perl" BinDir
  StrCpy $R0 $0 -8
  FileOpen $1 "gcstar.bat" a
  FileSeek $1 0 END
  FileWrite $1 "start $\"$\" $\"$R0wperl.exe$\" gcstar %1$\r$\n"
  FileClose $1
  FileOpen $1 "update.bat" a
  FileSeek $1 0 END
  FileWrite $1 "start $\"$\" $\"$0$\" gcstar -u$\r$\n"
  FileClose $1

  
; Shortcuts
  !insertmacro MUI_STARTMENU_WRITE_BEGIN Application
  CreateDirectory "$SMPROGRAMS\$ICONS_GROUP"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\$(LINK_APPLICATION).lnk" '"$INSTDIR\bin\gcstar.bat"' "" $INSTDIR\share\gcstar\icons\GCstar.ico "" SW_SHOWMINIMIZED "" "$(LINK_APPLICATION_DESCRIPTION)"
  !insertmacro MUI_STARTMENU_WRITE_END
SectionEnd

SectionGroup "$(SEC_ICONS)" GroupSec02

Section "$(SEC_DSK)" SEC05
  SectionIn 1 3
  SetOutPath "$INSTDIR\bin"
  CreateShortCut "$DESKTOP\$(LINK_APPLICATION).lnk" '"$INSTDIR\bin\gcstar.bat"' "" $INSTDIR\share\gcstar\icons\GCstar.ico "" SW_SHOWMINIMIZED "" "$(LINK_APPLICATION_DESCRIPTION)"
SectionEnd

Section "$(SEC_QUICK)" SEC06
  SectionIn 1 3
  StrCmp $QUICKLAUNCH $TEMP +3
  SetOutPath "$INSTDIR\bin"
  CreateShortCut "$QUICKLAUNCH\$(LINK_APPLICATION).lnk" '"$INSTDIR\bin\gcstar.bat"' "" $INSTDIR\share\gcstar\icons\GCstar.ico "" SW_SHOWMINIMIZED "" "$(LINK_APPLICATION_DESCRIPTION)"
SectionEnd

SectionGroupEnd

Section -AdditionalIcons
  !insertmacro MUI_STARTMENU_WRITE_BEGIN Application
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\$(LINK_UPDATE).lnk" '"$INSTDIR\bin\update.bat"' "" $INSTDIR\share\gcstar\icons\icon_install.ico "" "" "" "$(LINK_UPDATE_DESCRIPTION)"
  WriteIniStr "$INSTDIR\${PRODUCT_NAME}.url" "InternetShortcut" "URL" "${PRODUCT_WEB_SITE}"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\$(LINK_SITE).lnk" "$INSTDIR\${PRODUCT_NAME}.url" "" $INSTDIR\share\gcstar\icons\web.ico "" "" "" "$(LINK_SITE_DESCRIPTION)"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\$(LINK_REMOVE).lnk" "$INSTDIR\uninst.exe" "" "" "" "" "" "$(LINK_REMOVE_DESCRIPTION)"
  !insertmacro MUI_STARTMENU_WRITE_END
SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "" "$INSTDIR\bin\gcstar"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$INSTDIR\gcstar"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
SectionEnd

; Section descriptions
!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
  !insertmacro MUI_DESCRIPTION_TEXT ${GroupSec00} "$(DESC_DEPENDENCIES)"
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC00} "$(DESC_ACTIVEPERL)"
  !insertmacro MUI_DESCRIPTION_TEXT ${GroupSec01} "$(DESC_GTKPERL)"
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC03} "$(DESC_GTK)"
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC04} "$(DESC_PERL)"
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC01} "$(DESC_UN)"
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC02} "$(DESC_APP)"
  !insertmacro MUI_DESCRIPTION_TEXT ${GroupSec02} "$(DESC_ICONS)"
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC05} "$(DESC_DESKTOP)"
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC06} "$(DESC_QUICK)"
!insertmacro MUI_FUNCTION_DESCRIPTION_END


Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "$(^Name) has been successfullly removed from your computer."
FunctionEnd

Function un.onInit
  !insertmacro MUI_UNGETLANGUAGE
FunctionEnd

Section Uninstall

  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "$(UN_QUESTION)" IDYES DoUnInstall
  
  Abort "$(UN_ABORTED)"
  Quit
  
  DoUnInstall:
  
  !insertmacro MUI_STARTMENU_GETFOLDER "Application" $ICONS_GROUP

  Delete "$SMPROGRAMS\$ICONS_GROUP\Uninstall.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\Website.lnk"
  Delete "$DESKTOP\GCstar.lnk"
  Delete "$QUICKLAUNCH\GCstar.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\GCstar.lnk"
  RMDir "$SMPROGRAMS\$ICONS_GROUP"

  RMDir /r "$INSTDIR\bin"
  RMDir /r "$INSTDIR\lib"
  RMDir /r "$INSTDIR\packages"
  RMDir /r "$INSTDIR\share"
  RMDir /r "$INSTDIR\templates"
  RMDir /r "$INSTDIR\usr"
  
  Delete "$INSTDIR\*"

  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "$(UN_PERSO)" IDNO ContinueUnInstall
  
  RMDir /r "$INSTDIR\data"
  RMDir /r "$INSTDIR\config"  
  
  ContinueUninstall:

  Call un.RemoveFileAssociation

  ;Push $4
  ;Call un.IsNT
  ;Pop $1
  ;StrCmp $1 0 SkipProfileSelection
  ;Call un.select_NT_profile
  ;Pop  $4
 ;SkipProfileSelection:
  ;StrCpy $5 "all"
  ;Push "$INSTDIR\usr\lib"
  ;Call un.RemoveFromPath
  StrCpy $5 "all"
  Push "$INSTDIR\usr\bin"
  Call un.RemoveFromPath
  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  DeleteRegKey HKLM "${PRODUCT_DIR_REGKEY}"
  SetAutoClose true
SectionEnd

;----------------------------------------
; based upon a script of "Written by KiCHiK 2003-01-18 05:57:02"
;----------------------------------------
!verbose 3
!include "WinMessages.nsh"
!verbose 4
;----------------------------------------------------
!define NT_current_env 'HKCU "Environment"'
!define NT_all_env     'HKLM "SYSTEM\CurrentControlSet\Control\Session Manager\Environment"'
;====================================================
; IsNT - Returns 1 if the current system is NT, 0
;        otherwise.
;     Output: head of the stack
;====================================================
!macro IsNT UN
Function ${UN}IsNT
  Push $0
  ReadRegStr $0 HKLM "SOFTWARE\Microsoft\Windows NT\CurrentVersion" CurrentVersion
  StrCmp $0 "" 0 IsNT_yes
  ; we are not NT.
  Pop $0
  Push 0
  Return

  IsNT_yes:
    ; NT!!!
    Pop $0
    Push 1
FunctionEnd
!macroend
!insertmacro IsNT ""
!insertmacro IsNT "un."
;====================================================
; AddToPath - Adds the given dir to the search path.
;        Input - head of the stack
;        Note - Win9x systems requires reboot
;====================================================
Function AddToPath
   Exch $0
   Push $1
   Push $2
  
   Call IsNT
   Pop $1
   StrCmp $1 1 AddToPath_NT
      ; Not on NT
      StrCpy $1 $WINDIR 2
      FileOpen $1 "$1\autoexec.bat" a
      FileSeek $1 0 END
      GetFullPathName /SHORT $0 $0
      FileWrite $1 "$\r$\nSET PATH=%PATH%;$0$\r$\n"
      FileClose $1
      Goto AddToPath_done

   AddToPath_NT:
      ;Push $4
      ;Call select_NT_profile
      ;Pop  $4

      AddToPath_NT_selection_done:
      StrCmp $4 "current" read_path_NT_current
         ReadRegStr $1 ${NT_all_env} "PATH"
         Goto read_path_NT_resume
      read_path_NT_current:
         ReadRegStr $1 ${NT_current_env} "PATH"
      read_path_NT_resume:
         ;StrCmp $1 "" AddToPath_NTdoIt
         StrCpy $2 "$1;$0"
         Goto AddToPath_NTdoIt
      AddToPath_NTdoIt:
         StrCmp $4 "current" write_path_NT_current
            ClearErrors
            ; Try to change for all users
            WriteRegExpandStr ${NT_all_env} "PATH" $2
            IfErrors 0 write_path_NT_resume
            ;MessageBox MB_YESNO|MB_ICONQUESTION "$(INSTALL_ALL_ERROR)" \
            ;   IDNO write_path_NT_failed
            ; change selection
            StrCpy $4 "current"
            Goto AddToPath_NT_selection_done
         write_path_NT_current:
            ClearErrors
            WriteRegExpandStr ${NT_current_env} "PATH" $2
            IfErrors 0 write_path_NT_resume
            MessageBox MB_OK|MB_ICONINFORMATION ""
            Goto write_path_NT_failed
         write_path_NT_resume:
         SendMessage ${HWND_BROADCAST} ${WM_WININICHANGE} 0 "STR:Environment" /TIMEOUT=5000
         DetailPrint "Added path for user ($4), $0"
         write_path_NT_failed:
      
      ;Pop $4
   AddToPath_done:
   Pop $2
   Pop $1
   Pop $0
FunctionEnd

;====================================================
; RemoveFromPath - Remove a given dir from the path
;     Input: head of the stack
;====================================================
Function un.RemoveFromPath
   Exch $0
   Push $1
   Push $2
   Push $3
   Push $4
   Push $5
   Push $6
   
   StrCpy $6 $0
   
   Call un.IsNT
   Pop $1
   ;StrCpy $5 "all"
   StrCmp $1 1 unRemoveFromPath_NT
      ; Not on NT
      StrCpy $1 $WINDIR 2
      FileOpen $1 "$1\autoexec.bat" r
      GetTempFileName $4
      FileOpen $2 $4 w
      GetFullPathName /SHORT $0 $0
      StrCpy $0 "SET PATH=%PATH%;$0"
      SetRebootFlag true
      Goto unRemoveFromPath_dosLoop
     
      unRemoveFromPath_dosLoop:
         FileRead $1 $3
         StrCmp $3 "$0$\r$\n" unRemoveFromPath_dosLoop
         StrCmp $3 "$0$\n" unRemoveFromPath_dosLoop
         StrCmp $3 "$0" unRemoveFromPath_dosLoop
         StrCmp $3 "" unRemoveFromPath_dosLoopEnd
         FileWrite $2 $3
         Goto unRemoveFromPath_dosLoop

      unRemoveFromPath_dosLoopEnd:
         FileClose $2
         FileClose $1
         StrCpy $1 $WINDIR 2
         Delete "$1\autoexec.bat"
         CopyFiles /SILENT $4 "$1\autoexec.bat"
         Delete $4
         Goto unRemoveFromPath_done
 
   unRemoveFromPath_NT:
      StrLen $2 $0

      StrCmp $5 "current" un_read_path_NT_current
         ReadRegStr $1 ${NT_all_env} "PATH"
         Goto un_read_path_NT_resume
      un_read_path_NT_current:
         ReadRegStr $1 ${NT_current_env} "PATH"
      un_read_path_NT_resume:

      Push $1
      Push $0
      Call un.StrStr ; Find $0 in $1
      Pop $0 ; pos of our dir
      IntCmp $0 -1 unRemoveFromPath_loopIfNeeded
         ; else, it is in path
         StrCpy $3 $1 $0 ; $3 now has the part of the path before our dir
         IntOp $2 $2 + $0 ; $2 now contains the pos after our dir in the path (';')
         IntOp $2 $2 + 1 ; $2 now containts the pos after our dir and the semicolon.
         StrLen $0 $1
         StrCpy $1 $1 $0 $2
         StrCpy $3 "$3$1"

         StrCmp $5 "current" un_write_path_NT_current
            WriteRegExpandStr ${NT_all_env} "PATH" $3
            Goto un_write_path_NT_resume
         un_write_path_NT_current:
            WriteRegExpandStr ${NT_current_env} "PATH" $3
         un_write_path_NT_resume:
         SendMessage ${HWND_BROADCAST} ${WM_WININICHANGE} 0 "STR:Environment" /TIMEOUT=5000
      unRemoveFromPath_loopIfNeeded:
            StrCmp $5 "current" unRemoveFromPath_done
            StrCpy $5 "current"
            Push $6
            Call un.RemoveFromPath
   unRemoveFromPath_done:
   Pop $6
   Pop $5
   Pop $4
   Pop $3
   Pop $2
   Pop $1
   Pop $0
FunctionEnd
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Uninstall sutff
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;====================================================
; StrStr - Finds a given string in another given string.
;               Returns -1 if not found and the pos if found.
;          Input: head of the stack - string to find
;                      second in the stack - string to find in
;          Output: head of the stack
;====================================================
Function un.StrStr
  Push $0
  Exch
  Pop $0 ; $0 now have the string to find
  Push $1
  Exch 2
  Pop $1 ; $1 now have the string to find in
  Exch
  Push $2
  Push $3
  Push $4
  Push $5

  StrCpy $2 -1
  StrLen $3 $0
  StrLen $4 $1
  IntOp $4 $4 - $3

  unStrStr_loop:
    IntOp $2 $2 + 1
    IntCmp $2 $4 0 0 unStrStrReturn_notFound
    StrCpy $5 $1 $3 $2
    StrCmp $5 $0 unStrStr_done unStrStr_loop

  unStrStrReturn_notFound:
    StrCpy $2 -1

  unStrStr_done:
    Pop $5
    Pop $4
    Pop $3
    Exch $2
    Exch 2
    Pop $0
    Pop $1
FunctionEnd
;====================================================

;====================================================
; Usefull for file association
;====================================================
Function SetFileAssociation
    !define Index "Line${__LINE__}"
      ReadRegStr $1 HKCR ".gcs" ""
      StrCmp $1 "" "${Index}-NoBackup"
        StrCmp $1 "GCstarFile" "${Index}-NoBackup"
        WriteRegStr HKCR ".gcs" "backup_val" $1
    "${Index}-NoBackup:"
      WriteRegStr HKCR ".gcs" "" "GCstarFile"
      ReadRegStr $0 HKCR "GCstarFile" ""
      StrCmp $0 "" 0 "${Index}-Skip"
        WriteRegStr HKCR "GCstarFile" "" "$(FILE_DESC)"
        WriteRegStr HKCR "GCstarFile\shell" "" "open"
        WriteRegStr HKCR "GCstarFile\DefaultIcon" "" "$INSTDIR\share\gcstar\icons\GCstar.ico"
    "${Index}-Skip:"
      WriteRegStr HKCR "GCstarFile\shell\open\command" "" \
        '"$INSTDIR\bin\gcstar.bat" "%1"'
    !undef Index
    Call RefreshShellIcons
FunctionEnd

Function un.RemoveFileAssociation
    !define Index "Line${__LINE__}"
      ReadRegStr $1 HKCR ".gcs" ""
      StrCmp $1 "GCstarFile" 0 "${Index}-NoOwn" ; only do this if we own it
        ReadRegStr $1 HKCR ".gcs" "backup_val"
        StrCmp $1 "" 0 "${Index}-Restore" ; if backup="" then delete the whole key
          DeleteRegKey HKCR ".gcs"
        Goto "${Index}-NoOwn"
    "${Index}-Restore:"
          WriteRegStr HKCR ".gcs" "" $1
          DeleteRegValue HKCR ".gcs" "backup_val"
    
    "${Index}-NoOwn:"
    DeleteRegKey HKCR "GCstarFile" ;Delete key with association settings
    !undef Index
    Call un.RefreshShellIcons
FunctionEnd

!define SHCNE_ASSOCCHANGED 0x08000000
!define SHCNF_IDLIST 0

Function RefreshShellIcons
  ; By jerome tremblay - april 2003
  System::Call 'shell32.dll::SHChangeNotify(i, i, i, i) v \
  (${SHCNE_ASSOCCHANGED}, ${SHCNF_IDLIST}, 0, 0)'
FunctionEnd

Function un.RefreshShellIcons
  ; By jerome tremblay - april 2003
  System::Call 'shell32.dll::SHChangeNotify(i, i, i, i) v \
  (${SHCNE_ASSOCCHANGED}, ${SHCNF_IDLIST}, 0, 0)'
FunctionEnd

Function RemovePrevious
  ReadRegStr $R0 HKLM \
  "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}" \
  "DisplayVersion"

  ReadRegStr $R0 HKLM \
  "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}" \
  "UninstallString"

  ;Run the uninstaller
  ClearErrors
  ExecWait '$R0 _?=$INSTDIR' ;Do not copy the uninstaller to a temp file
   
  IfErrors no_remove_uninstaller
    ;You can either use Delete /REBOOTOK in the uninstaller or add some code
    ;here to remove to remove the uninstaller. Use a registry key to check
    ;whether the user has chosen to uninstall. If you are using an uninstaller
    ;components page, make sure all sections are uninstalled.
  no_remove_uninstaller:

FunctionEnd

Function ConnectInternet
 
  Push $R0

  ClearErrors
  Dialer::AttemptConnect
  IfErrors noie3

   Pop $R0
   StrCmp $R0 "online" connected
     MessageBox MB_OK|MB_ICONSTOP "Cannot connect to the internet."
     Quit ;This will quit the installer. You might want to add your own error handling.

  noie3:
    ; IE3 not installed
    MessageBox MB_OK|MB_ICONINFORMATION "Please connect to the internet now."
     
  connected:
    Pop $R0
   
FunctionEnd


