/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.NumericalType;
import ch.interlis.ili2c.metamodel.PrecisionDecimal;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.Unit;
import java.beans.PropertyVetoException;
import java.math.BigDecimal;

public class NumericType
extends NumericalType {
    protected PrecisionDecimal minimum;
    protected PrecisionDecimal maximum;

    public NumericType() {
        this.maximum = null;
        this.minimum = null;
    }

    public PrecisionDecimal getMinimum() {
        return this.minimum;
    }

    public PrecisionDecimal getMaximum() {
        return this.maximum;
    }

    public NumericType(PrecisionDecimal minimum, PrecisionDecimal maximum) {
        if (minimum == null || maximum == null) {
            throw new IllegalArgumentException(Element.rsrc.getString("err_nullNotAcceptable"));
        }
        if (minimum.compareTo(maximum) == 1) {
            throw new IllegalArgumentException(Element.rsrc.getString("err_numericType_minGreaterMax"));
        }
        if (minimum.scale() != maximum.scale()) {
            throw new IllegalArgumentException(Element.rsrc.getString("err_numericType_precisionMismatch"));
        }
        this.minimum = minimum;
        this.maximum = maximum;
    }

    public String toString() {
        if (this.minimum == null || this.maximum == null) {
            return "NUMERIC";
        }
        return String.valueOf(this.minimum.toString()) + ".." + this.maximum.toString();
    }

    public boolean isAbstract() {
        if (this.minimum == null || this.maximum == null) {
            return true;
        }
        Unit unit = this.getUnit();
        return unit != null && unit.isAbstract();
    }

    public void setUnit(Unit unit) throws PropertyVetoException {
        Unit oldValue = this.unit;
        Unit newValue = unit;
        if (oldValue == newValue) {
            return;
        }
        if (newValue != null && this.minimum != null && newValue.isAbstract()) {
            throw new IllegalArgumentException(Element.formatMessage("err_numericType_concreteWithAbstractUnit", newValue.toString()));
        }
        this.fireVetoableChange("unit", oldValue, newValue);
        this.unit = newValue;
        this.firePropertyChange("unit", oldValue, newValue);
    }

    public Unit getUnit() {
        Type realExt = this.extending != null ? this.extending.resolveAliases() : null;
        if (this.unit == null && realExt instanceof NumericType) {
            return ((NumericType)realExt).getUnit();
        }
        return this.unit;
    }

    void checkTypeExtension(Type wantToExtend) {
        super.checkTypeExtension(wantToExtend);
        if (wantToExtend == null || (wantToExtend = wantToExtend.resolveAliases()) == null) {
            return;
        }
        if (!(wantToExtend instanceof NumericType)) {
            throw new IllegalArgumentException(Element.rsrc.getString("err_numericType_ExtOther"));
        }
        NumericType general = (NumericType)wantToExtend;
        if (this.isAbstract() && !general.isAbstract()) {
            throw new IllegalArgumentException(Element.rsrc.getString("err_numericType_abstractExtConcrete"));
        }
        if (this.minimum != null && this.maximum != null && general.minimum != null && general.maximum != null) {
            BigDecimal min_rounded = this.minimum.setScale(general.minimum.scale(), 4);
            BigDecimal max_rounded = this.maximum.setScale(general.maximum.scale(), 4);
            if (min_rounded.compareTo(general.minimum) == -1) {
                throw new IllegalArgumentException(Element.formatMessage("err_numericType_minLessInheritedMin", Integer.toString(general.minimum.scale()), this.minimum.toString(), min_rounded.toString(), general.minimum.toString()));
            }
            if (max_rounded.compareTo(general.maximum) == 1) {
                throw new IllegalArgumentException(Element.formatMessage("err_numericType_maxGreaterInheritedMax", Integer.toString(general.maximum.scale()), this.maximum.toString(), max_rounded.toString(), general.maximum.toString()));
            }
        }
        if (this.unit != null) {
            Unit generalUnit = general.getUnit();
            if (!general.isAbstract() && generalUnit == null) {
                throw new IllegalArgumentException(Element.rsrc.getString("err_numericType_withUnitExtWithoutUnit"));
            }
            if (generalUnit != null && generalUnit.isAbstract() && !this.unit.isExtendingIndirectly(generalUnit)) {
                throw new IllegalArgumentException(Element.formatMessage("err_numericType_unitNotExtAbstractBaseUnit", this.unit.toString(), generalUnit.toString()));
            }
            if (generalUnit != null && !generalUnit.isAbstract() && generalUnit != this.unit) {
                throw new IllegalArgumentException(Element.formatMessage("err_numericType_unitExtConcreteBaseUnit", this.unit.toString(), generalUnit.toString()));
            }
        }
        String errorString = null;
        block0 : switch (this.getRotation()) {
            case 0: {
                switch (general.getRotation()) {
                    case 1: {
                        errorString = "err_numericType_noneExtCw";
                        break;
                    }
                    case 2: {
                        errorString = "err_numericType_noneExtCcw";
                    }
                }
                break;
            }
            case 1: {
                switch (general.getRotation()) {
                    case 0: {
                        errorString = "err_numericType_cwExtNone";
                        break;
                    }
                    case 2: {
                        errorString = "err_numericType_cwExtCcw";
                    }
                }
                break;
            }
            case 2: {
                switch (general.getRotation()) {
                    case 0: {
                        errorString = "err_numericType_ccwExtNone";
                        break block0;
                    }
                    case 1: {
                        errorString = "err_numericType_ccwExtCw";
                    }
                }
            }
        }
        if (errorString != null) {
            throw new IllegalArgumentException(Element.rsrc.getString(errorString));
        }
    }
}

