/* gEDA - GPL Electronic Design Automation
 * gschem - gEDA Schematic Capture
 * Copyright (C) 1998-2000 Ales V. Hvezda
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA
 */


/* DO NOT read or edit this file ! Use ../noweb/x_menus.nw instead */

#include <config.h>

#ifdef HAVE_STRINGS_H
#include <strings.h>
#endif

#include <libgeda/libgeda.h>

#include "../include/prototype.h"

void print_hello(gpointer data, guint callback_action, GtkWidget * widget)
{
  TOPLEVEL *w_current;

  w_current = (TOPLEVEL *) data;

  exit_if_null(w_current);

  printf("inside callback: %d %s\n", w_current->wid,
	 w_current->untitled_name);
}


#if 0
/* gtk+ 1.2.x menu definitions */
static GtkItemFactoryEntry menu_items[] = {
  {"/File", NULL, NULL, 0, "<Branch>"},
  {"/File/tearoff", NULL, NULL, 0, "<Tearoff>"},
  {"/File/New Window", NULL, i_callback_file_new_window, 0, NULL},
  {"/File/New Page", NULL, i_callback_file_new, 0, NULL},
  {"/File/Open Page...", NULL, i_callback_file_open, 0, NULL},
  {"/File/Close Page", NULL, i_callback_page_close, 0, NULL},
  {"/File/Revert Page", NULL, i_callback_page_revert, 0, NULL},
  {"/File/Save Page", NULL, i_callback_file_save, 0, NULL},
  {"/File/Save Page as....", NULL, i_callback_file_save_as, 0, NULL},
  {"/File/Save All", NULL, i_callback_file_save_all, 0, NULL},
  {"/File/Print...", NULL, i_callback_file_print, 0, NULL},
#ifdef HAS_LIBGDGEDA
  {"/File/Write PNG...", NULL, i_callback_file_write_png, 0, NULL},
#endif
  {"/File/sep1", NULL, NULL, 0, "<Separator>"},
  {"/File/Script Execute...", NULL, i_callback_file_script, 0, NULL},
  {"/File/sep2", NULL, NULL, 0, "<Separator>"},
  {"/File/Close Window", NULL, i_callback_file_close, 0, NULL},
  {"/File/Quit gschem", NULL, i_callback_file_quit, 0, NULL},
  /* because i_callback_file_quit returns an int, the compiler complains */
  {"/Edit", NULL, NULL, 0, "<Branch>"},
  {"/Edit/tearoff", NULL, NULL, 0, "<Tearoff>"},
  {"/Edit/Undo", NULL, i_callback_edit_undo, 0, NULL},
  {"/Edit/Redo", NULL, i_callback_edit_redo, 0, NULL},
  {"/Edit/sep1", NULL, NULL, 0, "<Separator>"},
  {"/Edit/Select Mode", NULL, i_callback_edit_select, 0, NULL},
  {"/Edit/Edit...", NULL, i_callback_edit_edit, 0, NULL},
  {"/Edit/Edit Text...", NULL, i_callback_edit_text, 0, NULL},
  {"/Edit/Copy Mode", NULL, i_callback_edit_copy, 0, NULL},
  {"/Edit/Move Mode", NULL, i_callback_edit_move, 0, NULL},
  {"/Edit/Delete", NULL, i_callback_edit_delete, 0, NULL},
  {"/Edit/Rotate 90 Mode", NULL, i_callback_edit_rotate_90, 0, NULL},
  {"/Edit/Mirror Mode", NULL, i_callback_edit_mirror, 0, NULL},
  /* {"/Edit/Stretch Mode", NULL, i_callback_edit_stretch, 0, NULL}, obsolete */
  {"/Edit/sep2", NULL, NULL, 0, "<Separator>"},
  {"/Edit/Slot...", NULL, i_callback_edit_slot, 0, NULL},
  {"/Edit/Color...", NULL, i_callback_edit_color, 0, NULL},
  {"/Edit/Lock", NULL, i_callback_edit_lock, 0, NULL},
  {"/Edit/Unlock", NULL, i_callback_edit_unlock, 0, NULL},
  {"/Edit/Line Width & Type...", NULL, i_callback_edit_linetype, 0, NULL},
  {"/Edit/Line Fill Type...", NULL, i_callback_edit_filltype, 0, NULL},
  {"/Edit/Symbol Translate...", NULL, i_callback_edit_translate, 0, NULL},
  {"/Edit/Embed Component", NULL, i_callback_edit_embed, 0, NULL},
  {"/Edit/Unembed Component", NULL, i_callback_edit_unembed, 0, NULL},
  {"/Edit/Show Hidden Text", NULL, i_callback_edit_show_hidden, 0, NULL},
  {"/Buffer", NULL, NULL, 0, "<Branch>"},
  {"/Buffer/tearoff", NULL, NULL, 0, "<Tearoff>"},
  {"/Buffer/Copy", NULL, NULL, 0, "<Branch>"},
  {"/Buffer/Copy/tearoff", NULL, NULL, 0, "<Tearoff>"},
  
      {"/Buffer/Copy/Copy into buffer 1", NULL, i_callback_buffer_copy1, 0,
   NULL},
  {"/Buffer/Copy/Copy into buffer 2", NULL, i_callback_buffer_copy2, 0,
   NULL},
  {"/Buffer/Copy/Copy into buffer 3", NULL, i_callback_buffer_copy3, 0,
   NULL},
  {"/Buffer/Copy/Copy into buffer 4", NULL, i_callback_buffer_copy4, 0,
   NULL},
  {"/Buffer/Copy/Copy into buffer 5", NULL, i_callback_buffer_copy5, 0,
   NULL},
  {"/Buffer/Cut", NULL, NULL, 0, "<Branch>"},
  {"/Buffer/Cut/tearoff", NULL, NULL, 0, "<Tearoff>"},
  {"/Buffer/Cut/Cut into buffer 1", NULL, i_callback_buffer_cut1, 0, NULL},
  {"/Buffer/Cut/Cut into buffer 2", NULL, i_callback_buffer_cut2, 0, NULL},
  {"/Buffer/Cut/Cut into buffer 3", NULL, i_callback_buffer_cut3, 0, NULL},
  {"/Buffer/Cut/Cut into buffer 4", NULL, i_callback_buffer_cut4, 0, NULL},
  {"/Buffer/Cut/Cut into buffer 5", NULL, i_callback_buffer_cut5, 0, NULL},
  {"/Buffer/Paste", NULL, NULL, 0, "<Branch>"},
  {"/Buffer/Paste/tearoff", NULL, NULL, 0, "<Tearoff>"},
  
      {"/Buffer/Paste/Paste from buffer 1", NULL, i_callback_buffer_paste1,
   0, NULL},
  {"/Buffer/Paste/Paste from buffer 2", NULL, i_callback_buffer_paste2, 0,
   NULL},
  {"/Buffer/Paste/Paste from buffer 3", NULL, i_callback_buffer_paste3, 0,
   NULL},
  {"/Buffer/Paste/Paste from buffer 4", NULL, i_callback_buffer_paste4, 0,
   NULL},
  {"/Buffer/Paste/Paste from buffer 5", NULL, i_callback_buffer_paste5, 0,
   NULL},
  {"/View", NULL, NULL, 0, "<Branch>"},
  {"/View/tearoff", NULL, NULL, 0, "<Tearoff>"},
  {"/View/Redraw", NULL, i_callback_view_redraw, 0, NULL},
  {"/View/Pan", NULL, i_callback_view_pan, 0, NULL},
  {"/View/Zoom box", NULL, i_callback_view_zoom_box, 0, NULL},
  {"/View/Zoom extents", NULL, i_callback_view_zoom_extents, 0, NULL},
  {"/View/Zoom in", NULL, i_callback_view_zoom_in, 0, NULL},
  {"/View/Zoom out", NULL, i_callback_view_zoom_out, 0, NULL},
  {"/View/Zoom full", NULL, i_callback_view_zoom_full, 0, NULL},
  {"/View/Update Cues", NULL, i_callback_view_update_cues, 0, NULL},
  {"/Page", NULL, NULL, 0, "<Branch>"},
  {"/Page/tearoff", NULL, NULL, 0, "<Tearoff>"},
  {"/Page/Manager...", NULL, i_callback_page_manager, 0, NULL},
  {"/Page/Next", NULL, i_callback_page_next, 0, NULL},
  {"/Page/Prev", NULL, i_callback_page_prev, 0, NULL},
  {"/Page/Revert", NULL, i_callback_page_revert, 0, NULL},
  {"/Page/Close", NULL, i_callback_page_close, 0, NULL},
  {"/Page/Discard", NULL, i_callback_page_discard, 0, NULL},
  {"/Page/Print struct", NULL, i_callback_page_print, 0, NULL},

  {"/Add", NULL, NULL, 0, "<Branch>"},
  {"/Add/tearoff", NULL, NULL, 0, "<Tearoff>"},
  {"/Add/Component...", NULL, i_callback_add_component, 0, NULL},
  {"/Add/Net", NULL, i_callback_add_net, 0, NULL},
  {"/Add/Bus", NULL, i_callback_add_bus, 0, NULL},
  {"/Add/Attribute...", NULL, i_callback_add_attribute, 0, NULL},
  {"/Add/Text", NULL, i_callback_add_text, 0, NULL},
  {"/Add/sep1", NULL, NULL, 0, "<Separator>"},
  {"/Add/Line", NULL, i_callback_add_line, 0, NULL},
  {"/Add/Box", NULL, i_callback_add_box, 0, NULL},
  {"/Add/Circle", NULL, i_callback_add_circle, 0, NULL},
  {"/Add/Arc", NULL, i_callback_add_arc, 0, NULL},
  {"/Add/Pin", NULL, i_callback_add_pin, 0, NULL},
  {"/Hierarchy", NULL, NULL, 0, "<Branch>"},
  {"/Hierarchy/tearoff", NULL, NULL, 0, "<Tearoff>"},
  
      {"/Hierarchy/Down Schematic", NULL,
   i_callback_hierarchy_down_schematic, 0, NULL},
  {"/Hierarchy/Down Symbol", NULL, i_callback_hierarchy_down_symbol, 0,
   NULL},
  {"/Hierarchy/Up", NULL, i_callback_hierarchy_up, 0, NULL},
  {"/Attributes", NULL, NULL, 0, "<Branch>"},
  {"/Attributes/tearoff", NULL, NULL, 0, "<Tearoff>"},
  {"/Attributes/Attach", NULL, i_callback_attributes_attach, 0, NULL},
  {"/Attributes/Deattach", NULL, i_callback_attributes_detach, 0, NULL},
  
      {"/Attributes/Show Value", NULL, i_callback_attributes_show_value, 0,
   NULL},
  {"/Attributes/Show Name", NULL, i_callback_attributes_show_name, 0,
   NULL},
  {"/Attributes/Show Both", NULL, i_callback_attributes_show_both, 0,
   NULL},
  {"/Attributes/Toggle Vis", NULL, i_callback_attributes_visibility_toggle,
   0, NULL},
  {"/Options", NULL, NULL, 0, "<Branch>"},
  {"/Options/tearoff", NULL, NULL, 0, "<Tearoff>"},
  {"/Options/Text Size...", NULL, i_callback_options_text_size, 0, NULL},
  {"/Options/Toggle Grid", NULL, i_callback_options_grid, 0, NULL},
  {"/Options/Toggle Snap", NULL, i_callback_options_snap, 0, NULL},
  
      {"/Options/Snap Grid Spacing...", NULL, i_callback_options_snap_size,
   0, NULL},
  {"/Options/Toggle Outline", NULL, i_callback_options_afeedback, 0, NULL},
  
      {"/Options/Toggle Rubber band", NULL, i_callback_options_rubberband,
   0, NULL},
  {"/Options/Show Log Window", NULL, i_callback_options_show_log_window, 0,
   NULL},
  {"/Options/Show Coord Window", NULL,
   i_callback_options_show_coord_window, 0, NULL},
  {"/Help", NULL, NULL, 0, "<LastBranch>"},
  {"/Help/tearoff", NULL, NULL, 0, "<Tearoff>"},
  {"/Help/About...", NULL, i_callback_help_about, 0, NULL},
  {"/Help/Hotkeys...", NULL, i_callback_help_hotkeys, 0, NULL},
};

/* calculate the number of menu_item's */
/* no longer static */
int nmenu_items = sizeof(menu_items) / sizeof(menu_items[0]);
#endif

static GtkItemFactoryEntry popup_items[] = {
  {"/Net", NULL, i_callback_add_net, 0, NULL},
  {"/Attribute...", NULL, i_callback_add_attribute, 0, NULL},
  {"/Component...", NULL, i_callback_add_component, 0, NULL},
  {"/Bus", NULL, i_callback_add_bus, 0, NULL},
  {"/Text", NULL, i_callback_add_text, 0, NULL},
  {"/sep1", NULL, NULL, 0, "<Separator>"},
  {"/Zoom In", NULL, i_callback_view_zoom_in, 0, NULL},
  {"/Zoom Out", NULL, i_callback_view_zoom_out, 0, NULL},
  {"/Zoom Box", NULL, i_callback_view_zoom_box, 0, NULL},
  {"/Zoom Extents", NULL, i_callback_view_zoom_extents, 0, NULL},
  {"/sep1", NULL, NULL, 0, "<Separator>"},
  {"/Select", NULL, i_callback_edit_select, 0, NULL},
  {"/Edit...", NULL, i_callback_edit_edit, 0, NULL},
  {"/Copy", NULL, i_callback_edit_copy, 0, NULL},
  {"/Move", NULL, i_callback_edit_move, 0, NULL},
  {"/Delete", NULL, i_callback_edit_delete, 0, NULL},
};

int npopup_items = sizeof(popup_items) / sizeof(popup_items[0]);

void get_main_menuORIG(TOPLEVEL * w_current, GtkWidget ** menubar)
{
#if 0
  GtkItemFactory *item_factory;
  GtkAccelGroup *accel_group;

  accel_group = gtk_accel_group_new();
  /* This function initializes the item factory.
     Param 1: The type of menu - can be GTK_TYPE_MENU_BAR, GTK_TYPE_MENU,
     or GTK_TYPE_OPTION_MENU.
     Param 2: The path of the menu.
     Param 3: A pointer to a gtk_accel_group.  The item factory sets up
     the accelerator table while generating menus.
   */

  item_factory = gtk_item_factory_new(GTK_TYPE_MENU_BAR, "<main>",
				      accel_group);
  /* This function generates the menu items. Pass the item factory,
     the number of items in the array, the array itself, and any
     callback data for the the menu items. */
  gtk_item_factory_create_items(item_factory, nmenu_items, menu_items,
				w_current);

  /* Attach the new accelerator group to the window. */
  gtk_accel_group_attach(accel_group, GTK_OBJECT(w_current->main_window));

  if (menubar)
    /* Finally, return the actual menu bar created by the item factory. */
    *menubar = gtk_item_factory_get_widget(item_factory, "<main>");
#endif
}


static void g_menu_execute(char *func)
{
  char guile_string[128];

  sprintf(guile_string, "(%s)", func);
#if DEBUG
  printf("%s\n", guile_string);
#endif
  gh_eval_str(guile_string);
}


void get_main_menu(TOPLEVEL * w_current, GtkWidget ** menubar)
{
  char buf[128];
  GtkWidget *menu_item;
  GtkWidget *root_menu;
  GtkWidget *menu_bar;
  GtkWidget *menu;
#ifdef __CYGWIN32__
  GdkFont *font = NULL;
  GtkStyle *style;
#endif
  char **menu_name = malloc(sizeof(char *));
  int scm_items_len;
  SCM scm_items;
  SCM scm_item;
  SCM scm_item_name;
  SCM scm_item_func;
  SCM scm_item_hotkey_func;
  SCM scm_index;
  SCM scm_keys;
  char *menu_item_name;
  char *menu_item_func;
  char *menu_item_hotkey_func;
  char *menu_item_keys;
  char *spaces;
  int i, j;
  int name_len, key_len, pad;

  menu_bar = gtk_menu_bar_new();
  for (i = 0; i < s_menu_return_num(); i++) {

    scm_items = s_menu_return_entry(i, menu_name);
    if (*menu_name == NULL) {
      fprintf(stderr, "Oops.. got a NULL menu name in get_main_menu()\n");
      exit(-1);
    }

    menu = gtk_menu_new();

    menu_item = gtk_tearoff_menu_item_new();
    gtk_menu_append(GTK_MENU(menu), menu_item);
    gtk_widget_show(menu_item);

    scm_items_len = gh_length(scm_items);
    for (j = 0; j < scm_items_len; j++) {

      scm_index = gh_int2scm(j);
      scm_item = gh_list_ref(scm_items, scm_index);
      scm_item_name = gh_car(scm_item);
      scm_item_func = gh_cadr(scm_item);
      scm_item_hotkey_func = gh_caddr(scm_item);

      menu_item_name = gh_scm2newstr(scm_item_name, NULL);
      menu_item_func = gh_scm2newstr(scm_item_func, NULL);
      menu_item_hotkey_func = gh_scm2newstr(scm_item_hotkey_func, NULL);

      if (strcmp(menu_item_name, "SEPARATOR") == 0) {
	menu_item = gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(menu), menu_item);
      } else {
	sprintf(buf, "(find-key '%s)", menu_item_hotkey_func);
	scm_keys = gh_eval_str(buf);
	if (scm_keys == SCM_BOOL_F) {
	  menu_item_keys = malloc(sizeof(char) * 2);
	  menu_item_keys[0] = ' ';
	  menu_item_keys[1] = '\0';
	} else {
	  menu_item_keys = gh_scm2newstr(scm_keys, NULL);
	}

	name_len = strlen(menu_item_name);
	key_len = strlen(menu_item_keys);
	pad = 30 - (name_len + key_len);

	spaces = malloc(sizeof(char) * (pad + 1));
	memset(spaces, ' ', pad);
	spaces[pad] = '\0';
	sprintf(buf, "%s%s%s", menu_item_name, spaces, menu_item_keys);

#if DEBUG
	printf("%s :\n %d %d %d = %d\n", buf, name_len, pad, key_len,
	       name_len + pad + key_len);
#endif

	menu_item = gtk_menu_item_new_with_label(buf);
	gtk_menu_append(GTK_MENU(menu), menu_item);
	gtk_signal_connect_object(GTK_OBJECT(menu_item), "activate",
				  GTK_SIGNAL_FUNC(g_menu_execute),
				  (gpointer)
				  u_basic_strdup(menu_item_func));
	// The u_basic_strdup is a memory leak, but this is okay. I think.
	free(spaces);
	free(menu_item_keys);
      }

      gtk_widget_show(menu_item);

#ifdef __CYGWIN32__
      if (GTK_BIN(menu_item)->child) {
	GtkWidget *child = GTK_BIN(menu_item)->child;

	/* do stuff with child */
	if (GTK_IS_LABEL(child)) {
	  font =
	      gdk_font_load
	      ("-unknown-Courier New-normal-r-normal--17-127-96-96-m-0-iso8859-1");
	  if (!font) {
	    font =
		gdk_font_load
		("-unknown-Fixedsys-normal-r-normal--14-105-96-96-m-0-iso8859-1");
	  }

	  if (font) {
	    style = gtk_style_copy(gtk_widget_get_style(child));
	    gdk_font_unref(style->font);
	    style->font = font;
	    gdk_font_ref(style->font);
	    gtk_widget_set_style(child, style);
	  }
	}
      }
#endif

      free(menu_item_name);
      free(menu_item_func);
      free(menu_item_hotkey_func);

    }


    root_menu = gtk_menu_item_new_with_label(*menu_name);
    if (strcmp(*menu_name, "Help") == 0) {
      gtk_menu_item_right_justify(GTK_MENU_ITEM(root_menu));
    }
    gtk_widget_show(root_menu);
    gtk_menu_item_set_submenu(GTK_MENU_ITEM(root_menu), menu);
    gtk_menu_bar_append(GTK_MENU_BAR(menu_bar), root_menu);
  }

  free(menu_name);
  *menubar = menu_bar;
}

void get_main_popup(TOPLEVEL * w_current, GtkWidget ** menu)
{
  GtkItemFactory *item_factory;
  GtkAccelGroup *accel_group;

  accel_group = gtk_accel_group_new();
  /* This function initializes the item factory.
     Param 1: The type of menu - can be GTK_TYPE_MENU_BAR, GTK_TYPE_MENU,
     or GTK_TYPE_OPTION_MENU.
     Param 2: The path of the menu.
     Param 3: A pointer to a gtk_accel_group.  The item factory sets up
     the accelerator table while generating menus.
   */

  item_factory = gtk_item_factory_new(GTK_TYPE_MENU, "<popup>",
				      accel_group);
  /* This function generates the menu items. Pass the item factory,
     the number of items in the array, the array itself, and any
     callback data for the the menu items. */
  gtk_item_factory_create_items(item_factory, npopup_items, popup_items,
				w_current);

  /* Attach the new accelerator group to the window. */
  gtk_accel_group_attach(accel_group, GTK_OBJECT(w_current->main_window));

  if (menu)
    /* Finally, return the actual menu bar created by the item factory. */
    *menu = gtk_item_factory_get_widget(item_factory, "<popup>");
}


/* need to look at this... here and the setup */
gint do_popup(TOPLEVEL * w_current, GdkEventButton * event)
{
  GtkWidget *menu = NULL;	/* was static */

  if (!menu)
    menu = w_current->popup_menu;

  if (menu == NULL) {
    printf("null menu\n");
  }

  gtk_menu_popup(GTK_MENU(menu), NULL, NULL, NULL, NULL,
		 event->button, event->time);

  return FALSE;
}
