#  callback.rb - 
#  Copyright (C) 2004-2006 Frédéric Logier

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.



module Geekast
  module Controller

    class CallbackMain
      include GetText

      def initialize
        @url = nil
        bindtextdomain(Geekast::TEXTDOMAIN, nil, nil, "UTF-8")
        handlerError
        refreshNB
        refreshYP
        xmlParse
        refreshRelay
        notifyBAR
        refreshBM
        bookmarkAdd
        bookmarkDel
        refreshConnection
        refreshInformation
        getChannelinfo
        returnChannelinfo
        refreshWeb
      end

      #######
      private
      #######

      def refreshNB
        @SrefreshNB = SIGNAL.connect("CrefreshNB") {|num_page|
          flag = 0
          puts "CrefreshNB" if $DEBUG
          SIGNAL.handler_block(@SrefreshNB)

          case num_page
          when Config::INFORMATION
            connectionParam = {
              "NUMPAGE" => num_page,
              "IP" => Config::PEERCAST_IP,
              "PORT" => Config::PEERCAST_PORT,
              "URL" => Config::PEERCAST_INFORMATION,
              "ATTRIBUT" => "",
              "SIGNAL" => "CrefreshInformation" 
            }
          when Config::RELAY
            connectionParam = {
              "NUMPAGE" => num_page,
              "IP" => Config::PEERCAST_IP,
              "PORT" => Config::PEERCAST_PORT,
              "URL" => Config::PEERCAST_STATS,
              "ATTRIBUT" => "channels_relayed",
              "SIGNAL" => "CrefreshRelay"
            }
          when Config::CONNECTION
            connectionParam = {
              "NUMPAGE" => num_page,
              "IP" => Config::PEERCAST_IP,
              "PORT" => Config::PEERCAST_PORT,
              "URL" => Config::PEERCAST_CONNECTIONS,
              "ATTRIBUT" => "",
              "SIGNAL" => "CrefreshConnection"
            }
          when Config::YP
            connectionParam = {
              "NUMPAGE" => num_page,
              "IP" => Config::YELLOWPAGES_IP,
              "PORT" => Config::YELLOWPAGES_PORT,
              "URL" => Config::YELLOWPAGES_URL,
              "ATTRIBUT" => "channels_found",
              "SIGNAL" => "CrefreshYP" 
            }
          when Config::BOOKMARK
            connectionParam = {
              "NUMPAGE" => num_page,
              "IP" => "bookmark",
              "SIGNAL" => "CrefreshBM"
            }
          when Config::VIDEO
            connectionParam = {
              "NUMPAGE" => num_page,
              "IP" => Config::PEERCAST_IP,
              "PORT" => Config::PEERCAST_PORT,
              "URL" => Config::PEERCAST_CONNECTIONS,
              "ATTRIBUT" => "",
              "SIGNAL" => ""
            }
          when Config::WEB
            SIGNAL.emit("VrefreshWeb", @url)
            flag = 1
          end

          if flag != 1
            # clear treeview
            SIGNAL.emit("VclearTreeview", num_page)

            # notify bar
            SIGNAL.emit("VnotifyBAR", _("connecting to ") + connectionParam["IP"])

            #refresh model
            SIGNAL.emit("MrefreshNB", connectionParam)
          end
          SIGNAL.handler_unblock(@SrefreshNB)
        }

      end

         
      def handlerError
        @flag = false

        SIGNAL.connect("ChandlerError") {|env, msg|
          puts "ChandlerError" if $DEBUG

          case env
          when "httpConnect"
            if msg == "true" && @flag == true
              SIGNAL.emit("VunblockSignal", "VnotifyBAR")
              @flag = false
            elsif msg != "true"
              SIGNAL.emit("VnotifyBAR", msg)
              SIGNAL.emit("VblockSignal", "VnotifyBAR")
              @flag = true
            end
          end
        }
      end


      def refreshBM
        SIGNAL.connect("CrefreshBM") {|data|
          puts "CrefreshBM" if $DEBUG
          SIGNAL.emit("VrefreshBM", data)
        }
      end


      def refreshYP
        SIGNAL.connect("CrefreshYP") {|data1,data2,data3|
          puts "CrefreshYP" if $DEBUG
          SIGNAL.emit("VrefreshBAR", -1, data2, data3)
          SIGNAL.emit("VrefreshYP", data1,data2,data3)
        }
      end

      def refreshRelay
        SIGNAL.connect("CrefreshRelay") {|data1,data2,data3|
          puts "CrefreshRelay" if $DEBUG
          SIGNAL.emit("VrefreshBAR", -1, data2, data3)
          SIGNAL.emit("VrefreshRelay", data1,data2,data3)
        }
      end

      def refreshConnection
        SIGNAL.connect("CrefreshConnection") {|data|
          puts "CrefreshConnection" if $DEBUG
          SIGNAL.emit("VrefreshBAR", -1, 0, 0)
          SIGNAL.emit("VrefreshConnection", data)
        }
      end

      def refreshInformation
        SIGNAL.connect("CrefreshInformation") {|data1, data2, data3, data4|
          puts "CrefreshInformation" if $DEBUG
          SIGNAL.emit("VrefreshBAR", -1, 0, 0)
          SIGNAL.emit("VrefreshInformation", data1, data2, data3, data4)
        }
      end


      def notifyBAR
        SIGNAL.connect("CnotifyBAR") {|data1, data2|
          puts "CnotifyBAR" if $DEBUG
          SIGNAL.emit("VnotifyBAR", data1)
        }
      end


      def xmlParse
        SIGNAL.connect("CxmlParse") {|data|
          puts "CxmlParse" if $DEBUG
          SIGNAL.emit("VrefreshBAR", data, 0, 0)
        }
      end


      def bookmarkAdd
        SIGNAL.connect("CbookmarkAdd") {|data|
          puts "CbookmarkAdd" if $DEBUG
          SIGNAL.emit("MbookmarkAdd", data)
        }
      end

      def bookmarkDel
        SIGNAL.connect("CbookmarkDel") {|data|
          puts "CbookmarkDel" if $DEBUG
          SIGNAL.emit("MbookmarkDel", 0)
        }
      end


      def getChannelinfo
        SIGNAL.connect("CgetChannelinfo") {|data|
          puts "CgetChannelinfo" if $DEBUG
          
          connectionParam = {
            "NUMPAGE" => Config::CHANINFO,
            "IP" => Config::PEERCAST_IP,
            "PORT" => Config::PEERCAST_PORT,
            "URL" => data,
            "ATTRIBUT" => "",
            "SIGNAL" => "CreturnChannelinfo" 
          }
          SIGNAL.emit("MrefreshNB", connectionParam)
        }
      end


      def returnChannelinfo
        SIGNAL.connect("CreturnChannelinfo") {|data|
          puts "CreturnChannelinfo" if $DEBUG          
          SIGNAL.emit("VrefreshChannelInfo", data)
        }
      end

      def refreshWeb
        SIGNAL.connect("CrefreshWeb") {|data|
          @url = data
          SIGNAL.emit("VrefreshWeb", data)
        }
      end
      
      
    end
    
  end
end
