// genesis

/*
** $Log: synutils2_test.g,v $
** Revision 1.2  1995/03/27 20:49:28  mvanier
** Cosmetic changes.
**
# Revision 1.1  1995/03/27  20:42:03  mvanier
# Initial revision
*/

// This is a test script for the synaptic utilities in GENESIS.
// This script uses synchan2's instead of synchans, mostly.

create randomspike /pre
create synchan2    /post
create randomspike /pre2
create synchan2    /post2 
create hebbsynchan /post3
create compartment /compt

addmsg /compt /pre   RATE Vm
addmsg /pre   /compt INJECT rate
addmsg /post  /compt INJECT activation
addmsg /compt /post  VOLTAGE Vm 

addmsg /pre  /post  SPIKE
addmsg /pre2 /post  SPIKE 
addmsg /pre  /post  SPIKE 
addmsg /pre  /post  SPIKE 
addmsg /pre2 /post  SPIKE
addmsg /pre  /post2 SPIKE
addmsg /pre2 /post2 SPIKE 


function syncounttest
  echo synapses from /pre: {getsyncount /pre}   [should be 4]
  echo synapses from /pre2: {getsyncount /pre2} [should be 3]
  echo synapses to /post: {getsyncount /post}   [should be 5]
  echo synapses to /post2: {getsyncount /post2} [should be 2]
  echo synapses to /post3: {getsyncount /post3} [should be 0]
  echo synapses between /pre and /post: {getsyncount /pre /post}     [should be 3]
  echo synapses between /pre and /post2: {getsyncount /pre /post2}   [should be 1]
  echo synapses between /pre and /post3: {getsyncount /pre /post3}   [should be 0]
  echo synapses between /pre2 and /post: {getsyncount /pre2 /post}   [should be 2]
  echo synapses between /pre2 and /post2: {getsyncount /pre2 /post2} [should be 1]
  echo synapses between /pre2 and /post3: {getsyncount /pre2 /post3} [should be 0]
end


function synindextest
  echo messages from/to /pre:
  showmsg /pre
  echo messages from/to /post:
  showmsg /post
  echo indexes of synapses between /pre and /post:
  echo index of 0th synapse: {getsynindex /pre /post}         [should be 0]
  echo index of 0th synapse: {getsynindex /pre /post -num 0}  [should be 0]
  echo index of 1st synapse: {getsynindex /pre /post -num 1}  [should be 2]
  echo index of 2nd synapse: {getsynindex /pre /post -num 2}  [should be 3]
  echo index of 3rd synapse: {getsynindex /pre /post -num 3}  [should be -1, after an error message]
end


function synsrctest
  echo source of 0th synapse of /post = {getsynsrc /post 0} [should be /pre]
  echo source of 1st synapse of /post = {getsynsrc /post 1} [should be /pre2]
  echo source of 2nd synapse of /post = {getsynsrc /post 2} [should be /pre]
  echo source of 3rd synapse of /post = {getsynsrc /post 3} [should be /pre]
  echo source of 4th synapse of /post = {getsynsrc /post 4} [should be /pre2]
end


function syndesttest
  echo dest of 0th SPIKE message of /pre = {getsyndest /pre 0} [should be /post]
  echo index = {getsyndest /pre 0 -index} [should be 0]
  echo dest of 1st SPIKE message of /pre = {getsyndest /pre 1} [should be /post]
  echo index = {getsyndest /pre 1 -index} [should be 2]
  echo dest of 2nd SPIKE message of /pre = {getsyndest /pre 2} [should be /post]
  echo index = {getsyndest /pre 2 -index} [should be 3]
  echo dest of 3rd SPIKE message of /pre = {getsyndest /pre 3} [should be /post2]
  echo index = {getsyndest /pre 3 -index} [should be 0]
end



echo ------------------------------------------------------------
echo Testing synaptic utilities for synchan2...
echo ------------------------------------------------------------
echo
echo Testing getsyncount...
echo
syncounttest
echo
echo Testing getsynindex...
echo
synindextest
echo
echo Testing getsynsrc...
echo
synsrctest
echo
echo Testing getsyndest...
echo
syndesttest
echo
 
quit


