static char rcsid[] = "$Id: shell_status.c,v 1.1 1992/12/11 19:04:46 dhb Exp $";

/*
** $Log: shell_status.c,v $
** Revision 1.1  1992/12/11 19:04:46  dhb
** Initial revision
**
*/

#include "shell_ext.h"
#include <time.h>

static struct tm start_tmval;

RecordStartTime()
{
long clock;

    time(&clock);
    bcopy(localtime(&clock),&start_tmval,sizeof(struct tm));
}

ProcessStatus()
{
double stime,utime;
int umin,smin;
float usec,ssec;
char string[200];
long clock;
struct tm tmval;
int totalsec;
int esec,emin,ehour,eday;
int asec,amin;

    rtd(&utime,&stime);
    umin = utime/60;
    usec = utime - umin*60;
    smin = stime/60;
    ssec = stime - smin*60;

    time(&clock);
    bcopy(localtime(&clock),&tmval,sizeof(struct tm));
    esec = tmval.tm_sec - start_tmval.tm_sec;
    emin = tmval.tm_min - start_tmval.tm_min;
    ehour = tmval.tm_hour - start_tmval.tm_hour;
    eday = tmval.tm_mday - start_tmval.tm_mday;
    if(eday < 0) eday = 1;

    totalsec = esec + emin*60 + ehour*3600 + eday*86400;
    amin = totalsec/60;
    asec = totalsec - amin*60;


    sprintf(string,
"process status:  %d:%-05.2f user  %d:%-05.2f sys   %d:%02d real  %6.2f Mbytes",
    umin, usec,
    smin,ssec,
    amin,asec,
    memusage()/1.0e6);
    if(!StatusMessage(string,0,1)){
	printf("\n%s\n",string);
    }
}

