#include "parser.h"
#include "printer.h"
#include "polynomial.h"
#include "division.h"
#include "buchberger.h"
#include "wallideal.h"
#include "lp.h"
#include "reversesearch.h"
#include "termorder.h"
#include "ep_standard.h"
#include "ep_xfig.h"
#include "gfanapplication.h"

class GroupFacetBinomialsApplication : public GFanApplication
{
  SimpleOption optionLexicographic;
  SimpleOption optionReadTwoSets;
  SimpleOption optionNotOnlyFacets;
  FieldOption theFieldOption;
public:
  bool includeInDefaultInstallation()
  {
    return false;
  }
  const char *helpText()
  {
    return "This program takes a list of reduced Groebner bases for a binomial ideal and outputs the facet binomials grouped by hyperplane\n";
  }
  GroupFacetBinomialsApplication():
    optionNotOnlyFacets("-a","group all binomials - not only facets\n"),
    optionLexicographic("-l","order output polynomials with respect to lexicographic order\n"),
    optionReadTwoSets("-2","read two polynomial lists instead of one\n")
  {
    registerOptions();
  }

  char *name()
  {
    return "_groupfacetbinomials";
  }

  IntegerVector getVector(const Polynomial &p)
  {
    IntegerVector markedExponent=p.getMarked().m.exponent;
    
    for(TermMap::const_iterator i=p.terms.begin();i!=p.terms.end();i++)
      {
	IntegerVector dif=markedExponent-i->first.exponent;
	if(!dif.isZero())return dif;
      }
    assert(0);
    return markedExponent;
  }

  bool dependencyCheck(const Polynomial &p, const Polynomial &q)
  {
    return dependent(getVector(p),getVector(q));
  }

  IntegerVectorList extremeRays(IntegerVectorList const &normals)
  {
    IntegerVectorList extreme;
    for(IntegerVectorList::const_iterator i=normals.begin();i!=normals.end();i++)
      {
	if(isFacet(normals,i))extreme.push_back(*i);
      }
    return extreme;
  }
  void process(FileParser &P, PolynomialSetList &s)
  {
    PolynomialSetList l=P.parsePolynomialSetListWithRing();
    for(PolynomialSetList::const_iterator i=l.begin();i!=l.end();i++)
      {
	IntegerVectorList normals=wallInequalities(*i);
	IntegerVectorList extreme=extremeRays(normals);
	if(optionNotOnlyFacets.getValue())extreme=normals;
	for(PolynomialSet::const_iterator j=i->begin();j!=i->end();j++)
	  {
	    IntegerVectorList::const_iterator m;
	    for(m=extreme.begin();m!=extreme.end();m++)
	      if(dependent(getVector(*j),*m))break;
	    Polynomial dummy=*j;
	    if(optionLexicographic.getValue())
	      {
		dummy.mark(LexicographicTermOrder());
		dummy.scaleMarkedCoefficientToOne();
	      }
	    if(m!=extreme.end())
	      {
		PolynomialSetList::iterator k;
		for(k=s.begin();k!=s.end();k++)
		  if(dependencyCheck(*(k->begin()),dummy))break;
		if(k==s.end())
		  {
		    PolynomialSet q(j->getRing());
		    q.unionPolynomial(dummy);
		    s.push_back(q);
		  }
		else
		  {
		    k->unionPolynomial(dummy);
		  }
	      }
	  }
      }
  }
  
  int main()
  {
    FileParser P(Stdin);
    PolynomialSetList s;
  
    process(P,s);
    if(optionReadTwoSets.getValue())process(P,s);

    AsciiPrinter(Stdout).printPolynomialSetList(s);
    
    return 0;
  }
};

static GroupFacetBinomialsApplication theApplication;
