#ifndef BUCHBERGER_H_INCLUDED
#define BUCHBERGER_H_INCLUDED

#include "polynomial.h"

Polynomial sPolynomial(Polynomial a, Polynomial b);
void buchberger(PolynomialSet *g, TermOrder const &termOrder);
void minimize(PolynomialSet *g);
void autoReduce(PolynomialSet *g, TermOrder const &termOrder);
bool isMarkedGroebnerBasis(PolynomialSet const &g);

/* For the autoReduction procedure the TermOrder argument is only used as an
argument for the division algorithm. This means that the input to autoReduce
should be marked and that the term order does not have to agree.
*/

#endif
