#include "symmetry.h"

#include "printer.h"

IntegerVector SymmetryGroup::identity(int n)
{
  IntegerVector v(n);
  for(int i=0;i<n;i++)v[i]=i;

  return v;
}


IntegerVector SymmetryGroup::inverse(IntegerVector const &a)
{
  return composeInverse(a,identity(a.size()));
}


SymmetryGroup::SymmetryGroup(int n)
{
  elements.insert(identity(n));
}


int SymmetryGroup::sizeOfBaseSet()
{
  assert(!elements.empty());
  return elements.begin()->size();
}

void SymmetryGroup::computeClosure(IntegerVector const &v) //does this work??
{  
  ElementContainer newOnes;

  newOnes.insert(v);

  while(!newOnes.empty())
    {
      static int i;
      i++;
      if((i&127)==0)fprintf(Stderr,"%i\n",i);


      IntegerVector v=*newOnes.begin();
      for(ElementContainer::const_iterator i=elements.begin();i!=elements.end();i++)
	{
	  {
	    IntegerVector n(compose(*i,v));
	    if(0==elements.count(n))
	      newOnes.insert(n);
	  }
	  {
	    IntegerVector n(compose(v,*i));
	    if(0==elements.count(n))
	      newOnes.insert(n);
	  }
	}
      newOnes.erase(v);
      elements.insert(v);
    }
}


void SymmetryGroup::computeClosure(IntegerVectorList const &l)
{
  //  for(IntegerVectorList::const_iterator i=l.begin();i!=l.end();i++)
  //  computeClosure(*i);

  bool growing=true;
  while(growing)
    {
      growing=false;
      for(ElementContainer::const_iterator i=elements.begin();i!=elements.end();i++)
	{
	  for(IntegerVectorList::const_iterator j=l.begin();j!=l.end();j++)
	    {
	      {
		IntegerVector n(compose(*i,*j));
		growing|=(0==elements.count(n));
		elements.insert(n);
	      }
	      {
		IntegerVector n(compose(*i,*j));
		growing|=(0==elements.count(n));
		elements.insert(n);
	      }
	    }
	}
    }
}


void SymmetryGroup::print(FILE *f)
{
  AsciiPrinter P(f);
  P.printString("Printing SymmetryGroup\n");
  IntegerVectorList l;
  for(ElementContainer::const_iterator i=elements.begin();i!=elements.end();i++)
    {
      //      P.printVector(*i);
      //      P.printNewLine();
      l.push_back(*i);
    }
  P.printVectorList(l);
  fprintf(f,"Group order=%i\n",elements.size());
  P.printString("Done printing SymmetryGroup.\n");
}


IntegerVector SymmetryGroup::compose(IntegerVector const &a, IntegerVector const &b)
{
  IntegerVector v(a);
  assert(a.size()==b.size());
  for(int i=0;i<a.size();i++)v[i]=b[a[i]];
  return v;
}


IntegerVector SymmetryGroup::composeInverse(IntegerVector const &a, IntegerVector const &b)
{
  IntegerVector v(a);
  assert(a.size()==b.size());
  for(int i=0;i<a.size();i++)v[a[i]]=b[i];
  return v;
}


IntegerVectorList SymmetryGroup::permuteIntegerVectorList(IntegerVectorList const &l, IntegerVector const &v)
{
  IntegerVectorList ret;
  for(IntegerVectorList::const_iterator i=l.begin();i!=l.end();i++)
    ret.push_back(compose(v,*i));

  return ret;
}


Polynomial SymmetryGroup::permutePolynomial(Polynomial const &p, IntegerVector const &v)
{
  Polynomial q(p.getRing());

  for(TermMap::const_iterator i=p.terms.begin();i!=p.terms.end();i++)
    {
      q+=Term(i->second,Monomial(p.getRing(),compose(v,i->first.exponent)));
    }

  q.mark(Monomial(p.getRing(),compose(v,p.getMarked().m.exponent)));

  return q;
}


PolynomialSet SymmetryGroup::permutePolynomialSet(PolynomialSet const &s, IntegerVector const &v)
{
  PolynomialRing theRing=s.getRing();
  PolynomialSet ret(theRing);
  for(PolynomialSet::const_iterator i=s.begin();i!=s.end();i++)
    {
      ret.push_back(permutePolynomial(*i,v));
    }

  return ret;
}


Polynomial SymmetryGroup::computeUniqueRepresentative(Polynomial p)
{
  Polynomial best=p;

  for(ElementContainer::const_iterator i=elements.begin();i!=elements.end();i++)
    {
      Polynomial q=permutePolynomial(p,*i);
      if(PolynomialCompare()(best,q))best=q;
    }
  return best;
}
