/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2003-2004 The GFC Development Team.
 *
 *  cellrenderer.inl - Gtk::CellRenderer inline functions
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

inline GtkCellRenderer*
GFC::Gtk::CellRenderer::gtk_cell_renderer() const
{
	return reinterpret_cast<GtkCellRenderer*>(instance_);
}

inline GFC::Gtk::CellRenderer::operator GtkCellRenderer* () const
{
	return this ? gtk_cell_renderer() : 0;
}

inline void
GFC::Gtk::CellRenderer::get_fixed_size(int *width, int *height) const
{
	gtk_cell_renderer_get_fixed_size(gtk_cell_renderer(), width, height);
}

inline void 
GFC::Gtk::CellRenderer::editing_canceled()
{
	gtk_cell_renderer_editing_canceled(gtk_cell_renderer());
}

inline void
GFC::Gtk::CellRenderer::set_fixed_size(int width, int height)
{
	gtk_cell_renderer_set_fixed_size(gtk_cell_renderer(), width, height);
}

inline const GFC::Gtk::CellRenderer::ModePropertyProxy
GFC::Gtk::CellRenderer::prop_mode()
{
	return ModePropertyProxy(this, &mode_property);
}

inline const GFC::Gtk::CellRenderer::VisiblePropertyProxy
GFC::Gtk::CellRenderer::prop_visible()
{
	return VisiblePropertyProxy(this, &visible_property);
}

inline const GFC::Gtk::CellRenderer::XAlignPropertyProxy
GFC::Gtk::CellRenderer::prop_xalign()
{
	return XAlignPropertyProxy(this, &xalign_property);
}

inline const GFC::Gtk::CellRenderer::YAlignPropertyProxy
GFC::Gtk::CellRenderer::prop_yalign()
{
	return YAlignPropertyProxy(this, &yalign_property);
}

inline const GFC::Gtk::CellRenderer::XPadPropertyProxy
GFC::Gtk::CellRenderer::prop_xpad()
{
	return XPadPropertyProxy(this, &xpad_property);
}

inline const GFC::Gtk::CellRenderer::YPadPropertyProxy
GFC::Gtk::CellRenderer::prop_ypad()
{
	return YPadPropertyProxy(this, &ypad_property);
}

inline const GFC::Gtk::CellRenderer::WidthPropertyProxy
GFC::Gtk::CellRenderer::prop_width()
{
	return WidthPropertyProxy(this, &width_property);
}

inline const GFC::Gtk::CellRenderer::HeightPropertyProxy
GFC::Gtk::CellRenderer::prop_height()
{
	return HeightPropertyProxy(this, &height_property);
}

inline const GFC::Gtk::CellRenderer::IsExpanderPropertyProxy
GFC::Gtk::CellRenderer::prop_is_expander()
{
	return IsExpanderPropertyProxy(this, &is_expander_property);
}

inline const GFC::Gtk::CellRenderer::IsExpandedPropertyProxy
GFC::Gtk::CellRenderer::prop_is_expanded()
{
	return IsExpandedPropertyProxy(this, &is_expanded_property);
}

inline const GFC::Gtk::CellRenderer::CellBackgroundPropertyProxy
GFC::Gtk::CellRenderer::prop_cell_background()
{
	return CellBackgroundPropertyProxy(this, &cell_background_property);
}

inline const GFC::Gtk::CellRenderer::CellBackgroundGdkPropertyProxy
GFC::Gtk::CellRenderer::prop_cell_background_gdk()
{
	return CellBackgroundGdkPropertyProxy(this, &cell_background_gdk_property);
}

inline const GFC::Gtk::CellRenderer::CellBackgroundSetPropertyProxy
GFC::Gtk::CellRenderer::prop_cell_background_set()
{
	return CellBackgroundSetPropertyProxy(this, &cell_background_set_property);
}

inline const GFC::Gtk::CellRenderer::EditingCanceledSignalProxy 
GFC::Gtk::CellRenderer::sig_editing_canceled()
{
	return EditingCanceledSignalProxy(this, &editing_canceled_signal);
}

