/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  togglebutton.cc - GtkToggleButton C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "togglebutton.hh"
#include "private/togglebuttonclass.hh"
#include "private/marshal.hh"

using namespace GFC;

/*  Gtk::ToggleButton
 */

Gtk::ToggleButton::ToggleButton(GtkToggleButton *toggle_button, bool owns_reference)
: Button((GtkButton*)toggle_button, owns_reference)
{
}

Gtk::ToggleButton::ToggleButton() 
: Button((GtkButton*)ToggleButtonClass::create())
{
}

Gtk::ToggleButton::ToggleButton(const String& label, bool use_underline)
: Button((GtkButton*)ToggleButtonClass::create())
{
	set_label(label);
	set_use_underline(use_underline);
}

Gtk::ToggleButton::~ToggleButton()
{
}

/*  Gtk::ToggleButton signals
 */

const Gtk::ToggleButton::ToggledSignalType Gtk::ToggleButton::toggled_signal("toggled", (GCallback)&G::Marshal::void_callback);

