/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <gconf/gconf-client.h>

#include "interface.h"
#include "callbacks.h"
#include "support.h"
#include "chat.h"

#include <ggzcore.h>
#include <ggz.h>

GtkWidget *interface;
GConfClient *config;

#define DEBUG TRUE

void init_debug(void);

int
main (int argc, char *argv[])
{
	GGZOptions opt;
	gchar *global_conf, *user_conf, *themedir;

#ifdef ENABLE_NLS
	bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
	textdomain (PACKAGE);
#endif

	/*
	gnome_program_init(PACKAGE, VERSION, LIBGNOMEUI_MODULE, argc, argv, 
			GNOME_PARAM_POPT_TABLE, options, 
			GNOME_PROGRAM_STANDARD_PROPERTIES, NULL);
	  */
	
	/* Gnome initilization */
	gnome_init ("ggz", VERSION, argc, argv);
	config = gconf_client_get_default ();
	gconf_client_add_dir (config, "/apps/ggz-gnome", GCONF_CLIENT_PRELOAD_NONE, NULL);

	/*global_conf = "/etc/ggz/ggz.conf";*/
	/* We don't support this quite yet */
	global_conf = NULL;
	user_conf = g_strdup_printf("%s/.ggz/ggz-gnome.rc", getenv("HOME"));
	ggzcore_conf_initialize(global_conf, user_conf);
	g_free(user_conf);

	opt.flags = GGZ_OPT_PARSER | GGZ_OPT_MODULES;
	
	ggzcore_init(opt);
	chat_init();

#ifdef DEBUG
	init_debug();
#endif

	/* Setup where the graphics should be loaded from */
	themedir = g_strdup_printf("%s/ggz-gnome/Default", GGZDATADIR);
	add_pixmap_directory (themedir); /* installed directory */
	add_pixmap_directory ("../pixmaps/Default");

	interface = create_login();
	gtk_widget_show(interface);

	gtk_timeout_add(40, on_pmStar_timeout, NULL);
	
	gtk_main();

	ggzcore_destroy();
#ifdef DEBUG
	ggz_debug_cleanup(GGZ_CHECK_MEM);
#endif	

	g_object_unref (G_OBJECT (config));
	
	return 0;
}

void init_debug(void)
{
	gchar *default_file, *debug_file, **debug_types;
	gint num_types, i;

	/* Inititialze debugging */
	default_file = g_strjoin("/", getenv("HOME"), ".ggz/ggz-gnome.debug", NULL);
	debug_file = ggzcore_conf_read_string("Debug", "FILE", default_file);
	g_free(default_file);

	ggzcore_conf_read_list("Debug", "Types", &num_types, (char***)&debug_types);
	

	ggz_debug_init((const char**)debug_types, debug_file);

	/* Free up memory */
	for (i = 0; i < num_types; i++)
		ggz_free(debug_types[i]);
	ggz_free(debug_types);
	ggz_free(debug_file);
}
