with System;
with Ortho_Gcc_Front;
with Agcc.Toplev;
with Ada.Command_Line; use Ada.Command_Line;

procedure Ortho_Gcc.Main
is
   gnat_argc : Integer;
   gnat_argv : System.Address;
   gnat_envp : System.Address;

   pragma Import (C, gnat_argc);
   pragma Import (C, gnat_argv);
   pragma Import (C, gnat_envp);

   Status : Exit_Status;
begin
   Ortho_Gcc_Front.Init;

   --  Note: GCC set signal handlers...
   Status := Exit_Status (Agcc.Toplev.Toplev_Main (gnat_argc, gnat_argv));
   Set_Exit_Status (Status);
exception
   when others =>
      Set_Exit_Status (2);
      return;
end Ortho_Gcc.Main;
