// MM2RBN.CPP

// Copyright (C) 1998 Tommi Hassinen, Jarno Huuskonen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "mm2rbn.h"	// config.h is here -> we get ENABLE-macros here...

#ifdef ENABLE_GRAPHICS
#include "mm2docv.h"
#include "spline.h"

/*################################################################################################*/

// will not work if there is less than 2 residues !!!!!!!!!!!!!!!!!!!!!!!
// will not work if there is less than 2 residues !!!!!!!!!!!!!!!!!!!!!!!
// will not work if there is less than 2 residues !!!!!!!!!!!!!!!!!!!!!!!

const i32s mm2_ribbon::resol1 = 5;		// montako vlipistett...
const i32s mm2_ribbon::resol2 = 5;		// montako pistett ympyrss...

const fGL mm2_ribbon::radius = 0.075;

mm2_ribbon::mm2_ribbon(mm2_docv * p1, color_mode * p9, i32s p2, i32s order) : smart_object()
{
	docv = p1; cmode = p9;
	chn = p2; extra_points = order - 2;
	
	length = docv->chn_vector[chn].res_vector.size();
	ref = new spline(order, length + extra_points * 2);
	
	head_points = new fGL_a3[extra_points];
	tail_points = new fGL_a3[extra_points];
	
	for (i32s n1 = 0;n1 < 3;n1++)		// copy the coordinateds...
	{
		head_refs[0][n1] = docv->chn_vector[chn].res_vector[1].crd_vector[0].front().data[n1];		// begin
		head_refs[1][n1] = docv->chn_vector[chn].res_vector[0].crd_vector[0].front().data[n1];		// end
		
		tail_refs[0][n1] = docv->chn_vector[chn].res_vector[length - 2].crd_vector[0].front().data[n1];		// begin
		tail_refs[1][n1] = docv->chn_vector[chn].res_vector[length - 1].crd_vector[0].front().data[n1];		// end
	}
	
	UpdateExtraPoints();
	
	for (i32s n1 = 0;n1 < extra_points;n1++)
	{
		ref->SetPoint(n1, & head_points[extra_points - (n1 + 1)]);
	}
	
	for (i32s n1 = 0;n1 < extra_points;n1++)
	{
		ref->SetPoint(extra_points + length + n1, & tail_points[n1]);
	}
	
	for (i32s n1 = 0;n1 < length;n1++)
	{
		ref->SetPoint(extra_points + n1, & docv->chn_vector[chn].res_vector[n1].crd_vector[0].front().data);
	}
	
	for (i32s n1 = 0;n1 < length + extra_points * 2 + ref->GetOrder();n1++)
	{
		ref->SetKnot(n1, (fGL) (n1 - extra_points) - (fGL) ref->GetOrder() / 2.0);
	}
	
	list_id = docv->GetDisplayListIDs(1);
	
	MakeRibbon();
}

mm2_ribbon::~mm2_ribbon(void)
{
	delete ref;
	delete[] head_points;
	delete[] tail_points;
	
	delete[] data1;
	delete[] data2;
	delete[] data3;
	delete[] data4;
	delete[] data5;
	
	docv->DeleteDisplayLists(list_id, 1);
}

void mm2_ribbon::MakeRibbon(void)
{
	i32s np1 = resol1 * (length - 1);
	i32s np2 = np1 + 1;
	
	data1 = new fGL[np2];
	data2 = new fGL_a3[np2];
	
	for (i32s n1 = 0;n1 < np2;n1++)
	{
		data1[n1] = ((fGL) (length - 1) * n1) / (fGL) np1;
		ref->Compute(data1[n1], data2[n1]);
	}
	
	data5 = new fGL_a4[length];
	for (i32s n1 = 0;n1 < length;n1++)
	{
		mm2_cdata cdata;
		cdata.res = & docv->chn_vector[chn].res_vector[n1];
		cdata.index = 0;
		
		cmode->GetColor(& cdata, data5[n1]);
	}
	
	// calculate and store begin- and end-points, and y-directions for all cylinder-
	// shaped segments of the ribbon. because these segments overlap somewhat (large
	// curving of the spline means more overlap) we have to draw them somewhat longer
	// and therefore end-point of previous segment != begin-point of the next one.
	
	data3 = new fGL_a3[np1 * 2];
	data4 = new fGL_a3[np1];
	
	v3d<fGL> xdir = v3d<fGL>(1.0, 0.0, 0.0);
	
	for (i32s n1 = 0;n1 < np1;n1++)
	{
		for (i32s n2 = 0;n2 < 3;n2++)
		{
			data3[n1 * 2 + 0][n2] = data2[n1 + 0][n2];
			data3[n1 * 2 + 1][n2] = data2[n1 + 1][n2];
		}
		
		// calculate extension for the begin-point...
		
		if (n1 != 0)
		{
			v3d<fGL> curr = v3d<fGL>(data2[n1 + 0], data2[n1 + 1]);
			v3d<fGL> prev = v3d<fGL>(data2[n1 + 0], data2[n1 - 1]);
			
			fGL angle = curr.ang(prev);
			fGL extra = radius * cos(angle / 2.0) / sin(angle / 2.0);
			curr = curr * (extra / curr.len());
			
			data3[n1 * 2 + 0][0] -= curr[0];
			data3[n1 * 2 + 0][1] -= curr[1];
			data3[n1 * 2 + 0][2] -= curr[2];
		}
		
		// calculate extension for the end-point...
		
		if (n1 != (np1 - 1))
		{
			v3d<fGL> curr = v3d<fGL>(data2[n1 + 1], data2[n1 + 0]);
			v3d<fGL> prev = v3d<fGL>(data2[n1 + 1], data2[n1 + 2]);
			
			fGL angle = curr.ang(prev);
			fGL extra = radius * cos(angle / 2.0) / sin(angle / 2.0);
			curr = curr * (extra / curr.len());
			
			data3[n1 * 2 + 1][0] -= curr[0];
			data3[n1 * 2 + 1][1] -= curr[1];
			data3[n1 * 2 + 1][2] -= curr[2];
		}
		
		// calculate the y-directions so that we have correct direction and that
		// cylinder edges match (since our cylinders are not perfectly spherical)!!!
		
		v3d<fGL> zdir = v3d<fGL>(data2[n1 + 0], data2[n1 + 1]);
		v3d<fGL> ydir = zdir.vpr(xdir); ydir = ydir / ydir.len();
		xdir = ydir.vpr(zdir); xdir = xdir / xdir.len();
		
		data4[n1][0] = ydir[0];
		data4[n1][1] = ydir[1];
		data4[n1][2] = ydir[2];
	}
}

void mm2_ribbon::UpdateExtraPoints(void)
{
	v3d<fGL> tmpv1; v3d<fGL> tmpv2;
	
	tmpv1 = v3d<fGL>(head_refs[1]);
	tmpv2 = v3d<fGL>(head_refs[0], head_refs[1]);
	for (i32s n1 = 0;n1 < extra_points;n1++)
	{
		v3d<fGL> tmpv3 = tmpv1 + (tmpv2 * ((fGL) n1 + 1));
		for (i32s n2 = 0;n2 < 3;n2++) head_points[n1][n2] = tmpv3[n2];
	}
	
	tmpv1 = v3d<fGL>(tail_refs[1]);
	tmpv2 = v3d<fGL>(tail_refs[0], tail_refs[1]);
	for (i32s n1 = 0;n1 < extra_points;n1++)
	{
		v3d<fGL> tmpv3 = tmpv1 + (tmpv2 * ((fGL) n1 + 1));
		for (i32s n2 = 0;n2 < 3;n2++) tail_points[n1][n2] = tmpv3[n2];
	}
}

void mm2_ribbon::Render(void)
{
	if (glIsList(list_id) == GL_TRUE) glCallList(list_id);
	else
	{
		glNewList(list_id, GL_COMPILE_AND_EXECUTE);
		
		i32s np1 = resol1 * (length - 1);
		
		// calculate only "inexact" cutting plane using average...
		// good enough approximation since cylinders are almost unidirectional.
		
		glEnable(GL_LIGHTING); glBegin(GL_TRIANGLES);
		fGL_a3 point1[resol2]; fGL_a3 normal1[resol2];
		fGL_a3 point2[resol2]; fGL_a3 normal2[resol2];
		
		for (i32s n1 = 0;n1 < np1;n1++)
		{
			v3d<fGL> ydir = v3d<fGL>(data4[n1]);
			
			v3d<fGL> zdir = v3d<fGL>(data2[n1 + 0], data2[n1 + 1]);
			v3d<fGL> xdir = ydir.vpr(zdir); xdir = xdir / xdir.len();
			
			for (i32s n2 = 0;n2 < resol2;n2++)
			{
				fGL angle = 2.0 * M_PI * (fGL) n2 / (fGL) resol2;
				fGL xk = radius * sin(angle); fGL yk = radius * cos(angle);
				
				v3d<fGL> pv1 = v3d<fGL>(data3[n1 * 2 + 0]);
				pv1 = pv1 + xdir * xk; pv1 = pv1 + ydir * yk;
				
				v3d<fGL> pv2 = v3d<fGL>(data3[n1 * 2 + 1]);
				pv2 = pv2 + xdir * xk; pv2 = pv2 + ydir * yk;
				
				v3d<fGL> nv = (xdir * xk) + (ydir * yk);
				nv = nv / nv.len();
				
				for (i32s n3 = 0;n3 < 3;n3++)
				{
					point1[n2][n3] = pv1[n3]; normal1[n2][n3] = nv[n3];
					point2[n2][n3] = pv2[n3]; normal2[n2][n3] = nv[n3];
				}
			}
			
			if (n1 != 0)
			{
				ydir = v3d<fGL>(data4[n1 - 1]);
				
				zdir = v3d<fGL>(data2[n1 - 1], data2[n1 + 0]);
				xdir = ydir.vpr(zdir); xdir = xdir / xdir.len();
				
				for (i32s n2 = 0;n2 < resol2;n2++)
				{
					fGL angle = 2.0 * M_PI * (fGL) n2 / (fGL) resol2;
					fGL xk = radius * sin(angle); fGL yk = radius * cos(angle);
					
					v3d<fGL> pv2p = v3d<fGL>(data3[(n1 - 1) * 2 + 1]);
					pv2p = pv2p + xdir * xk; pv2p = pv2p + ydir * yk;
					
					v3d<fGL> nvp = (xdir * xk) + (ydir * yk);
					nvp = nvp / nvp.len();
					
					for (i32s n3 = 0;n3 < 3;n3++)
					{
						point1[n2][n3] = (point1[n2][n3] + pv2p[n3]) / 2.0;
						normal1[n2][n3] = (normal1[n2][n3] + nvp[n3]) / 2.0;
					}
				}
			}
			
			if (n1 != (np1 - 1))
			{
				ydir = v3d<fGL>(data4[n1 + 1]);
				
				zdir = v3d<fGL>(data2[n1 + 1], data2[n1 + 2]);
				xdir = ydir.vpr(zdir); xdir = xdir / xdir.len();
				
				for (i32s n2 = 0;n2 < resol2;n2++)
				{
					fGL angle = 2.0 * M_PI * (fGL) n2 / (fGL) resol2;
					fGL xk = radius * sin(angle); fGL yk = radius * cos(angle);
					
					v3d<fGL> pv1n = v3d<fGL>(data3[(n1 + 1) * 2 + 0]);
					pv1n = pv1n + xdir * xk; pv1n = pv1n + ydir * yk;
					
					v3d<fGL> nvn = (xdir * xk) + (ydir * yk);
					nvn = nvn / nvn.len();
					
					for (i32s n3 = 0;n3 < 3;n3++)
					{
						point2[n2][n3] = (point2[n2][n3] + pv1n[n3]) / 2.0;
						normal2[n2][n3] = (normal2[n2][n3] + nvn[n3]) / 2.0;
					}
				}
			}
			
			i32s index = (i32s) floor(data1[n1]);
			fGL_a3 color1; fGL mod1 = data1[n1 + 0] - (fGL) index;
			fGL_a3 color2; fGL mod2 = data1[n1 + 1] - (fGL) index;
			
			for (i32s n2 = 0;n2 < 3;n2++)
			{
				color1[n2] = data5[index][n2] * (1.0 - mod1) + data5[index + 1][n2] * mod1;
				color2[n2] = data5[index][n2] * (1.0 - mod2) + data5[index + 1][n2] * mod2;
			}
			
			for (i32s n2 = 0;n2 < resol2;n2++)
			{
				i32s n3 = (n2 + 1) % resol2;
				
				glColor3fv(color2);
				glNormal3fv(normal2[n2]); glVertex3fv(point2[n2]);
				
				glColor3fv(color1);
				glNormal3fv(normal1[n2]); glVertex3fv(point1[n2]);
				glNormal3fv(normal1[n3]); glVertex3fv(point1[n3]);
				
				glColor3fv(color1);
				glNormal3fv(normal1[n3]); glVertex3fv(point1[n3]);
				
				glColor3fv(color2);
				glNormal3fv(normal2[n3]); glVertex3fv(point2[n3]);
				glNormal3fv(normal2[n2]); glVertex3fv(point2[n2]);
			}
		}
		
		glEnd();	// GL_TRIANGLES
		
		glDisable(GL_LIGHTING);
		glEndList();
	}
}

/*################################################################################################*/

#endif	// ENABLE_GRAPHICS

// eof
