// T3MM2DOCV.CPP

// Copyright (C) 1998 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "t3mm2docv.h"

#include "glade_interface.h"

#include "t3main.h"
#include "t3dialog.h"
#include "t3errutil.h"
#include "t3views.h"

#include "mm2rbn.h"

#include "plane.h"
#include "surface.h"

#include "color.h"
#include "views.h"

#include "mm1mdl.h"

#include <fstream>
#include <strstream>
using namespace std;

/*################################################################################################*/

const char mm2_file_open_dialog::title[] = "Open Project File - mm2gp";
gnome_mm2_docv * mm2_file_open_dialog::docv = NULL;

mm2_file_open_dialog::mm2_file_open_dialog(gnome_mm2_docv * p1) : file_dialog(title, NULL, NULL)
{
	docv = p1;
}

mm2_file_open_dialog::~mm2_file_open_dialog(void)
{
}

bool mm2_file_open_dialog::OkEvent(const char * filename)
{
	if (docv == NULL)
	{
		docv = new gnome_mm2_docv(& cout, * gnome_class_factory::GetInstance(), NULL);
		docv->InitGnomeMDIChild();
	}
	
	ifstream ifile;
	ifile.open(filename, ios::in);
	docv->ReadStream(ifile);
	ifile.close();
	
	docv->ParseProjectFileNameAndPath(filename);
	
	gnome_mdi_child_set_name(GNOME_MDI_CHILD(docv->child), docv->GetProjectFileName(true));
	docv->UpdateAllWindowTitles();
	
	docv->UpdateAllGraphicsViews();
	
	return true;
}

void mm2_file_open_dialog::CancelEvent(void)
{
}

/*################################################################################################*/

const char mm2_file_save_dialog::title[] = "Save Project File - mm2gp";
gnome_mm2_docv * mm2_file_save_dialog::docv = NULL;

mm2_file_save_dialog::mm2_file_save_dialog(gnome_mm2_docv * p1) :
	file_dialog(title, MM2_FILTER, p1->GetFullProjectFileName())
{
	docv = p1;
}

mm2_file_save_dialog::~mm2_file_save_dialog(void)
{
}

bool mm2_file_save_dialog::OkEvent(const char * filename)
{
	if (docv == NULL)
	{
	  docv->err->ErrorMessage("mm2_file_save_dialog::OkEvent() failed");
	  exit(EXIT_FAILURE);
	}
	
  	// should check to see if file already exists...

	docv->ParseProjectFileNameAndPath(filename);
	
	gnome_mdi_child_set_name(GNOME_MDI_CHILD(docv->child), docv->GetProjectFileName(true));
	docv->UpdateAllWindowTitles();
	
	ofstream ofile;
	ofile.open(docv->GetFullProjectFileName(), ios::out);
	docv->WriteStream(ofile);
	ofile.close();

	return true;
}

void mm2_file_save_dialog::CancelEvent(void)
{
}

/*################################################################################################*/

const char mm2_trajfile_dialog::title[] = "Open Trajectory File - traj";
mm2_docv * mm2_trajfile_dialog::docv = NULL;

mm2_trajfile_dialog::mm2_trajfile_dialog(mm2_docv * p1) : file_dialog(title, NULL, NULL)
{
	docv = p1;
}

mm2_trajfile_dialog::~mm2_trajfile_dialog(void)
{
}

bool mm2_trajfile_dialog::OkEvent(const char * filename)
{
	docv->OpenTrajectory(filename);
	
	gtk_widget_destroy(dialog);	// close the dialog -> must return false...
	
	gnome_docv::glade_modal_dialog_owner = (gnome_mm2_docv *) docv;		// requires modal dialogs!!!
	
	GtkWidget * dialog = create_t1_dialog_trajectory();
	gnome_dialog_run_and_close(GNOME_DIALOG(dialog));
	
	docv->CloseTrajectory();
	return false;
}

void mm2_trajfile_dialog::CancelEvent(void)
{
}

/*################################################################################################*/

GnomeUIInfo gnome_mm2_docv::fileimport_submenu[] =
{
	GNOMEUIINFO_ITEM("pdb...", "pdb",
		popup_FileImport, NULL),
	
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_mm2_docv::file_submenu[] =
{
	GNOMEUIINFO_MENU_OPEN_ITEM(popup_FileOpen, NULL),
	GNOMEUIINFO_SUBTREE("_Import", fileimport_submenu),
	
	GNOMEUIINFO_SEPARATOR,
	
	GNOMEUIINFO_MENU_SAVE_AS_ITEM(popup_FileSaveAs, NULL),
	
	GNOMEUIINFO_SEPARATOR,
	
	GNOMEUIINFO_MENU_CLOSE_ITEM(gnome_graphics_view::popup_FileClose, NULL),
	
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_mm2_docv::select_submenu[] =
{
	GNOMEUIINFO_ITEM("Select All", "select all atoms...",
		gnome_graphics_view::popup_SelectAll, NULL),
		
	GNOMEUIINFO_ITEM("Invert Selection", "invert the selection...",
		gnome_graphics_view::popup_InvertSelection, NULL),
		
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_mm2_docv::viewscreate_submenu[] =
{
	GNOMEUIINFO_ITEM("New Camera", "create a new view with a new camera...",
		gnome_graphics_view::popup_ViewsNewCam, NULL),
	
	GNOMEUIINFO_ITEM("New View", "create a new view using the current camera...",
		gnome_graphics_view::popup_ViewsNewView, NULL),
	
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_mm2_docv::views_submenu[] =
{
	GNOMEUIINFO_ITEM("Attach/Detach This View", "attach/detach this view...",
		gnome_graphics_view::popup_ViewsAttachDetach, NULL),
		
	GNOMEUIINFO_SEPARATOR,
	
	GNOMEUIINFO_SUBTREE("_Create", viewscreate_submenu),
	
	GNOMEUIINFO_ITEM("Delete This View", "remove this view...",
		gnome_graphics_view::popup_ViewsDeleteView, NULL),
		
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_mm2_docv::lights_submenu[] =
{
	GNOMEUIINFO_ITEM("Create New Light", "create a new light object...",
		gnome_graphics_view::popup_LightsNewLight, NULL),
		
	GNOMEUIINFO_SEPARATOR,
	
	GNOMEUIINFO_TOGGLEITEM("Display Local Lights", "loc",
		gnome_graphics_view::popup_LightsSwitchLoc, NULL),
		
	GNOMEUIINFO_TOGGLEITEM("Display Global Lights", "glob",
		gnome_graphics_view::popup_LightsSwitchGlob, NULL),
		
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_mm2_docv::rendermode_style_radio[] =
{
	GNOMEUIINFO_ITEM("Ball & Stick", "bs",
		popup_RModeBallAndStick, NULL),
		
	GNOMEUIINFO_ITEM("Wireframe", "wf",
		popup_RModeWireFrame, NULL),
		
	GNOMEUIINFO_ITEM("van der Waals", "vdw",
		popup_RModeVanDerWaals, NULL),
		
	GNOMEUIINFO_ITEM("Solvent-Accessible", "sas",
		popup_RModeAccessible, NULL),
		
	GNOMEUIINFO_ITEM("Cylinders", "cyl",
		popup_RModeCylinders, NULL),
		
	GNOMEUIINFO_ITEM("Nothing", "null",
		popup_RModeNothing, NULL),

	GNOMEUIINFO_END
};

GnomeUIInfo gnome_mm2_docv::rendermode_submenu[] =
{
        GNOMEUIINFO_RADIOLIST(rendermode_style_radio),
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_mm2_docv::projection_radio[] =
{
	GNOMEUIINFO_ITEM("Perspective", "persp",
		gnome_graphics_view::popup_ProjPerspective, NULL),
		
	GNOMEUIINFO_ITEM("Orthographic", "ortho",
		gnome_graphics_view::popup_ProjOrthographic, NULL),

	GNOMEUIINFO_ITEM("Red-Green Stereo", "redgre",
		gnome_graphics_view::popup_ProjRedGreen, NULL),
		
	GNOMEUIINFO_ITEM("Relaxed-Eye Stereo", "releye",
		gnome_graphics_view::popup_ProjRelaxedEye, NULL),
		
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_mm2_docv::projection_submenu[] =
{
        GNOMEUIINFO_RADIOLIST(projection_radio),
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_mm2_docv::render_submenu[] =
{
	GNOMEUIINFO_SUBTREE("_Views", views_submenu),
	GNOMEUIINFO_SUBTREE("_Lights", lights_submenu),
	GNOMEUIINFO_SUBTREE("_Rendering Mode", rendermode_submenu),
	GNOMEUIINFO_SUBTREE("_Projection", projection_submenu),
	
	GNOMEUIINFO_TOGGLEITEM("Quick Update Mode", "quick update...",
		gnome_graphics_view::popup_RenderQuickUpdate, NULL),
		
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_mm2_docv::objects_submenu[] =
{
	GNOMEUIINFO_ITEM("Ribbon", "...",
		popup_ObjRibbon, NULL),
		
	GNOMEUIINFO_ITEM("ESP-plane", "...",
		popup_ObjEPlane, NULL),
		
	GNOMEUIINFO_ITEM("volume-rendered ESP", "...",
		popup_ObjEVolume, NULL),
		
	GNOMEUIINFO_ITEM("ESP-surface", "...",
		popup_ObjESurface, NULL),
		
	GNOMEUIINFO_ITEM("ESP-colored vdW-surface", "...",
		popup_ObjVDWSurface, NULL),
		
	GNOMEUIINFO_SEPARATOR,
	
	GNOMEUIINFO_ITEM("Delete Current Object", "delete",
		gnome_graphics_view::popup_ObjectsDeleteCurrent, NULL),
		
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_mm2_docv::compute_submenu[] =
{
	GNOMEUIINFO_ITEM("Energy", "...",
		popup_CompEnergy, NULL),
		
	GNOMEUIINFO_ITEM("Geometry Optimization...", "...",
		popup_CompGeomOpt, NULL),
		
	GNOMEUIINFO_ITEM("Molecular Dynamics...", "...",
		popup_CompMolDyn, NULL),
	
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_mm2_docv::popupmenu_info[] =
{
	GNOMEUIINFO_SUBTREE("_File", file_submenu),
	GNOMEUIINFO_SUBTREE("_Select", select_submenu),
	
	GNOMEUIINFO_SEPARATOR,
	
	GNOMEUIINFO_SUBTREE("_Render", render_submenu),
	GNOMEUIINFO_SUBTREE("_Objects", objects_submenu),

	GNOMEUIINFO_SEPARATOR,
	
	GNOMEUIINFO_SUBTREE("_Compute", compute_submenu),
	
	GNOMEUIINFO_ITEM("MD Trajectory Viewer...", "...",
		popup_TrajView, NULL),
		
	GNOMEUIINFO_END
};

GnomeUIInfo gnome_mm2_docv::popupmenu_dummy[] =
{
        GNOMEUIINFO_SUBTREE("Ghemical", popupmenu_info),
        GNOMEUIINFO_END
};

/*################################################################################################*/

mm2_geomopt_param * gnome_mm2_docv::goparam = NULL;
mm2_moldyn_param * gnome_mm2_docv::mdparam = NULL;

gnome_mm2_docv::gnome_mm2_docv(ostream * p1, gnome_class_factory & p2, mm2_eng_param * p3) :
	gnome_docv(p1, p2), mm2_docv(p1, p2, p3), docview(p1, p2), model_simple(p1, p2)
{
	popupmenu = gnome_popup_menu_new(popupmenu_info);
}

gnome_mm2_docv::~gnome_mm2_docv(void)
{
}

void gnome_mm2_docv::popup_FileOpen(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_mm2_docv * docv = dynamic_cast<gnome_mm2_docv *>(gv->docv);
	docv->err->Message("Sorry, this feature is not yet implemented.");
}

void gnome_mm2_docv::popup_FileImport(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_mm2_docv * docv = dynamic_cast<gnome_mm2_docv *>(gv->docv);
	if (docv)
	{
cout << "give name of the PDB file to import ??? "; cin >> docv->buffer;
cout << "give the chain index to be imported, or -1 to import all chains ??? "; i32s ci; cin >> ci;
docv->ImportPDB(docv->buffer, ci); docv->UpdateAllGraphicsViews();
	}
}

void gnome_mm2_docv::popup_FileSaveAs(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_mm2_docv * docv = dynamic_cast<gnome_mm2_docv *>(gv->docv);
	if (docv) new mm2_file_save_dialog(docv);	// memory leak???
}

void gnome_mm2_docv::popup_RModeWireFrame(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gv->render = RENDER_WIREFRAME; gv->docv->UpdateAllGraphicsViews();
}

void gnome_mm2_docv::popup_RModeBallAndStick(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gv->render = RENDER_BALL_AND_STICK; gv->docv->UpdateAllGraphicsViews();
}

void gnome_mm2_docv::popup_RModeVanDerWaals(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gv->render = RENDER_VAN_DER_WAALS; gv->docv->UpdateAllGraphicsViews();
}

void gnome_mm2_docv::popup_RModeAccessible(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gv->render = RENDER_ACCESSIBLE; gv->docv->UpdateAllGraphicsViews();
}

void gnome_mm2_docv::popup_RModeCylinders(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gv->render = RENDER_CYLINDERS; gv->docv->UpdateAllGraphicsViews();
}

void gnome_mm2_docv::popup_RModeNothing(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gv->render = RENDER_NOTHING; gv->docv->UpdateAllGraphicsViews();
}

void gnome_mm2_docv::popup_ObjRibbon(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_mm2_docv * docv = dynamic_cast<gnome_mm2_docv *>(gv->docv);
	if (docv)
	{
		for (i32s n1 = 0;n1 < (i32s) docv->chn_vector.size();n1++)
		{
			smart_object * NewObject;
			NewObject = new mm2_ribbon(docv, gv->colormode, n1, 4);		// min. order is 2!!!
			docv->AddObject(NewObject);
		}
		
		docv->UpdateAllGraphicsViews();
	}
}

// planes/surfaces/etc... are done here, in a simple and straightforward way.
// just equivalent stuff is repeated at TARGET2. how to improve this???

// an advanced dialog box would be needed here, to replace the text stuff.
// the dialog should be flexible enough, so it could be used in all models, not just here...

// does it make any sense to write DoPlane, DoSurface, etc???

void gnome_mm2_docv::popup_ObjEPlane(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_mm2_docv * docv = dynamic_cast<gnome_mm2_docv *>(gv->docv);
	if (docv)
	{
		fGL tmp1;
		cp_param cpp; cpp.np = docv->model_prefs->Value("MM2Graphics/PlaneResolution", 30); 
		cpp.docv = docv; cpp.ref = (mm2_docv *) docv;
		
		cout << "give dimension of the plane [nm] (2.5 might be ok) ??? "; cin >> tmp1;
		
		cpp.dim = tmp1; cpp.transparent = true;
		cpp.vf = (ValueFunction *) mm2_GetESPValue; cpp.cf = (ColorFunction *) GetRBRange1;
		cpp.value = 138.9354518 / 10.0; cpp.alpha = 0.75;
		
		docv->AddObject(new color_plane_object(ol_static(), cpp, "ESP-"));
		docv->UpdateAllGraphicsViews();
	}
}

void gnome_mm2_docv::popup_ObjEVolume(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_mm2_docv * docv = dynamic_cast<gnome_mm2_docv *>(gv->docv);
	if (docv)
	{
		fGL tmp1;
		cp_param cpp; cpp.np = docv->model_prefs->Value("MM2Graphics/SurfaceResolution", 30);
		cpp.docv = docv; cpp.ref = (mm2_docv *) docv;
		
		cout << "give dimension of the volume [nm] (2.5 might be ok) ??? "; cin >> tmp1;
		
		cpp.dim = tmp1; cpp.transparent = true;
		cpp.vf = (ValueFunction *) mm2_GetESPValue; cpp.cf = (ColorFunction *) GetRBRange2;
		cpp.value = 138.9354518 / 10.0; cpp.alpha = 0.25;
		
		docv->AddObject(new volume_rendering_object(ol_static(), cpp, 20, tmp1 / 2.0, (* gv->cam), "ESP-"));
		docv->UpdateAllGraphicsViews();
	}
}

void gnome_mm2_docv::popup_ObjESurface(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_mm2_docv * docv = dynamic_cast<gnome_mm2_docv *>(gv->docv);
	if (docv)
	{
		fGL tmp1; fGL tmp2; char input;
		
		i32s size = docv->model_prefs->Value("MM2Graphics/SurfaceResolution", 50);
		i32s sz[3] = { size, size, size };
		fGL dm[3] = { 0.55, 0.50, 0.45 };
		
		cs_param csp2a; cs_param csp2b;
		csp2a.np = sz; csp2a.dim = dm; csp2a.ostr = & cout;
		csp2a.docv = docv; csp2a.ref = (mm2_docv *) docv; csp2a.next = & csp2b;
		csp2b.np = sz; csp2b.dim = dm; csp2b.ostr = & cout;
		csp2b.docv = docv; csp2b.ref = (mm2_docv *) docv; csp2b.next = NULL;
		
		tmp1 = 138.9354518 / 10.0;
		cout << "give dimension of the surface [nm] (5.0 might be ok) ??? ";
		cin >> tmp2; dm[0] = dm[1] = dm[2] = tmp2;
		
		cout << "choose the type of surface : solid or wireframe ? (s/w) ";
		cin >> input; csp2a.wireframe = csp2b.wireframe = (input == 'w' || input == 'W');
		
		csp2a.transparent = !true;
		csp2a.vf1 = (ValueFunction *) mm2_GetESPValue; csp2a.vf2 = (ValueFunction *) GetUnity;
		csp2a.cvalue = 1.0; csp2a.alpha = 0.25; csp2a.toler = 1.0e-6 * tmp1; csp2a.maxc = 500;
		csp2a.cf = (ColorFunction *) GetRedColor; csp2a.svalue = +tmp1;
		
		csp2b.transparent = !true;
		csp2b.vf1 = (ValueFunction *) mm2_GetESPValue; csp2b.vf2 = (ValueFunction *) GetUnity;
		csp2b.cvalue = 1.0; csp2b.alpha = 0.25; csp2b.toler = 1.0e-6 * tmp1; csp2b.maxc = 500;
		csp2b.cf = (ColorFunction *) GetBlueColor; csp2b.svalue = -tmp1;
		
		docv->AddObject(new color_surface_object(ol_static(), csp2a, "ESP-"));
		docv->UpdateAllGraphicsViews();
	}
}

void gnome_mm2_docv::popup_ObjVDWSurface(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_mm2_docv * docv = dynamic_cast<gnome_mm2_docv *>(gv->docv);
	if (docv)
	{
		fGL tmp1; fGL tmp2; char input;
		
		i32s size = docv->model_prefs->Value("MM2Graphics/SurfaceResolution", 50);
		i32s sz[3] = { size, size, size };
		fGL dm[3] = { 0.55, 0.50, 0.45 };
		
		cs_param csp1;
		csp1.np = sz; csp1.dim = dm; csp1.ostr = & cout;
		csp1.docv = docv; csp1.ref = (mm2_docv *) docv; csp1.next = NULL;
		
		tmp1 = 138.9354518 / 10.0;
		cout << "give dimension of the surface [nm] (5.0 might be ok) ??? ";
		cin >> tmp2; dm[0] = dm[1] = dm[2] = tmp2;
		
		cout << "choose the type of surface : solid or wireframe ? (s/w) ";
		cin >> input; csp1.wireframe = (input == 'w' || input == 'W');
		
		csp1.transparent = true; csp1.cf = (ColorFunction *) GetRBRange1;
		csp1.vf1 = (ValueFunction *) mm2_GetSASValue; csp1.vf2 = (ValueFunction *) mm2_GetESPValue;
		csp1.svalue = 1.0; csp1.cvalue = tmp1; csp1.alpha = 0.50; csp1.toler = 1.0e-6 * tmp1; csp1.maxc = 500;
		
		docv->AddObject(new color_surface_object(ol_static(), csp1, "ESP-colored VDW-"));
		docv->UpdateAllGraphicsViews();
	}
}

void gnome_mm2_docv::popup_CompEnergy(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_mm2_docv * docv = dynamic_cast<gnome_mm2_docv *>(gv->docv);
	if (docv) docv->DoEnergy();
}

void gnome_mm2_docv::popup_CompGeomOpt(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_mm2_docv * docv = dynamic_cast<gnome_mm2_docv *>(gv->docv);
	if (docv)
	{
		mm2_geomopt_param param;
		param.treshold_nsteps = 500;
		param.treshold_grad = 0.0;	// not yet used...
		param.treshold_delta_e = 0.0;	// not yet used...
		
		docv->DoGeomOpt(param);
	}
}

void gnome_mm2_docv::popup_CompMolDyn(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_mm2_docv * docv = dynamic_cast<gnome_mm2_docv *>(gv->docv);
	if (docv)
	{
		mm2_moldyn_param param;
		param.nsteps = 10000;
		param.temperature = 300.0;
		param.timestep = 5.0;
		
		docv->DoMolDyn(param);
	}
}

void gnome_mm2_docv::popup_TrajView(GtkWidget *, gpointer data)
{
	gnome_graphics_view * gv = gnome_graphics_view::GetGV((GtkWidget *) data);
	gnome_mm2_docv * docv = dynamic_cast<gnome_mm2_docv *>(gv->docv);
	if (!docv->GetTrajectoryFile())
	{
		if (docv) new mm2_trajfile_dialog(docv);	// memory leak???
	}
	else docv->err->ErrorMessage("Trajectory already open?!?!?!");
}

/*##############################################*/
/*##############################################*/

void gnome_mm2_docv::GeomOptGetParam(mm2_geomopt_param & param)
{
	glade_modal_dialog_owner = this;	// requires modal dialogs!!!
	
	// here we just set "param" to a static variable,
	// where it's then available in glade code...
	
	goparam = & param;
	
	GtkWidget * dialog = create_a1_dialog_geomopt();
	gnome_dialog_run_and_close(GNOME_DIALOG(dialog));
	
	goparam = NULL;
}

#define START 10000	// see mm1docv.cpp!!!!!!!!

void gnome_mm2_docv::MolDynGetParam(mm2_moldyn_param & param)
{
	glade_modal_dialog_owner = this;	// requires modal dialogs!!!
	
	// here we just set "param" to a static variable,
	// where it's then available in glade code...
	
	mdparam = & param;
	
	GtkWidget * dialog = create_a2_dialog_moldyn();
	gnome_dialog_run_and_close(GNOME_DIALOG(dialog));
	
	mdparam = NULL;
}

/*################################################################################################*/

// eof
