// MM1DOCV.H : a graphical user interface for mm1-models.

// Copyright (C) 1998 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "config.h"	// this is target-dependent...

#ifndef MM1DOCV_H
#define MM1DOCV_H

#ifdef ENABLE_GRAPHICS

class mm1_docv;

class mm1_cm_element;		// mm1_atom *
class mm1_cm_state;		// mm1_atom *

/*################################################################################################*/

#include "docview.h"

#include "mm1mdl.h"
#include "mm1alg.h"

/*################################################################################################*/

class mm1_docv : virtual public docview, public mm1_mdl
{
	public:
	
	static mm1_cm_element cm_element;
	static mm1_cm_state cm_state;
	
	mm1_atom * draw_data[2];
	
	public:
	
	mm1_docv(ostream *, graphics_class_factory &);
	virtual ~mm1_docv(void);
	
	fGL GetDefaultFocus(void);		// virtual
	
	const char * GetType(void);			// virtual
	color_mode * GetDefaultColorMode(void);		// virtual
	
	void SelectAll(void);				// virtual
	void InvertSelection(void);			// virtual
//	void SelectNone(void);				// virtual	// see the base class...
	
	bool TestAtom(mm1_atom *, rmode);
	bool TestBond(mm1_bond *, rmode);
	
	void SetColor(color_mode *, mm1_atom *);
	
	void InitGL(void);				// virtual
	
	/**	Selection is done in a rather crude way by dumping the atom pointers directly to 
		the OGL selection buffer and reading them later there... Works fine as long as 
		both datatypes have the same size (currently it's 32 bits). If we some day need 
		64-bit pointers and have only 32-bit sel-buffer we have to use two names...
	*/
	
	void Render(graphics_view *, rmode);		// virtual
	
	/**	This is just quickly cut into a different function for clarity... We will call this
		multiple times with translation applied if we render some periodic systems...
	*/
	
	void RenderScene(graphics_view *, rmode, bool);
	
	void Center(transformer *);			// virtual
	void Transform(transformer *);			// virtual
	
	void DrawEvent(graphics_view *, vector<iGLu> &);	// virtual
	void EraseEvent(graphics_view *, vector<iGLu> &);	// virtual
	void SelectEvent(graphics_view *, vector<iGLu> &);	// virtual
	void MeasureEvent(graphics_view *, vector<iGLu> &);	// virtual
	
	void ProcessCommandString(graphics_view *, const char *);	// virtual
	
	// here are some Do???() functions similar to those in mm1_mdl class.
	// however, the classes here are "interactive" and are directly dependent on graphics.
	// so you don't want to use any of these classes in the console version...
	
	void DoEnergyPlot1D(i32s, i32s, i32s, i32s, i32s, fGL, fGL, i32s, i32s, i32s);
	void DoEnergyPlot2D(i32s, i32s, i32s, i32s, i32s, fGL, fGL, i32s, i32s, i32s, i32s, i32s, fGL, fGL, i32s, i32s, i32s);
};

/*################################################################################################*/

class mm1_cm_element : public color_mode
{
	protected:
	
	public:
	
	mm1_cm_element(void) : color_mode() { }
	~mm1_cm_element(void) { }
	
	void GetColor(const void *, fGL_a4 &, prefs *pref = 0);
};

class mm1_cm_state : public color_mode
{
	protected:
	
	public:
	
	mm1_cm_state(void) : color_mode() { }
	~mm1_cm_state(void) { }
	
	void GetColor(const void *, fGL_a4 &, prefs *pref = 0);
};

/*################################################################################################*/

#endif	// ENABLE_GRAPHICS
#endif	// MM1DOCV_H

// eof
