/* GtkHint - prototype hint for the source editor widget.
 * Copyright (C) 1998 Kristian Hgsberg.
 *
 * Hints was written (or mostly stolen from gtktooltips) by Kristian
 * Hgsberg <hogsberg@daimi.au.dk>.  Bug reports should be send there.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef __GTK_HINT_H__
#define __GTK_HINT_H__

#include <gdk/gdk.h>
#include <gtk/gtkdata.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define GTK_TYPE_HINT                  (gtk_hint_get_type ())
#define GTK_HINT(obj)                  (GTK_CHECK_CAST ((obj), GTK_TYPE_HINT, GtkHint))
#define GTK_HINT_CLASS(klass)          (GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_HINT, GtkHintClass))
#define GTK_IS_HINT(obj)               (GTK_CHECK_TYPE ((obj), GTK_TYPE_HINT))
#define GTK_IS_HINT_CLASS(klass)       (GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_HINT))

typedef struct _GtkHint	 GtkHint;
typedef struct _GtkHintClass GtkHintClass;
typedef struct _GtkHintData	 GtkHintData;

typedef char *(*GtkHintCallback)(char *match, gpointer data);

struct _GtkHintData
{
  GtkHint *hint;
  GtkWidget *widget;
  gchar *text;
  GdkFont *font;
  gint width;
  GList *row;

  struct re_pattern_buffer *regex;

  GtkHintCallback callback;
  gpointer callback_data;
};

struct _GtkHint
{
  GtkData data;

  GtkWidget *hint_window;
  GtkHintData *active_hint_data;
  GList *hint_data_list;

  GdkGC *gc;
  GdkColor *foreground;
  GdkColor *background;

  guint   delay : 30;
  guint	  enabled : 1;
  gint	  timer_tag;
};

struct _GtkHintClass
{
  GtkDataClass parent_class;
};

GtkType	     gtk_hint_get_type	   (void);
GtkHint*     gtk_hint_new	   (void);

void	     gtk_hint_enable	   (GtkHint         *hint);
void	     gtk_hint_disable	   (GtkHint         *hint);
void	     gtk_hint_set_delay	   (GtkHint         *hint,
				    guint            delay);
void         gtk_hint_set_hint     (GtkHint         *hint,
				    GtkWidget       *widget,
				    const char      *regex,
				    GtkHintCallback  callback,
				    gpointer         callback_data);
void	     gtk_hint_set_colors   (GtkHint         *hint,
				    GdkColor        *background,
				    GdkColor	    *foreground);
GtkHintData* gtk_hint_data_get	   (GtkWidget       *widget);
void         gtk_hint_force_window (GtkHint         *hint);



#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GTK_HINT_H__ */
