/* $Header: /cvs/gnome/gIDE/src/gI_edit.h,v 1.2 1999/11/06 17:45:39 jpr Exp $ */
/* gIDE
 * Copyright (C) 1998-2000 Steffen Kern
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef GI_EDIT_H
#define GI_EDIT_h

#include <gtk/gtk.h>

/*
 * Prototypes for 'gI_edit.c'
 */
void edit_undo( GtkWidget *widget, gpointer data );
void edit_redo( GtkWidget *widget, gpointer data );
void edit_cut( GtkWidget *widget, gpointer data );
void edit_copy( GtkWidget *widget, gpointer data );
void edit_paste( GtkWidget *widget, gpointer data );
void edit_select_all( GtkWidget *widget, gpointer data );
void edit_select_line( GtkWidget *widget, gpointer data );
void edit_read_only( GtkWidget *widget, gpointer data );
glong get_end_of_line( GtkWidget *text, glong point );
glong get_begin_of_line( GtkWidget *text, glong point );
void edit_date_time( GtkWidget *widget, gpointer data );
void edit_delete_to_bol( GtkWidget *widget, gpointer data );
void edit_delete_to_eol( GtkWidget *widget, gpointer data );
void edit_delete_to_bof( GtkWidget *widget, gpointer data );
void edit_delete_to_eof( GtkWidget *widget, gpointer data );

typedef struct _gI_UndoItem gI_UndoItem;
struct _gI_UndoItem
{
        gI_document *document;
        gint type;
        gchar *data;
        gint from;
        gint to;
	gboolean changed;
};


#define GI_UNDO_INSERT 1
#define GI_UNDO_DELETE 2
#define GI_UNDO_BEGIN  3

gI_UndoItem *gI_UndoItem_new( gI_document *document,
                              const gchar *data,
			      gint data_length,
                              gint from,
                              gint to,
                              gint type );
void gI_UndoItem_destroy( gI_UndoItem *undo );
void gI_UndoItem_add( gI_UndoItem *undo );

void set_read_only( gboolean state );

void edit_gpl_c( GtkWidget *widget, gpointer data );
void edit_gpl_cpp( GtkWidget *widget, gpointer data );

void edit_repl_tab_spaces( GtkWidget *widget, gpointer data );

#endif

