/*
 *  
 *  $Id: controladorautenticacion.h 3787 2011-04-29 06:38:01Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once

#include <api/api.h>
#include <api/icontroladorautenticacion.h>
#include <yasper/yasper.h>
#include <list>

class wxSQLite3Database;
namespace GSEC {
	namespace Auth {
		typedef enum {
			TA_NO_LOGIN = 0,
			TA_USER_PASSWORD,
			TA_PASSWORD
		} TipoAutenticacion;

		class EXTAPI ControladorAutenticacion : public IControladorAutenticacion {
		public:

			static ControladorAutenticacion* Instance();
			static void FreeInstance();

			GnkPtr<wxSQLite3Database> IniciarSesionModificacionBBDDSeguridad();
			void GuardarCambiosBBDDSeguridad(GnkPtr<wxSQLite3Database> sesion);
			void CancelarCambiosYCerrarBBDDSeguridad(GnkPtr<wxSQLite3Database> sesion);


			TipoAutenticacion GetTipoAutenticacion();
			void SetTipoAutenticacion(TipoAutenticacion tipo);

			virtual bool Auth(const std::string& user, const std::string& password);

			bool InsertarUsuario(const std::string& user, const std::string& password, GnkPtr<wxSQLite3Database> sesion=NULL);

			bool CambiarPassword(const std::string& user, const std::string& password, GnkPtr<wxSQLite3Database> sesion=NULL);

			bool SetPasswordGeneral(const std::string& password, GnkPtr<wxSQLite3Database> sesion = NULL);

			bool EliminarUsuario(const std::string& user, GnkPtr<wxSQLite3Database> sesion=NULL);

			void GetAllUsers(std::list<std::string>& listaUsuarios, GnkPtr<wxSQLite3Database> sesion =NULL);

			bool ExisteUsuario(const std::string& user, GnkPtr<wxSQLite3Database> sesion=NULL);

			bool IsPasswordGeneralSetted(GnkPtr<wxSQLite3Database> sesion=NULL);

			int GetMaxLongitudUsuario();			

		protected:
			ControladorAutenticacion();
			~ControladorAutenticacion();

			static ControladorAutenticacion* m_pInstance;

			bool AutenticacionUsuarioPassword(const std::string& usuario, const std::string& password);
			bool AutenticacionPassword(const std::string& password);

			std::string GetHashPassword(const std::string& password);
			GnkPtr<wxSQLite3Database> GetNewConexionSeguridad();

		};
	}
}
