/*
 *  
 *  $Id: integrationcontroller.h 4782 2012-03-08 11:01:25Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <api/api.h>
#include <map>
#include <string>
#include <api/imodelointegracion.h>
#include <api/icontroladoreventos.h>
#include <wx/string.h>
#include <wx/xml/xml.h>
namespace GNC {
	namespace GCS {
		class IControladorModulo;
	}
}

namespace GIL {
		class EXTAPI IntegrationException : public GNC::GCS::IException {
		public:
			IntegrationException(const std::string& msg, const std::string& component="Modelo", bool fatal = true) throw() : GNC::GCS::IException(msg, component, fatal) {}			
		};

		class EXTAPI IXMLIntegrationParser {
		public:
			virtual std::list<std::string> GetKeys() = 0;
			virtual void ParseIntegrationXML(GIL::IntegrationModelList& modelos, wxXmlNode* pRoot) = 0;			
		};

		class EXTAPI IntegrationController : public GNC::GCS::IObservador {
		public:
			static IntegrationController* Instance();
			static void FreeInstance();

			bool Process(GIL::IntegrationModelList& models);
			void ReProcess(GNC::GCS::IControladorModulo* pModule, std::string& uidSerie, GIL::IntegrationModelList& models);

			// Event listener realization
			virtual void ProcesarEvento(GNC::GCS::Eventos::IEvento *evt);

			/* devuelve el uid de modulo a partir del pid indicado*/
			virtual std::string GetUID(const std::string& idPlantilla) const;
			virtual std::string GetUIDModulo(const std::string& idPlantilla) const;
			virtual std::string GetIdPlantilla(const std::string& uidModulo) const;

			//parsers...
			void RegisterParser(const std::string& xmlKey, GnkPtr<IXMLIntegrationParser>& pParser) 
			{
				if (m_mapParsers.find(xmlKey) != m_mapParsers.end()) {
					throw IntegrationException(_Std("Fatal error! you can't register two parsers with same  key").c_str());
				}
				m_mapParsers[xmlKey] = pParser;
			}

			void UnRegisterParser(const std::string& xmlKey) 
			{
				if (m_mapParsers.find(xmlKey) != m_mapParsers.end()) {
					m_mapParsers.erase(m_mapParsers.find(xmlKey));
				}
			}
			/* Parsea la cadena XML y construye el modelo de integracion. Los parametros no encontrados se asignan por defecto segun lo especificado en la configuracion global */
			virtual void ParsearModeloIntegracion(GIL::IntegrationModelList& modelos, const std::string& xmlString, const wxString& relativePath = wxEmptyString) const;


		protected:
			IntegrationController();
			~IntegrationController();
		

		protected:
			static IntegrationController* m_pInstance;
			typedef std::map<std::string,GnkPtr<IXMLIntegrationParser> > TMapIntegrationXMLParsers;
			TMapIntegrationXMLParsers m_mapParsers;


		};
}
