/*
 *  
 *  $Id: downloadelementcontainerpanel.h 4477 2011-12-13 11:16:56Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <map>
#include "dialogoadquisicionbase.h"

namespace GNC {
	namespace GUI {
		class DownloadElementPanel;

		class DownloadElementContainerPanel: public DownloadElementContainerPanelBase 
		{
		public:
			typedef std::map<std::string, DownloadElementPanel*> TMapElements;

			DownloadElementContainerPanel(wxWindow* pParent);
			~DownloadElementContainerPanel();

			bool FindDownload(const std::string& uid);
			bool AddDownload(const std::string& s, const std::string& pd,const std::string& sd, const std::string& sm, bool initIfStopped, bool seriesMode, const std::string& studyUID, const std::string& seriesUID);
			void RemoveDownload(DownloadElementPanel* de);

		protected:
			virtual void OnRemoveFinished(wxCommandEvent &event);
			TMapElements m_mapDownloads;

		};
	}
}
