/* GKRELLMWireless 0.2.1
|  Copyright (C) 1999-2001 Sjoerd Simons
|
|  Author:  Sjoerd Simons sjoerd@gkrellm.luon.net
|  Latest versions might be found at:  http://gkrellm.luon.net
|
|  This program is free software which I release under the GNU General Public
|  License. You may redistribute and/or modify this program under the terms
|  of that license as published by the Free Software Foundation; either
|  version 2 of the License, or (at your option) any later version.
|
|  This program is distributed in the hope that it will be useful,
|  but WITHOUT ANY WARRANTY; without even the implied warranty of
|  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
|  GNU General Public License for more details.
|
|  To get a copy of the GNU General Puplic License,  write to the
|  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <gkrellm/gkrellm.h>
#ifdef __FreeBSD__
  #include <net/if.h>
  #include <machine/if_wavelan_ieee.h>
  #define ANCACHE
  #include <dev/an/if_aironet_ieee.h>
#endif

#define PLUGIN_CONFIG_KEYWORD "gkrellmwireless"

#define WIRELESS_MAJOR_VERSION 0
#define WIRELESS_MINOR_VERSION 2
#define WIRELESS_EXTRA_VERSION ".1"

/* flags for all the differenct stuff */
#define ACTIVE     (1 << 0) /* this interface is alive now */ 
#define SHOW       (1 << 1) /* show or don't show this interface */
#define SHOW_LINK  (1 << 2) /* show link quality of this interface */
#define SHOW_LEVEL (1 << 3) /* show level of this interface */ 
#define SHOW_NOISE (1 << 4) /* show noise on this interface */

/* some maximums */
#define LINKQ_MAX 100
#define LEVEL_MAX 255
#define NOISE_MAX 255

typedef struct __wcard_t wcard_t;

struct __wcard_t {
  wcard_t *next;
  gchar *ifname;
  gint  flags; /* configuration flags */
  gint cflags;

  Panel *level_panel;
  Panel *link_panel;
  Panel *noise_panel;

  Decal *level_text;
  Decal *link_text;
  Decal *noise_text;
};
