// $Id: Widget.hh,v 1.46 2003/05/19 07:00:53 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef WIDGET_HH
#define WIDGET_HH
#include <config.h>
#include "Enums.hh"
#include "GladeTag.hh"
#include <iterator>
#include <list>
#include "Widget_type.hh"
#include "ChildParamList.hh"
#include <iostream>
#include <stdexcept>
#include <cassert>

// Widget is a Tag handle class with convenience additions for widget
// handling. Constructing a Widget from an Tag is very fast, so remembering
// only Tag* has no penalty (up to now).

// Due to C++'s limits we can't include a widget in one of its iterators ...
// so we use Tag*                       [or Tag& - do we?]

// we protect tag against modification if passed by a const
// constructor.

// WARNING: Tag's lifetime must exceed its derived Widget's !!!!
// and of course a containers lifetime should exceed it's iterators' lifetime
// WARNING2: since we use 'ti=Widget(parent).begin();' 
//  Widget's iterators must not rely on Widget's existance
// => Tags must live longer than Widget's iterators 

// I hate this nonsense, perhaps another reorganization should address this

class Widget
{  	Tag *tag,*childtag;
	mutable std::string name;
	bool is_const;
	
	void test4validity()
	{  if (tag->Type()=="child" && tag->begin()!=tag->end() && !childtag)
	   {  childtag=tag; tag=&*(tag->begin());
	   }
	   assert(tag->Type()=="widget" || tag->Type()=="placeholder");
	}
	void obselete(const char *x)
	{
	   std::cout << "Widget: obselete member function "<<x<<" called\n";
	}
public:
	// internal use
	Widget(Tag *t,Tag *c=0) throw() : tag(t), childtag(c), name(""), is_const(false)
	{ test4validity(); }
	// be careful to not pass a temporary
	Widget(const Tag &t,Tag *c=0) throw() 
	: tag((Tag*)&t), childtag(c), name(""), is_const(true)
	{ test4validity(); }
	// be careful to not pass a temporary
	Widget(const Tag &t,const std::string &_name,Tag *c=0) throw() 
		: tag((Tag*)&t), childtag(c), name(_name), is_const(true)
	{ test4validity(); }
	Widget(const Widget &w,const std::string &_name) throw() 
		: tag(w.tag), childtag(w.childtag), name(_name), is_const(w.is_const)
	{ test4validity(); }

	const Tag *getTagPtr() const { return tag; }
	const Tag &getTag() const { return *tag; }
	bool operator==(const Widget &w) const { return tag==w.tag; }
	const std::string Class() const throw();
	const std::string ChildName() const throw();
	Widget getParent() const throw(std::out_of_range);
	
	// wrapper for unification of glade-1+2
	bool hasProperty(const std::string &name) const;
	const std::string getProperty(const std::string &name, const std::string &_default="") const;
	int getIntProperty(const std::string &name, int _default=0) const
	{  return Tag::parse_value_def<int>(getProperty(name),_default); }
	bool getBoolProperty(const std::string &name, bool _default=false) const
	{  return Tag::parse_value_def<bool>(getProperty(name),_default); }
	float getFloatProperty(const std::string &name, float _default=0) const
	{  return Tag::parse_value_def<float>(getProperty(name),_default); }
	
	void setProperty(const std::string &name, const std::string &value="true");

	// const is not always true
	const std::string Name() const throw(); 
	Subwidget subwidgettype(const Widget &w) const throw();
	
	std::vector<std::string> Dependancies() const throw();
#if 0	
	bool hasTag(const std::string &t) const throw()
	{  return tag->hasTag(t); }
#endif	
	bool hasChildren() const throw();
	void debug() const throw()
	{  tag->debug(); }
	
	void mark(const std::string &tg) throw()
	{  assert(!is_const);
	   setProperty(tg,"true"); }
	void mark(const std::string &tg,const std::string &value) throw()
	{  assert(!is_const);
	   setProperty(tg,value); }
	   
	bool isSeperateClass() const throw()
	{  return getBoolProperty(CXX_SEPERATE_CLASS); }
	bool wasWrapped() const throw()
	{  return getBoolProperty(CXX_IS_MANAGED,false); }
	void markManaged() const throw() 
		// this is not const ... but I don't want to rewrite the
		// writers yet
	{  const_cast<Widget*>(this)->setProperty(CXX_IS_MANAGED,"true"); }
	
	const ChildParamList get_Child_params() const throw();

#if 0	
	const std::string getString(const std::string &t,const std::string &def="") const throw()
	{  return tag->getString(t,def); }
	bool getBool(const std::string &t,const bool def=false) const throw()
	{  return tag->getBool(t,def); } 
	int getInt(const std::string &t,const int def=-1) const throw()
	{  return tag->getInt(t,def); }
	float getFloat(const std::string &t,const float def=0) const throw()
	{  return tag->getFloat(t,def); }
#endif	
	
	// new functions:
	// - find internal subwidget by name

        // to get this class more compact
#include "Widget_iterators.hh"

	const_iterator begin() const;
	const_iterator end() const
	{  return const_iterator(tag->end(),tag->end(),""); }
	iterator begin();
	iterator end()
	{  assert(!is_const); // too hard?
	   return iterator(tag->end(),tag->end(),""); }

	const_iterator get_Signals() const throw()
	{  
	   return const_iterator(find(tag->begin(),tag->end(),"signal"),tag->end(),"signal");
	}
	
	const_iterator get_Accels() const throw();
	// replace this by getGladeAttr
//	static const std::string getAccelProperty(const_iterator it, const string &name, const string &_default="");
	
	const_contained_iterator begin_contained(InternalSelection _internal=NoInternal,bool debug=false) const;
	const_contained_iterator end_contained() const
	{  return const_contained_iterator(tag->end(),tag,NoInternal);
	}
};

#endif
