// $Id: expander.cc,v 1.3 2004/05/25 06:58:02 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 2004  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "bin.hh"

class Gtk_Expander : public Gtk_Bin
{public:
	typedef Gtk_Bin Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gtk_Expander(bool base_class_init=true);
	virtual bool NeedExplicitCtor(const Widget &w) const;
	virtual void ConstructionArgs(const Widget &w, CxxFile &f) const;
	virtual void AddChildren(const Widget &w,CxxFile &f,const std::string &instance,const WriterBase &writer_for_subw, const Widget &widget_for_subw) const;
	virtual void Configure(const Widget &w, CxxFile &f,const std::string &instance) const;
	virtual bool TwoFourDifferent(const Widget &w) const
	{ return true; }
};


static Gtk_Expander Gtk_Expander(false);

const std::string Gtk_Expander::TypeName(const Widget &w) const
{  return GtkPrefix()+(GTKMM24?"Expander":"HandleBox");
}

const std::string Gtk_Expander::IncludeName(const Widget &w) const
{  return Configuration.GtkmmIncludePath()+(GTKMM24?"expander.h":"handlebox.h");
}

Gtk_Expander::Gtk_Expander(bool base_class_init)
{  if (!base_class_init) Writer["GtkExpander"]=this;
}

void Gtk_Expander::ConstructionArgs(const Widget &w, CxxFile &f) const
{  f.FunctionArg();
}

bool Gtk_Expander::NeedExplicitCtor(const Widget &w) const
{  return false; }

void Gtk_Expander::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);

   If24(f);
   WriteBoolProperty(w,f,instance, "expanded");
   WriteIntProperty(w,f,instance, "spacing");
//   f.CppElse();
   f.EndIf();
}

void Gtk_Expander::AddChildren(const Widget &w,CxxFile &f,const std::string &instance,const WriterBase &writer_for_subw, const Widget &widget_for_subw) const
{  Widget::const_iterator i=w.begin();
   if (i!=w.end()) //  && (*i).Packing."type">label_item
   {  f.Statement() << instance << "add(" << Reference(*i) << ')';
      ++i;
   }
   if (i!=w.end()) //  && (*i).Packing."type">label_item
   {  If24(f);
      f.Statement() << instance << "set_label_widget(" << Reference(*i) << ')';
      f.EndIf();
      ++i;
   }
   assert(i==w.end());
}

