/* $Id: cfg.h,v 1.3 2000/01/13 20:11:22 mac Exp $ */

/*
 * glbiff -- A Mesa/OpenGL-based `xbiff' substitute
 * Copyright (C) 2000  Maciej Kalisiak
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#include <stl.h>
#include <string.h>
#include "rgb.h"
#include "astro.h"

class mailbox {
 public:
  char*		name;
  bool		adds_to_mail;

 public:
  mailbox( void ): name(NULL), adds_to_mail(true) {}
  mailbox( char* str, bool b=true ): adds_to_mail(b) {
    name = new char[ strlen(str)+1 ];
/*     if( !name ) */
/*       throw( "out of memory" ); */
    strcpy( name, str );
  }
  mailbox( const mailbox& mb ): adds_to_mail(mb.adds_to_mail) {
    name = new char[ strlen(mb.name)+1 ];
/*     if( !name ) */
/*       throw( "out of memory" ); */
    strcpy( name, mb.name );
  }
    
  ~mailbox( void ) {
    delete name;
  }
};


bool read_configuration( char* fname );

///// globals
extern list<mailbox> mboxes;
extern int check_interval;
extern int refresh_period;
extern int door_open_frames;
extern int cam_swing_frames;
extern int flag_up_frames;

extern coord my_long_lat;

extern list<Rgb_kf> sky_keyframes;
