/*  Glimmer - dragndrop.c
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "declarations.h"
#include "dragndrop.h"
#include "dialogs.h"
#include "file-io.h"
#include "syntax-highlight.h"
#include "main.h"

static void dnd_drop (GtkWidget * widget, GdkDragContext * context, gint x,
                      gint y, GtkSelectionData * selection_data, guint info,
                      guint time, gpointer data);
static gint uri_list_drag_recieved_dialog (GList * list);
static GList *drop_directory (gchar * directory, GList * files);
static gint recursive_open (gchar * dir);

enum {
    TARGET_URI_LIST
};
static GtkTargetEntry drop_types[] = {
    {"text/uri-list", 0, TARGET_URI_LIST}
};
static gint n_drop_types = sizeof (drop_types) / sizeof (drop_types[0]);

void
init_dnd (void)
{
    gtk_drag_dest_set (window,
                       (GtkDestDefaults) (GTK_DEST_DEFAULT_MOTION |
                                          GTK_DEST_DEFAULT_HIGHLIGHT |
                                          GTK_DEST_DEFAULT_DROP), drop_types,
                       n_drop_types, GDK_ACTION_COPY);
    gtk_signal_connect (GTK_OBJECT (window), "drag_data_received",
                        GTK_SIGNAL_FUNC (dnd_drop), 0);
}

static void
dnd_drop (GtkWidget * widget, GdkDragContext * context, gint x, gint y,
          GtkSelectionData * selection_data, guint info, guint time,
          gpointer data)
{
    GList *names, *list;
    gchar *string;
    struct stat st;

    if (info == TARGET_URI_LIST) {
        list =
            gnome_uri_list_extract_filenames ((gchar *) selection_data->data);
        if (uri_list_drag_recieved_dialog (list) == 0) {
            for (names = list; names; names = names->next) {
                string = (gchar *) names->data;
                stat (string, &st);
                if (S_ISREG (st.st_mode)) {
                    if (check_if_file_exists (string)) {
                        open_file_real ((gchar *) names->data);
                    } else {
                        read_error (string);
                    }
                } else {
                    GList *temp_list;

                    temp_list = drop_directory ((gchar *) names->data, NULL);
                    for (; temp_list; temp_list = temp_list->next) {
                        gchar *string;

                        string = (gchar *) temp_list->data;
                        if (check_if_file_exists (string)) {
                            open_file_real (string);
                        } else {
                            read_error (string);
                        }
                    }
                    g_list_delete_all (temp_list);
                }
            }
        }
        gnome_uri_list_free_strings (list);
    }
}

static gint
uri_list_drag_recieved_dialog (GList * list)
{
    GtkWidget *error_window;
    GnomeDialog *dialog;
    GtkWidget *pixmap;
    GtkWidget *box;
    gchar *name;
    GtkWidget *label;
    gchar *line;
    gint result;
    GList *temp;

    error_window =
        gnome_dialog_new (_("URI List Received!"), GNOME_STOCK_BUTTON_YES,
                          GNOME_STOCK_BUTTON_NO, NULL);
    dialog = GNOME_DIALOG (error_window);

    box = gtk_vbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX (dialog->vbox), box, FALSE, FALSE, 0);
    gtk_widget_show (box);

    name = gnome_pixmap_file ("gnome-question.png");
    if (name) {
        pixmap = gnome_pixmap_new_from_file (name);
        gtk_box_pack_start (GTK_BOX (box), pixmap, FALSE, FALSE, 10);
        gtk_widget_show (pixmap);
    }

    line = _("The following items have been dropped into Glimmer:");
    label = gtk_label_new (line);
    gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
    gtk_box_pack_start (GTK_BOX (box), label, FALSE, FALSE, 5);
    gtk_widget_show (label);

    for (temp = list; temp; temp = temp->next) {
        line = (gchar *) temp->data;
        label = gtk_label_new (line);
        gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
        gtk_box_pack_start (GTK_BOX (box), label, FALSE, FALSE, 5);
        gtk_widget_show (label);
    }

    line =
        (g_list_length (list) >
         1) ? _("\nWould you like to accept these items?") :
        _("Would you like to accept this item?");
    label = gtk_label_new (line);
    gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
    gtk_box_pack_start (GTK_BOX (box), label, FALSE, FALSE, 5);
    gtk_widget_show (label);

    gnome_dialog_set_default (dialog, 0);
    gnome_dialog_set_parent (dialog, GTK_WINDOW (window));
    result = gnome_dialog_run_and_close (dialog);
    return (result);
}

static GList *
drop_directory (gchar * directory, GList * files)
{
    DIR *dir_file;
    struct dirent *dir;
    struct stat st;
    gchar *filename = NULL;
    GList *files_list = NULL;

    if ((dir_file = opendir (directory)) != NULL) {
        while ((dir = readdir (dir_file))) {
            if (!strcmp (dir->d_name, ".") || !strcmp (dir->d_name, ".."))
                continue;
            filename = g_strconcat (directory, "/", dir->d_name, NULL);
            stat (filename, &st);
            if (S_ISDIR (st.st_mode) && !recursive_open (filename)) {
                files_list = drop_directory (filename, files_list);
                g_free (filename);
            } else if (S_ISREG (st.st_mode)) {
                files_list = g_list_prepend (files_list, (gpointer) filename);
            }
        }
        closedir (dir_file);
    } else {
        generic_dialog_with_text (_("Unable to read directory listing!"));
    }

    return (files_list);
}

static gint
recursive_open (gchar * dir)
{
    GtkWidget *error_window;
    GnomeDialog *dialog;
    GtkWidget *pixmap;
    GtkWidget *box;
    gchar *name;
    GtkWidget *label;
    gchar *line;
    gint result;

    error_window =
        gnome_dialog_new (_("URI List Received!"), GNOME_STOCK_BUTTON_YES,
                          GNOME_STOCK_BUTTON_NO, NULL);
    dialog = GNOME_DIALOG (error_window);

    box = gtk_vbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX (dialog->vbox), box, FALSE, FALSE, 0);
    gtk_widget_show (box);

    name = gnome_pixmap_file ("gnome-question.png");
    if (name) {
        pixmap = gnome_pixmap_new_from_file (name);
        gtk_box_pack_start (GTK_BOX (box), pixmap, FALSE, FALSE, 10);
        gtk_widget_show (pixmap);
    }

    line = g_strconcat (_("Would you like to open "), dir, NULL);
    label = gtk_label_new (line);
    gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
    gtk_box_pack_start (GTK_BOX (box), label, FALSE, FALSE, 5);
    gtk_widget_show (label);

    gnome_dialog_set_default (dialog, 0);
    gnome_dialog_set_parent (dialog, GTK_WINDOW (window));
    result = gnome_dialog_run_and_close (dialog);
    return (result);
}
