/*
  File autogenerated by gengetopt version 2.6  
  generated with the following command:
  gengetopt --input=../tools/gliv.ggo --unamed-opts 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
/* Check for configure's getopt check result.  */
#ifndef HAVE_GETOPT_LONG
#include "getopt.h"
#else
#include <getopt.h>
#endif

#ifndef HAVE_STRDUP
#define strdup gengetopt_strdup
#endif /* HAVE_STRDUP */

#include "cmdline.h"


void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n", PACKAGE, VERSION);
}

void
cmdline_parser_print_help (void)
{
  cmdline_parser_print_version ();
  printf("\n"
"Usage: %s [OPTIONS]... [FILES]...\n", PACKAGE);
  printf("   -h      --help           Print help and exit\n");
  printf("   -V      --version        Print version and exit\n");
  printf("   -f      --full-screen    Start in full screen mode (default=off)\n");
  printf("   -s      --shuffle        Show images in random order (default=off)\n");
  printf("   -R      --recursive      Process directories recursively (default=off)\n");
  printf("   -i      --info           Show infos about displayed image (default=on)\n");
  printf("   -l      --scale-down     Reduce the image to the window (default=off)\n");
  printf("   -M      --maximize       Maximize the image to the window (default=off)\n");
  printf("   -m      --make-fit       Make the image fit the window (default=off)\n");
  printf("   -dINT   --delay=INT      Delay before hiding the cursor\n");
  printf("   -b      --menu           Display the menu bar (default=on)\n");
  printf("   -z      --zoom-pointer   Zoom centered on pointer (default=off)\n");
  printf("   -g      --glivrc         Load ~/.glivrc (default=on)\n");
  printf("   -c      --alpha-checks   Alpha checks in the background (default=on)\n");
  printf("   -uINT   --history=INT    Length of history\n");
  printf("   -t      --dither         Enable dithering (default=off)\n");
  printf("   -F      --force-load     Try to load every file (default=off)\n");
  printf("   -e      --build-menus    Build images menu at startup (default=on)\n");
}


/* gengetopt_strdup(): automatically generated from strdup.c. */
/* strdup.c replacement of strdup, which is not standard */
static char *
gengetopt_strdup (const char *s)
{
  char *result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  int c;	/* Character of the parsed option.  */
  int missing_required_options = 0;	

  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->full_screen_given = 0 ;
  args_info->shuffle_given = 0 ;
  args_info->recursive_given = 0 ;
  args_info->info_given = 0 ;
  args_info->scale_down_given = 0 ;
  args_info->maximize_given = 0 ;
  args_info->make_fit_given = 0 ;
  args_info->delay_given = 0 ;
  args_info->menu_given = 0 ;
  args_info->zoom_pointer_given = 0 ;
  args_info->glivrc_given = 0 ;
  args_info->alpha_checks_given = 0 ;
  args_info->history_given = 0 ;
  args_info->dither_given = 0 ;
  args_info->force_load_given = 0 ;
  args_info->build_menus_given = 0 ;
#define clear_args() { \
  args_info->full_screen_flag = 0;\
  args_info->shuffle_flag = 0;\
  args_info->recursive_flag = 0;\
  args_info->info_flag = 1;\
  args_info->scale_down_flag = 0;\
  args_info->maximize_flag = 0;\
  args_info->make_fit_flag = 0;\
  args_info->menu_flag = 1;\
  args_info->zoom_pointer_flag = 0;\
  args_info->glivrc_flag = 1;\
  args_info->alpha_checks_flag = 1;\
  args_info->dither_flag = 0;\
  args_info->force_load_flag = 0;\
  args_info->build_menus_flag = 1;\
}

  clear_args();

  args_info->inputs = NULL;
  args_info->inputs_num = 0;

  optarg = 0;
  optind = 1;
  opterr = 1;
  optopt = '?';

  while (1)
    {
      int option_index = 0;
      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "full-screen",	0, NULL, 'f' },
        { "shuffle",	0, NULL, 's' },
        { "recursive",	0, NULL, 'R' },
        { "info",	0, NULL, 'i' },
        { "scale-down",	0, NULL, 'l' },
        { "maximize",	0, NULL, 'M' },
        { "make-fit",	0, NULL, 'm' },
        { "delay",	1, NULL, 'd' },
        { "menu",	0, NULL, 'b' },
        { "zoom-pointer",	0, NULL, 'z' },
        { "glivrc",	0, NULL, 'g' },
        { "alpha-checks",	0, NULL, 'c' },
        { "history",	1, NULL, 'u' },
        { "dither",	0, NULL, 't' },
        { "force-load",	0, NULL, 'F' },
        { "build-menus",	0, NULL, 'e' },
        { NULL,	0, NULL, 0 }
      };

      c = getopt_long (argc, argv, "hVfsRilMmd:bzgcu:tFe", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          clear_args ();
          cmdline_parser_print_help ();
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          clear_args ();
          cmdline_parser_print_version ();
          exit (EXIT_SUCCESS);

        case 'f':	/* Start in full screen mode.  */
          if (args_info->full_screen_given)
            {
              fprintf (stderr, "%s: `--full-screen' (`-f') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->full_screen_given = 1;
          args_info->full_screen_flag = !(args_info->full_screen_flag);
          break;

        case 's':	/* Show images in random order.  */
          if (args_info->shuffle_given)
            {
              fprintf (stderr, "%s: `--shuffle' (`-s') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->shuffle_given = 1;
          args_info->shuffle_flag = !(args_info->shuffle_flag);
          break;

        case 'R':	/* Process directories recursively.  */
          if (args_info->recursive_given)
            {
              fprintf (stderr, "%s: `--recursive' (`-R') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->recursive_given = 1;
          args_info->recursive_flag = !(args_info->recursive_flag);
          break;

        case 'i':	/* Show infos about displayed image.  */
          if (args_info->info_given)
            {
              fprintf (stderr, "%s: `--info' (`-i') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->info_given = 1;
          args_info->info_flag = !(args_info->info_flag);
          break;

        case 'l':	/* Reduce the image to the window.  */
          if (args_info->scale_down_given)
            {
              fprintf (stderr, "%s: `--scale-down' (`-l') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->scale_down_given = 1;
          args_info->scale_down_flag = !(args_info->scale_down_flag);
          break;

        case 'M':	/* Maximize the image to the window.  */
          if (args_info->maximize_given)
            {
              fprintf (stderr, "%s: `--maximize' (`-M') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->maximize_given = 1;
          args_info->maximize_flag = !(args_info->maximize_flag);
          break;

        case 'm':	/* Make the image fit the window.  */
          if (args_info->make_fit_given)
            {
              fprintf (stderr, "%s: `--make-fit' (`-m') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->make_fit_given = 1;
          args_info->make_fit_flag = !(args_info->make_fit_flag);
          break;

        case 'd':	/* Delay before hiding the cursor.  */
          if (args_info->delay_given)
            {
              fprintf (stderr, "%s: `--delay' (`-d') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->delay_given = 1;
          args_info->delay_arg = atoi (optarg);
          break;

        case 'b':	/* Display the menu bar.  */
          if (args_info->menu_given)
            {
              fprintf (stderr, "%s: `--menu' (`-b') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->menu_given = 1;
          args_info->menu_flag = !(args_info->menu_flag);
          break;

        case 'z':	/* Zoom centered on pointer.  */
          if (args_info->zoom_pointer_given)
            {
              fprintf (stderr, "%s: `--zoom-pointer' (`-z') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->zoom_pointer_given = 1;
          args_info->zoom_pointer_flag = !(args_info->zoom_pointer_flag);
          break;

        case 'g':	/* Load ~/.glivrc.  */
          if (args_info->glivrc_given)
            {
              fprintf (stderr, "%s: `--glivrc' (`-g') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->glivrc_given = 1;
          args_info->glivrc_flag = !(args_info->glivrc_flag);
          break;

        case 'c':	/* Alpha checks in the background.  */
          if (args_info->alpha_checks_given)
            {
              fprintf (stderr, "%s: `--alpha-checks' (`-c') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->alpha_checks_given = 1;
          args_info->alpha_checks_flag = !(args_info->alpha_checks_flag);
          break;

        case 'u':	/* Length of history.  */
          if (args_info->history_given)
            {
              fprintf (stderr, "%s: `--history' (`-u') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->history_given = 1;
          args_info->history_arg = atoi (optarg);
          break;

        case 't':	/* Enable dithering.  */
          if (args_info->dither_given)
            {
              fprintf (stderr, "%s: `--dither' (`-t') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->dither_given = 1;
          args_info->dither_flag = !(args_info->dither_flag);
          break;

        case 'F':	/* Try to load every file.  */
          if (args_info->force_load_given)
            {
              fprintf (stderr, "%s: `--force-load' (`-F') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->force_load_given = 1;
          args_info->force_load_flag = !(args_info->force_load_flag);
          break;

        case 'e':	/* Build images menu at startup.  */
          if (args_info->build_menus_given)
            {
              fprintf (stderr, "%s: `--build-menus' (`-e') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->build_menus_given = 1;
          args_info->build_menus_flag = !(args_info->build_menus_flag);
          break;

        case 0:	/* Long option with no short option */

        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          exit (EXIT_FAILURE);

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c\n", PACKAGE, c);
          abort ();
        } /* switch */
    } /* while */

  if ( missing_required_options )
    exit (EXIT_FAILURE);

  if (optind < argc)
    {
      int i = 0 ;

      args_info->inputs_num = argc - optind ;
      args_info->inputs = 
        (char **)(malloc ((args_info->inputs_num)*sizeof(char *))) ;
      while (optind < argc)
        args_info->inputs[ i++ ] = strdup (argv[optind++]) ; 
    }

  return 0;
}
