/* Faster but has to be undefined when debugging. */
#define G_DISABLE_CAST_CHECKS
#define GTK_NO_CHECK_CASTS

#include <gtk/gtk.h>

#ifdef HAVE_CONFIG_H
#include "../config.h"
#endif

#ifdef ENABLE_NLS
#include <libintl.h>
#define _(str) (gettext((str)))
#else
#define _(str) (str)
#endif

/*
 * Just to mark constant translatable strings, like in rcfile.c.
 * See po/update_po.sh.
 */
#define N_(str) (str)

#ifndef GTK2
#include <gdk-pixbuf/gdk-pixbuf.h>
#include "gtk2_compat.h"
#endif

/* User configurable settings. */

#define ZOOM_FACTOR 1.1
#define MOVE_OFFSET 20.0

#ifdef GTK2
#define FONT "courier Medium 12"
#else
#define FONT "-misc-fixed-medium-r-normal-*-13-*-*-*-*-70-*-*"
#endif

/* End of user configurable settings. */

/* Instead of finding it in a system or glib header. */
#define PI 3.14159265358979323846

/* Loader according to filename extension. */
typedef enum {
    LOADER_NONE,                /* Unrecognized file. */
    LOADER_PIXBUF,              /* Fastest. */
    LOADER_MAGICK_ONE,          /* One file -> one image. */
    LOADER_MAGICK_MANY          /* Possibly many images a file -> tiling. */
} loader;

#ifdef GTK2
#define LOADER_PIXBUF_OR_MAGICK_ONE  LOADER_PIXBUF
#define LOADER_PIXBUF_OR_MAGICK_MANY LOADER_PIXBUF
#define LOADER_PIXBUF_OR_NOTHING     LOADER_PIXBUF
#else
#define LOADER_PIXBUF_OR_MAGICK_ONE  LOADER_MAGICK_ONE
#define LOADER_PIXBUF_OR_MAGICK_MANY LOADER_MAGICK_MANY
#define LOADER_PIXBUF_OR_NOTHING     LOADER_NONE
#endif

/* Bits for the refresh() function. */
#define REFRESH_IMAGE  (1 << 0)
#define REFRESH_NOW    (1 << 1)
#define REFRESH_STATUS (1 << 2)
#define APPEND_HISTORY (1 << 3)

/* Convenient macro. */
#define DOUBLE_EQUAL(a, b) (((a) - (b)) * ((a) - (b)) <= \
                            4 * DBL_EPSILON * DBL_EPSILON)

/* A little incompatibility. */
#ifdef GTK2
#define GDK_PIXBUF_LOAD(fname) gdk_pixbuf_new_from_file(fname, NULL)
#else
#define GDK_PIXBUF_LOAD(fname) gdk_pixbuf_new_from_file(fname)
#endif

/* Infos that can be freed once the image is loaded. */
typedef struct {
    /* Tiles parameters. */
    guint x_tiles;
    guint y_tiles;
    guint x_edge;
    guint y_edge;
    guint x_left;
    guint y_left;

    /* Original image. */
    GdkPixbuf *im;
} loading_data;

typedef struct {
    gdouble x0;
    gdouble y0;
    gdouble x1;
    gdouble y1;
} tile_dim;

/* The gliv_image structure. */
typedef struct {
    guint number;
    gchar *ident;
    gint width;
    gint height;
    guint nb_tiles;
    tile_dim *tiles;
    guint *tex_ids;
    guint list;
    gboolean has_alpha;
    loading_data *init;
} gliv_image;

/* Options controlled by the user. */
typedef struct {
    gboolean fullscreen;
    gboolean maximize;
    gboolean scaledown;
    gboolean menu_bar;
    gboolean status_bar;
    gboolean zoom_pointer;
    gboolean alpha_checks;
    gboolean dither;
    gboolean force;
    gboolean build_menus;
    gint delay;
    gint history_size;
    gint bg_col[3];
    gint alpha1[3];
    gint alpha2[3];
} options_struct;

/* Some global flags and variables. */
typedef struct {
    gboolean cursor_hidden;
    gboolean help;
    gboolean alpha_checks_changed;
    gboolean filtering_enabled;
    guint max_texture_size;
    GtkAllocation *wid_size;
    gint scr_width;
    gint scr_height;
} rt_struct;

/* callbacks.c */
void install_callbacks(gpointer object);

/* file_array.c */
gchar *get_file_name_by_id(guint id);
void file_array_remove(guint id);
G_GNUC_PURE guint array_length(void);
gchar **get_file_list_sorted(guint begin, guint num);
void init_list(gchar ** files, guint num, gboolean recursive, gboolean shuffle);
void place_at_position(gchar * filename, gint position);
void insert_after_current_position(gchar ** filename, guint nb,
                                   gboolean shuffle);

/* formats.c */
GdkPixbuf *file_to_pixbuf(gchar * filename);
gboolean extension_is_ok(gchar * file);

/* gl_widget.c */
void update_bg_color(gboolean do_gl);
gboolean toggle_cursor(gboolean visible);
void schedule_hide_cursor(void);
void create_gl_widget(void);

/* gliv.c */
gchar *add_mnemonic(gchar * str);
gchar *locale_to_utf8(gchar * str);

/* help.c */
gboolean toggle_help(void);
void show_about_box(void);

/* history.c */
void init_history(void);
void append_history(void);
void undo(void);
void redo(void);
void clear_history(void);

#ifdef MAGICK_CONVERT
/* imagemagick.c */
GdkPixbuf *load_with_imagemagick(gchar * filename, gboolean tile);
void image_magick_finish(void);
#endif

/* images_menu.c */
void rebuild_directories(GtkMenuItem * root);
void rebuild_images(GtkMenuItem * root);
void rebuild_images_menu(void);

/* loading.c */
void fill_ident(gliv_image * im);
void open_next_image(void);
void load_direction(gint8 dir);
void load_first_image(void);
void load_second_image(void);
void open_file(gchar * filename, gboolean add_dir, gboolean shuffle_flag);
void reload_all_images(void);
void menu_load(gchar * filename);

/* matrix.c */
G_GNUC_PURE gdouble get_matrix_zoom(void);
G_GNUC_PURE gdouble get_matrix_angle(void);
void write_gl_matrix(void);
void matrix_cpy(gdouble * dest, gdouble * src);
G_GNUC_PURE gboolean matrix_tile_visible(tile_dim * tile);
G_GNUC_PURE gboolean is_matrix_symmetry(void);
G_GNUC_PURE gboolean get_matrix_has_changed(void);
G_GNUC_PURE gboolean is_filtering_needed(void);
gboolean matrix_set_max_zoom(gint width, gint height, gboolean do_it);
void matrix_reset(void);
void matrix_rotate(gdouble angle);
void matrix_move(gdouble x, gdouble y);
void matrix_zoom(gdouble ratio, gdouble x, gdouble y);
void matrix_flip_h(void);
void matrix_flip_v(void);

/* menus.c */
#ifndef GTK2
void intercept_events(gboolean intercepted);
#endif
GtkAccelGroup *create_menus(void);

/* move_pointer.c */
void move_pointer(gint dest_x, gint dest_y);

/* open_dialog.c */
void show_open_dialog_first(void);
gboolean menu_open(void);

/* options.c */
void show_options(void);

/* rcfile.c */
options_struct *load_rc(gboolean from_file);
void save_rc(options_struct * opt);

/* rendering.c */
void render(void);
void zoom_in(gdouble ratio);
void refresh(guint what);

/* textures.c */
void prioritize_textures(gliv_image * im, gboolean is_prio);
void create_display_list(gliv_image * im);

/* windows.c */
void show_dialog(GtkWidget * widget, gchar * name, gboolean unused_with_gtk2);
void set_loading_entry(gchar * filename);
void toggle_status_bar(void);
void toggle_menu_bar(void);
void update_status_bar(void);
void create_windows(void);
void goto_window(void);
void toggle_fullscreen(gboolean enable);

/* zoom_frame.c */
void draw_zoom_frame(gboolean draw);
void set_zoom_frame(gint x, gint y, gint width, gint height);
void clear_zoom_frame(void);
void zoom_frame(void);
