/* sample.c */

#include <stdio.h>
#include <stdlib.h>
#include "glpk.h"

int main(void)
{     LPI *lp;
      double Z, x1, x2, x3;

s1:   lp = glp_create_prob("sample");

s2:   glp_new_col(lp, "x1"), glp_set_obj_coef(lp, 1, 10.0);
s3:   glp_new_col(lp, "x2"), glp_set_obj_coef(lp, 2, 6.0);
s4:   glp_new_col(lp, "x3"), glp_set_obj_coef(lp, 3, 4.0);

s5:   glp_new_row(lp, "p");
s6:   glp_set_row_bnds(lp, 1, 'U', 0.0, 100.0);
s7:   glp_new_aij(lp, 1, 1, 1.0);
s8:   glp_new_aij(lp, 1, 2, 1.0);
s9:   glp_new_aij(lp, 1, 3, 1.0);

s10:  glp_new_row(lp, "q");
s11:  glp_set_row_bnds(lp, 2, 'U', 0.0, 600.0);
s12:  glp_new_aij(lp, 2, 1, 10.0);
s13:  glp_new_aij(lp, 2, 2, 4.0);
s14:  glp_new_aij(lp, 2, 3, 5.0);

s15:  glp_new_row(lp, "r");
s16:  glp_set_row_bnds(lp, 3, 'U', 0.0, 300.0);
s17:  glp_new_aij(lp, 3, 1, 2.0);
s18:  glp_new_aij(lp, 3, 2, 2.0);
s19:  glp_new_aij(lp, 3, 3, 6.0);

s20:  glp_set_obj_sense(lp, '+');

s21:  glp_simplex2(lp, NULL);

s22:  Z = glp_get_obj_val(lp);
s23:  glp_get_col_soln(lp, 1, NULL, &x1, NULL);
s24:  glp_get_col_soln(lp, 2, NULL, &x2, NULL);
s25:  glp_get_col_soln(lp, 3, NULL, &x3, NULL);

s26:  printf("\nZ = %g; x1 = %g; x2 = %g; x3 = %g\n", Z, x1, x2, x3);

s27:  glp_delete_prob(lp);

      return 0;
}

/* eof */
