/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include <gtk/gtk.h>

#include "gtkloupe.h"


enum {
  LAST_SIGNAL
};

enum {
  PROP_0,
};

static void gtk_loupe_class_init (GtkLoupeClass  *klass);
static void gtk_loupe_init       (GtkLoupe       *loupe);
static void gtk_loupe_dispose    (GObject        *object);

static gboolean gtk_loupe_expose (GtkWidget      *widget,
				  GdkEventExpose *event);

static void gdk_rectangle_clamp (GdkRectangle *src1,
				 GdkRectangle *src2,
				 GdkRectangle *dest);
#if 0
static void gdk_image_magnify   (GdkImage *dest,
				 GdkImage *src,
				 gint      h_mag,
				 gint      v_mag);
#endif


static GtkDrawingAreaClass *parent_class = NULL;
#if 0
static guint loupe_signals[LAST_SIGNAL] = { 0 };
#endif


GType
gtk_loupe_get_type (void)
{
  static GType loupe_type = 0;

  if (!loupe_type)
    {
      static const GTypeInfo loupe_info =
      {
	sizeof (GtkLoupeClass),
	NULL,		/* base_init */
	NULL,		/* base_finalize */
	(GClassInitFunc) gtk_loupe_class_init,
	NULL,		/* class_finalize */
	NULL,		/* class_data */
	sizeof (GtkLoupe),
	0,		/* n_preallocs */
	(GInstanceInitFunc) gtk_loupe_init,
        NULL,           /* value_table */
      };

      loupe_type
	= g_type_register_static (GTK_TYPE_DRAWING_AREA,
				  "GtkLoupe",
				  &loupe_info, 0);
    }

  return loupe_type;
}

static void
gtk_loupe_class_init (GtkLoupeClass *klass)
{
  GObjectClass   *gobject_class;
  GtkObjectClass *object_class;
  GtkWidgetClass *widget_class;
  GtkLoupeClass  *loupe_class;


  gobject_class = G_OBJECT_CLASS (klass);
  object_class = (GtkObjectClass*) klass;
  widget_class = (GtkWidgetClass*) klass;
  loupe_class = (GtkLoupeClass*) klass;

  parent_class = g_type_class_peek_parent (klass);


  gobject_class->dispose = gtk_loupe_dispose;
  widget_class->expose_event = gtk_loupe_expose;
}

static void
gtk_loupe_init (GtkLoupe *loupe)
{
  loupe->h_magnification = 4;
  loupe->v_magnification = 4;

  loupe->timeout_tag = 0;
  loupe->interval = 100;
}

static void
gtk_loupe_dispose (GObject *object)
{
  GtkLoupe *loupe;

  loupe = GTK_LOUPE (object);


  gtk_loupe_stop_auto_update (loupe);


  G_OBJECT_CLASS (parent_class)->dispose (object);
}

GtkWidget*
gtk_loupe_new (void)
{
  return g_object_new (GTK_TYPE_LOUPE, NULL);
}

static gboolean
gtk_loupe_expose (GtkWidget      *widget,
		  GdkEventExpose *event)
{
  GtkLoupe *loupe;
  gint tmp_width;
  gint tmp_height;
  gint root_width;
  gint root_height;

  GdkWindow *gdk_root_window;

  GdkImage *gdk_image;
  GdkImage *magnified_gdk_image;

  
  gint h_mag, v_mag;
  gint ptr_x, ptr_y;
  GdkRectangle root_rect;
  GdkRectangle tmp_rect;


  loupe = GTK_LOUPE (widget);


  h_mag = loupe->h_magnification;
  v_mag = loupe->v_magnification;

  gdk_root_window = gdk_get_default_root_window ();

  gdk_window_get_pointer (gdk_root_window, &ptr_x, &ptr_y, NULL);

  gdk_drawable_get_size (gdk_root_window, &root_width, &root_height);
  root_rect.x = 0;
  root_rect.y = 0;
  root_rect.width  = root_width;
  root_rect.height = root_height;

  tmp_width  = widget->allocation.width;
  tmp_height = widget->allocation.height;
  tmp_rect.width  = ((tmp_width)  / h_mag) + ((tmp_width  % h_mag) ? 1 : 0);
  tmp_rect.height = ((tmp_height) / v_mag) + ((tmp_height % v_mag) ? 1 : 0);
  tmp_rect.x = ptr_x - (tmp_rect.width  / 2);
  tmp_rect.y = ptr_y - (tmp_rect.height / 2);

  gdk_rectangle_clamp (&tmp_rect, &root_rect, &tmp_rect);

#if 0
  gdk_image = gdk_image_get (gdk_root_window,
			     tmp_rect.x, tmp_rect.y,
			     tmp_rect.width, tmp_rect.height);
  magnified_gdk_image = gdk_image_new (GDK_IMAGE_FASTEST,
				       gdk_drawable_get_visual (gdk_root_window),
				       tmp_rect.width  * h_mag,
				       tmp_rect.height * v_mag);

  gdk_image_magnify (magnified_gdk_image,
		     gdk_image,
		     h_mag,
		     v_mag);

  gdk_draw_image (widget->window,
		  widget->style->black_gc,
		  magnified_gdk_image,
		  0, 0, 0, 0,
		  tmp_rect.width  * h_mag,
		  tmp_rect.height * v_mag);

  gdk_image_destroy (magnified_gdk_image);
  gdk_image_destroy (gdk_image);
#else
  {
    GdkPixbuf *gdk_pixbuf;
    GdkPixbuf *scaled_gdk_pixbuf;

    gdk_image = gdk_drawable_get_image (gdk_root_window,
					tmp_rect.x, tmp_rect.y,
					tmp_rect.width, tmp_rect.height);
    
    gdk_pixbuf = gdk_pixbuf_get_from_image (NULL,
					    gdk_image,
					    NULL,
					    0, 0,
					    0, 0,
					    tmp_rect.width, tmp_rect.height);
    scaled_gdk_pixbuf = gdk_pixbuf_scale_simple (gdk_pixbuf,
						 tmp_rect.width  * h_mag,
						 tmp_rect.height * v_mag,
						 GDK_INTERP_NEAREST);



    gdk_draw_pixbuf (widget->window,
		     widget->style->black_gc,
		     scaled_gdk_pixbuf,
		     0, 0, 0, 0,
		     tmp_rect.width  * h_mag,
		     tmp_rect.height * v_mag,
		     GDK_RGB_DITHER_NONE,
		     0, 0);

    g_object_unref (gdk_image);
    g_object_unref (gdk_pixbuf);
    g_object_unref (scaled_gdk_pixbuf);
  }
#endif


  return FALSE;
}



static gboolean
timeout_handler (gpointer data)
{
  GtkLoupe *loupe;

  loupe = GTK_LOUPE (data);

  gtk_widget_queue_draw (GTK_WIDGET (loupe));

  return TRUE;
}


void
gtk_loupe_set_magnification (GtkLoupe *loupe,
			     gint      h_magnification,
			     gint      v_magnification)
{
  g_return_if_fail (loupe != NULL);
  g_return_if_fail (GTK_IS_LOUPE (loupe));
  g_return_if_fail (h_magnification > 0);
  g_return_if_fail (v_magnification > 0);

  if ((loupe->h_magnification != h_magnification) ||
      (loupe->v_magnification != v_magnification))
    {
      loupe->h_magnification = h_magnification;
      loupe->v_magnification = v_magnification;
    }
}

void
gtk_loupe_start_auto_update (GtkLoupe *loupe)
{
  g_return_if_fail (loupe != NULL);
  g_return_if_fail (GTK_IS_LOUPE (loupe));


  if (loupe->timeout_tag == 0)
    {
      loupe->timeout_tag
	= g_timeout_add (loupe->interval,
			 (GSourceFunc)timeout_handler,
			 loupe);
    }
}

void
gtk_loupe_stop_auto_update (GtkLoupe *loupe)
{
  g_return_if_fail (loupe != NULL);
  g_return_if_fail (GTK_IS_LOUPE (loupe));


  if (loupe->timeout_tag != 0)
    {
      g_source_remove (loupe->timeout_tag);
      loupe->timeout_tag = 0;
    }
}


static void
gdk_rectangle_clamp (GdkRectangle *src1,
		     GdkRectangle *src2,
		     GdkRectangle *dest)
{
  GdkRectangle tmp;

  tmp.x = (src1->width  < src2->width)
            ? CLAMP (src1->x, src2->x, (src2->x + src2->width  - src1->width))
            : src2->x;
  tmp.y = (src1->height < src2->height)
            ? CLAMP (src1->y, src2->y, (src2->y + src2->height - src1->height))
            : src2->y;
  tmp.width  = MIN (src1->width,  src2->width);
  tmp.height = MIN (src1->height, src2->height);

  dest->x = tmp.x;
  dest->y = tmp.y;
  dest->width  = tmp.width;
  dest->height = tmp.height;
}

#if 0
static void
gdk_image_magnify (GdkImage *dest,
		   GdkImage *src,
		   gint      h_mag,
		   gint      v_mag)
{
  gint src_width;
  gint src_height;
  gint i,j;
  gint m,n;
  guint32 pixel;

  src_width  = src->width;
  src_height = src->height;

  for (j = 0; j < src_height; ++j)
    {
      for (i = 0; i < src_width; ++i)
	{
	  pixel = gdk_image_get_pixel(src, i, j);

	  for (m = 0; m < v_mag; ++m)
	    {
	      for (n = 0; n < h_mag; ++n)
		{
		  gdk_image_put_pixel (dest,
				       (i * h_mag + n),
				       (j * v_mag + m),
				       pixel);
		}
	    }
	}
    }
}
#endif
