/* This file is part of GMetaDOM
 * a generic bind package for the Document Object Model API.
 * Copyright (C) 2001-2002 Luca Padovani <luca.padovani@cs.unibo.it>
 *               2002 Claudio Sacerdoti Coen <sacerdot@cs.unibo.it>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For more information, please visit the project home page
 * http://gmetadom.sourceforge.net
 * or send an email to <luca.padovani@cs.unibo.it>
 */

#include <assert.h>
#include <gdome.h>

#include <gdome-events.h>

#include <caml/memory.h>
#include <caml/custom.h>
#include "mlgdomevalue.h"

static void
ml_gdome_evntl_callback(GdomeEventListener* self, GdomeEvent* event, GdomeException* exc)
{
  GdomeMutationEvent* mevnt;

  g_return_if_fail(self != NULL);
  g_return_if_fail(event != NULL);
  g_return_if_fail(exc != NULL);
  g_return_if_fail(self->user_data != NULL);

  mevnt = gdome_cast_mevnt(event);
  g_return_if_fail(mevnt != NULL);

  /* we don't care about exception because the Ocaml mechanism
   * is exactly what we want
   */
  callback(*((value**) (self->user_data)), Val_MutationEvent(mevnt));
}

static void
ml_gdome_evntl_finalize(value v)
{
  GdomeException exc_;
  GdomeEventListener* obj_ = EventListener_val(v);
  g_assert(obj_ != NULL);
  g_assert(obj_->user_data != NULL);
  remove_global_root(obj_->user_data);
  g_free(obj_->user_data);
  gdome_evntl_unref(obj_, &exc_);
  assert(exc_ == 0);
}

value
ml_gdome_evntl_create(value callback)
{
  CAMLparam1(callback);

  static struct custom_operations ops = {
    "http://gmetadom.sourceforge.net/gdome_caml/events/EventListener",
    ml_gdome_evntl_finalize,
    custom_compare_default,
    custom_hash_default,
    custom_serialize_default,
    custom_deserialize_default
  };
  
  GdomeEventListener* listener;
  value v;
  value* store = g_new(value, 1);

  *store = callback;
  register_global_root(store);
  listener = gdome_evntl_mkref(ml_gdome_evntl_callback, NULL);
  g_assert(listener != NULL);
  listener->user_data = store;
  v = alloc_custom(&ops, sizeof(GdomeEventListener*), 0, 1);
  *((GdomeEventListener**) Data_custom_val(v)) = listener;

  CAMLreturn(v);
}

GdomeEventListener*
EventListener_val(value v)
{
  GdomeEventListener* res_ = *((GdomeEventListener**) Data_custom_val(v));
  g_assert(res_ != NULL);
  return res_;
}

