/* gmpc-metadata-prefetcher.c generated by valac, the Vala compiler
 * generated from gmpc-metadata-prefetcher.vala, do not modify */

/* Gnome Music Player Client (GMPC)
 * Copyright (C) 2004-2010 Qball Cow <qball@sarine.nl>
 * Project homepage: http://gmpc.wikia.com/
 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gtktransition.h>
#include "gmpc-extras.h"
#include <stdlib.h>
#include <string.h>
#include <libmpd/libmpd.h>
#include <libmpd/libmpdclient.h>
#include <metadata.h>
#include <main.h>
#include <gmpc-meta-watcher.h>

#define _meta_data_free0(var) ((var == NULL) ? NULL : (var = (meta_data_free (var), NULL)))
#define _mpd_freeSong0(var) ((var == NULL) ? NULL : (var = (mpd_freeSong (var), NULL)))


static gpointer gmpc_plugin_metadata_prefetcher_parent_class = NULL;

#define use_transition_mpf TRUE
enum  {
	GMPC_PLUGIN_METADATA_PREFETCHER_DUMMY_PROPERTY
};
static gint* gmpc_plugin_metadata_prefetcher_real_get_version (GmpcPluginBase* base, int* result_length1);
static const char* gmpc_plugin_metadata_prefetcher_real_get_name (GmpcPluginBase* base);
static void gmpc_plugin_metadata_prefetcher_status_changed (GmpcPluginMetadataPrefetcher* self, GmpcConnection* gmpcconn, MpdObj* server, ChangedStatusType what);
static void _gmpc_plugin_metadata_prefetcher_status_changed_gmpc_connection_status_changed (GmpcConnection* _sender, MpdObj* mi, ChangedStatusType what, gpointer self);
static GObject * gmpc_plugin_metadata_prefetcher_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);



static gint* gmpc_plugin_metadata_prefetcher_real_get_version (GmpcPluginBase* base, int* result_length1) {
	GmpcPluginMetadataPrefetcher * self;
	gint* result;
	gint* _tmp0_;
	self = (GmpcPluginMetadataPrefetcher*) base;
	result = (_tmp0_ = GMPC_PLUGIN_METADATA_PREFETCHER_version, *result_length1 = G_N_ELEMENTS (GMPC_PLUGIN_METADATA_PREFETCHER_version), _tmp0_);
	return result;
}


static const char* gmpc_plugin_metadata_prefetcher_real_get_name (GmpcPluginBase* base) {
	GmpcPluginMetadataPrefetcher * self;
	const char* result;
	self = (GmpcPluginMetadataPrefetcher*) base;
	result = "Metadata pre-fetcher";
	return result;
}


static void gmpc_plugin_metadata_prefetcher_status_changed (GmpcPluginMetadataPrefetcher* self, GmpcConnection* gmpcconn, MpdObj* server, ChangedStatusType what) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (gmpcconn != NULL);
	g_return_if_fail (server != NULL);
	if (!gmpc_plugin_base_get_enabled ((GmpcPluginBase*) self)) {
		return;
	}
	if ((what & MPD_CST_NEXTSONG) == MPD_CST_NEXTSONG) {
		gint next_song_id;
		next_song_id = mpd_player_get_next_song_id (server);
		if (next_song_id > 0) {
			mpd_Song* song;
			song = mpd_playlist_get_song (server, next_song_id);
			if (song != NULL) {
				MetaData* met;
				MetaDataResult md_result = 0;
				MetaData* _tmp2_;
				MetaDataResult _tmp1_;
				MetaData* _tmp0_ = NULL;
				MetaData* _tmp5_;
				MetaDataResult _tmp4_;
				MetaData* _tmp3_ = NULL;
				met = NULL;
				g_log ("MetadataPrefetcher", G_LOG_LEVEL_DEBUG, "gmpc-metadata-prefetcher.vala:58: Pre-fetching %s", song->file);
				md_result = (_tmp1_ = gmpc_meta_watcher_get_meta_path (gmw, song, META_ARTIST_ART, &_tmp0_), met = (_tmp2_ = _tmp0_, _meta_data_free0 (met), _tmp2_), _tmp1_);
				md_result = (_tmp4_ = gmpc_meta_watcher_get_meta_path (gmw, song, META_ALBUM_ART, &_tmp3_), met = (_tmp5_ = _tmp3_, _meta_data_free0 (met), _tmp5_), _tmp4_);
				_meta_data_free0 (met);
			}
			_mpd_freeSong0 (song);
		}
	}
}


GmpcPluginMetadataPrefetcher* gmpc_plugin_metadata_prefetcher_construct (GType object_type) {
	GmpcPluginMetadataPrefetcher * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


GmpcPluginMetadataPrefetcher* gmpc_plugin_metadata_prefetcher_new (void) {
	return gmpc_plugin_metadata_prefetcher_construct (GMPC_PLUGIN_TYPE_METADATA_PREFETCHER);
}


static void _gmpc_plugin_metadata_prefetcher_status_changed_gmpc_connection_status_changed (GmpcConnection* _sender, MpdObj* mi, ChangedStatusType what, gpointer self) {
	gmpc_plugin_metadata_prefetcher_status_changed (self, _sender, mi, what);
}


static GObject * gmpc_plugin_metadata_prefetcher_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GmpcPluginMetadataPrefetcher * self;
	parent_class = G_OBJECT_CLASS (gmpc_plugin_metadata_prefetcher_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GMPC_PLUGIN_METADATA_PREFETCHER (obj);
	{
		((GmpcPluginBase*) self)->plugin_type = 8 + 4;
		g_signal_connect_object (gmpcconn, "status-changed", (GCallback) _gmpc_plugin_metadata_prefetcher_status_changed_gmpc_connection_status_changed, self, 0);
	}
	return obj;
}


static void gmpc_plugin_metadata_prefetcher_class_init (GmpcPluginMetadataPrefetcherClass * klass) {
	gmpc_plugin_metadata_prefetcher_parent_class = g_type_class_peek_parent (klass);
	GMPC_PLUGIN_BASE_CLASS (klass)->get_version = gmpc_plugin_metadata_prefetcher_real_get_version;
	GMPC_PLUGIN_BASE_CLASS (klass)->get_name = gmpc_plugin_metadata_prefetcher_real_get_name;
	G_OBJECT_CLASS (klass)->constructor = gmpc_plugin_metadata_prefetcher_constructor;
}


static void gmpc_plugin_metadata_prefetcher_instance_init (GmpcPluginMetadataPrefetcher * self) {
}


GType gmpc_plugin_metadata_prefetcher_get_type (void) {
	static GType gmpc_plugin_metadata_prefetcher_type_id = 0;
	if (gmpc_plugin_metadata_prefetcher_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GmpcPluginMetadataPrefetcherClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gmpc_plugin_metadata_prefetcher_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GmpcPluginMetadataPrefetcher), 0, (GInstanceInitFunc) gmpc_plugin_metadata_prefetcher_instance_init, NULL };
		gmpc_plugin_metadata_prefetcher_type_id = g_type_register_static (GMPC_PLUGIN_TYPE_BASE, "GmpcPluginMetadataPrefetcher", &g_define_type_info, 0);
	}
	return gmpc_plugin_metadata_prefetcher_type_id;
}




