.TH PSCONTOUR l "18 Apr 2001"
.SH NAME
pscontour \- Contour xyz-data by direct triangulation
.SH SYNOPSIS
\fBpscontour\fP \fIxyzfile\fP \fB\-C\fP\fIcptfile\fP \fB\-J\fP\fIparameters\fP \fB\-R\fP\fIwest/east/south/north\fP[\fBr\fP]
[ \fB\-A\fP[\fB-\fP][\fBf\fP\fIfont_size\fP][\fBa\fP\fIangle\fP][\fI/r/g/b\fP][\fBo\fP]] ] [ \fB\-B\fP\fItickinfo\fP ] [ \fB\-D\fP[\fIdumpfile\fP] ] [ \fB\-E\fP\fIview_az/view_el\fP ]
[ \fB\-G\fP\fIgap\fP ] [ \fB\-H\fP[\fInrec\fP] ] [ \fB\-I\fP ] [ \fB\-K\fP ]
[ \fB\-L\fP\fIpen\fP ] [ \fB\-M\fP[\fIflag\fP] ] [ \fB\-N\fP ] [ \fB\-O\fP ] [ \fB\-P\fP ] [ \fB\-T\fP\fIindexfile\fP ] [ \fB\-U\fP[\fI/dx/dy/\fP][\fIlabel\fP] ]
[ \fB\-V\fP ] [ \fB\-W\fP[\fB+\fP]\fIpen\fP ] [ \fB\-X\fP\fIx-shift\fP ]
[ \fB\-Y\fP\fIy-shift\fP ] [ \fB\-c\fP\fIcopies\fP ] [ \fB\-:\fP ] [ \fB\-bi\fP[\fBs\fP][\fIn\fP] ] [ \fB\-bo\fP[\fBs\fP] ]
.SH DESCRIPTION
\fBpscontour\fP reads an ASCII [or binary] xyz-file and produces a raw contour plot by triangulation. By default, the
optimal Delaunay triangulation is performed (using either Shewhuck's [1996]'
or Watson's [1982] method as selected during GMT installation), but the user'
may optionally provide a second file with
network information, such as a triangular mesh used for finite element modeling. In addition to contours, the area between contours may be painted according to
the color palette file.
.TP
\fIxyzfile\fP
Raw ASCII (or binary, see \fB\-b\fP) xyz data to be contoured.
.TP
.B \-C
name of the color palette file. Must have discrete colors if you want to paint the
surface (\fB\-I\fP). Only contours that have anotation flags set will be anotated.
.TP
.B \-J
Selects the map projection. Scale is UNIT/degree, 1:xxxxx, or width in UNIT (upper case modifier).
UNIT is cm, inch, or m, depending on the MEASURE_UNIT setting in .gmtdefaults, but this can be
overridden on the command line by appending the c, i, or m to the scale/width value.
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jj\fP\fIlon0/scale\fP (Miller)
.br
\fB\-Jm\fP\fIscale\fP (Mercator - Greenwich and Equator as origin)
.br
\fB\-Jm\fP\fIlon0/lat0/scale\fP (Mercator - Give meridian and standard parallel)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator, with Equator as y = 0)
.br
\fB\-Jt\fP\fIlon0/lat0/scale\fP (TM - Transverse Mercator, set origin)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection)
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert).
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant).
.br
\fB\-Jf\fP\fIlon0/lat0/horizon/scale\fP (Gnomonic).
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic).
.br
\fB\-Js\fP\fIlon0/lat0/\fP[\fIslat/\fP]\fIscale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jd\fP\fIlon0/lat0/lat1/lat2/scale\fP (Equidistant)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP[\fBf|s\fP]\fIlon0/scale\fP (Eckert IV (f) and VI (s))
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jv\fP\fIlon0/scale\fP (Van der Grinten)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP[\fBa\fP]\fIscale\fP[\fI/origin\fP] (polar (theta,r) coordinates, optional \fBa\fP for azimuths and offset theta [0])
.br
\fB\-Jx\fP\fIx-scale\fP[\fBl|p\fP\fIpow\fP][\fI/y-scale\fP[\fBl|p\fP\fIpow\fP]] (Linear, log, and power scaling)
.br
More details can be found in the \fBpsbasemap\fP manpages.
.br
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest. To specify boundaries
in degrees and minutes [and seconds], use the dd:mm[:ss] format. Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-A
Several anotation formatting options can be set to modify the form of the annotation. Give - to disable all anotations.
Append f\fIfont_size\fP to change font size [9], append \fI/r/g/b\fP to change color of text fill box
[PAGE_COLOR], append a\fIangle\fP to fix annotation angle [Default follows contour], and append \fBo\fP to draw the outline of the surrounding text box [Default is no outline].
.TP
.B \-B
Sets map boundary tickmark intervals. See \fBpsbasemap\fP for details.
.TP
.B \-D
Dump the (x,y,z) coordinates of each contour to separate files, one for each contour segment. The
files will be named \fIdumpfile_cont_segment[_i]\fP.xyz, where \fIcont\fP is the contour value and
\fIsegment\fP is a running segment number for each contour interval (for closed contours we append _i.)
However, when \fB\-M\fP is used in conjunction with \fB\-D\fP a single multisegment file is created instead.
.TP
.B \-E
Sets the view point by specifying azimuth and elevation in degrees. [Default is 180/90]
.TP
.B \-G
\fIgap\fP is distance between each annotation along the same contour [Default is 10\fBc\fP (or 4\fBi\fP)].
.TP
.B \-H
Input file(s) has Header record(s). Number of header records can be changed by editing
your \.gmtdefaults file. If used, \fBGMT\fP default is 1 header record.
.TP
.B \-I
Color the triangles using the color palette table.
.TP
.B \-K
More \fIPostScript\fP code will be appended later [Default terminates the plot system].
.TP
.B \-L
Draw the underlying triangular mesh using the specified pen attributes [Default is no mesh].
.TP
.B \-M
When used in conjunction with \fB\-D\fP a single multisegment file is created, and
each contour section is preceeded by a header record whose first column is \fIflag\fP
followed by the contour level.
.TP
.B \-N
Do NOT clip contours or image at the boundaries [Defaults will clip to fit inside region \fB\-R\fP).
.TP
.B \-O
Selects Overlay plot mode [Default initializes a new plot system].
.TP
.B \-P
Selects Portrait plotting mode [\fBGMT\fP Default is Landscape, see gmtdefaults to change this].
.TP
.B \-T
Give name of file with network information. Each record must contain triplets of
node numbers for a triangle [Default computes these using Delaunay triangulation (see \fBtriangulate\fP)].
.TP
.B \-U
Draw Unix System time stamp on plot. User may specify where the lower left corner
of the stamp should fall on the page relative to lower left corner of plot. Optionally,
append a label, or \fBc\fP (which will plot the command string.). The GMT parameters
UNIX_TIME and UNIX_TIME_POS can affect the appearance; see the \fBgmtdefaults\fP man
page for details.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-W
Select contouring and set contour pen attributes. If the \fB+\fP flag is set then
the contour lines are colored according to the cpt file (see \fB\-C\fP).
.TP
.B \-X \-Y
Shift origin of plot by (\fIx-shift,y-shift\fP).
Prepend \fBa\fP for absolute coordinates;
the default (\fBr\fP) will reset plot origin.
.TP
.B \-c
Specifies the number of plot copies. [Default is 1]
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input/output. [Default is (longitude,latitude)].
Applies to geographic coordinates only.
.TP
.B \-bi
Selects binary input. Append \fBs\fP for single precision [Default is double].
Append \fIn\fP for the number of columns in the binary file(s).
[Default is 3 input columns].
Use 4-byte integer triplets for node ids (\fB\-T\fP).
.TP
.B \-bo
Selects binary output. Append \fBs\fP for single precision [Default is double].
.SH EXAMPLES
To make a raw contour plot from the file topo.xyz and drawing the contours (pen = 2)
given in the color palette file topo.cpt on a Lambert map
at 0.5 inch/degree along the standard parallels 18 and 24, try
.br
.sp
pscontour topo.xyz \fB\-R\fP320/330/20/30 \fB\-Jl\fP18/24/0.5\fBi\fP \fB\-C\fPtopo.cpt \fB\-W\fP0.5\fBp\fP > topo.ps
.br
.sp
To create a color \fIPostScript\fP plot of the numerical temperature solution obtained on a triangular mesh
whose node coordinates and temperatures are stored in temp.xyz and mesh arrangement is given by the file mesh.ijk, using
the colors in temp.cpt, try
.br
.sp
pscontour temp.xyz \fB\-R\fP0/150/0/100 \fB\-Jx\fP0.1 \fB\-C\fPtemp.cpt \fB\-G \-W\fP0.25\fBp\fP > temp.ps
.SH BUGS
Sometimes there will appear to be thin lines of the wrong color in the image.
This is a round-off problem which may be remedied by using a higher value of
DOTS_PR_INCH in the .gmtdefaults file.
.SH "SEE ALSO"
.IR gmt (l),
.IR grdcontour (l),
.IR grdimage (l),
.IR nearneighbor (l),
.IR psbasemap (l),
.IR psscale (l),
.IR surface (l),
.IR triangulate (l)
.SH REFERENCES
Watson, D. F., 1982, Acord: Automatic contouring of raw data, \fIComp. & Geosci., 8\fP, 97\-101.
.br
Shewchuck, J. R., 1996, Triangle: Engineering a 2D Quality Mesh Generator
and Delaunay Triangulator, First Workshop on Applied Computational Geometry
(Philadelphia, PA), 124-133, ACM, May 1996.
.br
www.cs.cmu.edu/~quake/triangle.html
