------------------------------------------------------------------------------
--  Ada95 Interface to Oracle RDBMS                                         --
--  Copyright (C) 2000-2004 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: oci-thick-connections.ads,v 1.7 2004/06/28 04:57:05 vagul Exp $

with OCI.Environments;
with OCI.Thick.Servers;
package OCI.Thick.Connections is

   use OCI.Thick.Servers;

   type Connection is new Handle_Reference with private;

   function Logon
     (Server_Name : in String;
      User        : in String;
      Password    : in String)
      return      Connection;

   function Logon (Connect : String) return Connection;

   function Logon
     (DB       : in Server;
      User     : in String;
      Password : in String)
      return   Connection;

   procedure Logoff (Connect : in out Connection);

   procedure Set_Blocking (Connect : in out Connection; Mode : in Boolean);

   function Is_Blocking (Connect : in Connection) return Boolean;

   function Server_Version (Connect : in Connection) return String;

   procedure Commit (Connect : in Connection);

   procedure Rollback (Connect : in Connection);

   procedure Break (It : Connection);
   procedure Reset (It : Connection);

   function Get_Connection (Context : OCIExtProcContext) return Connection;
   --  get Connection for extproc callbacks

private

   type Connection is new Handle_Reference with record
      DB          : Server;
      Sessn       : OCISession := OCISession (Empty_Handle);
      Environment : OCI.Environments.Thread_Environment;
   end record;

   procedure Destroy (Object : in out Connection);

end OCI.Thick.Connections;
