------------------------------------------------------------------------------
--  Thin Ada95 binding to OCI (Oracle Call Interface)                    --
--  Copyright (C) 2007 Dmitriy Anisimkov.                                   --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: unsigned_conv_test.adb,v 1.1 2007/04/25 07:34:20 vagul Exp $

--  Example of Unsigned<->OCINumber convertions.

with Ada.Text_IO;

with OCI.Thick.Gen_OCINumber;
with OCI.Thick.Number_Functions;
with GNAT.Float_Control;

with System;

with OCI.Thick.Number_Functions;

procedure Unsigned_Conv_Test is
   use OCI.Thick.Number_Functions;

   type Unsigned_Type is mod System.Max_Binary_Modulus;

   Num : Unsigned_Type := Unsigned_Type'First;
   Num_Range : Unsigned_Type := 1000;

   Num_Pos : Unsigned_Type := 16620333769381873238;

   procedure Test;

   procedure Test is
      function To_Unsigned is
        new OCI.Thick.Gen_OCINumber.Num_To_Unsigned (Unsigned_Type);

      function To_Number is
        new OCI.Thick.Gen_OCINumber.Unsigned_To_Number (Unsigned_Type);

      Numb : OCI.Thick.OCINumber := To_Number (Num);

      Image : constant String := To_String (Numb);

   begin
      if Image'Length > 2
        and then Image (Image'Last - 1 .. Image'Last) = "00"
      then
         Ada.Text_IO.Put_Line (Image & Num'Img);
      end if;

      if To_Unsigned (Numb) /= Num then
         Ada.Text_IO.Put_Line ("Error in " & Image & Num'Img);
         raise Constraint_Error;
      end if;
   end Test;

begin
   loop
      Test;

      if Num = Num_Range then
         Num := Unsigned_Type'Last / 2 - Num_Range / 2;
         GNAT.Float_Control.Reset;

      elsif Num = Unsigned_Type'Last / 2 + Num_Range / 2 then
         Num := Unsigned_Type'Last / 4 * 3  - Num_Range;

      elsif Num = Unsigned_Type'Last / 4 * 3 then
         Num := Num_Pos - Num_Range;

      elsif Num = Num_Pos then
         Num := Unsigned_Type'Last - Num_Range;

      elsif Num = Unsigned_Type'Last then
         exit;

      else
         Num := Num + 1;
      end if;

   end loop;
end Unsigned_Conv_Test;