#include <unistd.h>
#include <netinet/in.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <ctype.h>

#include "gnapster.h"
#include "upload.h"
#include "commands.h"
#include "queue.h"
#include "download.h"

extern UserInfo user_info;
extern GnapsterMain *gmain;

void handle_exec_dl(Transfer *download) {
   char *cmd;
   
   if (!user_info.conf[EXEC_DL_OPTN])
     return;
   
   cmd = d_config_get_string("/gnapster/User/exec_dl");
   
   d_strexp(&cmd, "%s \"%s\"", cmd, download->fpath);
   
   bg_exec(cmd);
   
   d_free(cmd);
}

void retry_download_cb() {
   GtkWidget *clist;
   Transfer *download;
   GList *selection;
   
   clist = gmain->dt->clist;
   
   selection = GTK_CLIST(clist)->selection;
   if (!selection)
     return;

   download = gtk_clist_get_row_data(GTK_CLIST(clist), INT(selection->data));
   if (!download)
     return;
   
   if (download->timeout_tag)
     remote_queue_check(download);
}

int peruser_downloads(char *user) {
   GList *ptr;
   GtkCList *clist;
   GtkCListRow *clist_row;
   Transfer *data;
   int downloads = 0;

   clist = GTK_CLIST(gmain->dt->clist);
   ptr = clist->row_list;
   if (!ptr)
     return -1;
   
   for(; ptr; ptr=ptr->next) {
      clist_row = ptr->data;
      
      data = clist_row->data;
      
      if (!data)
	break;
      
      if (!strcmp(data->user, user))
        downloads++;
   }
   
   return downloads;
}

void handle_download(Transfer *data, unsigned int flags) {
   int downloads;
   
   if (!data)
     return;
   
   downloads = CLIST_LENGTH(gmain->dt->clist);
   
   if (!(flags & DOWNLOAD_FORCE) &&
       user_info.conf[MAX_DOWNLOADS_SWITCH] &&
       downloads >= user_info.conf[MAX_DOWNLOADS]) {
      add_queue(data);
      return;   
   }
   
   if (!(flags & DOWNLOAD_FORCE) &&
       user_info.conf[MAX_PERUSER_DOWNLOADS_SWITCH] &&
       peruser_downloads(data->user) >= user_info.conf[MAX_PERUSER_DOWNLOADS]) {
      add_queue(data);
      return;
   }
   
   show_download(data);
   
   napster_send(data->st->ci->sock, NAPSTER_GET, "%s \"%s\"",
		data->user, data->file);
}

void download_true_cb(GtkWidget *w, void *data) {
   void *temp;
   GList *sel, *selptr = NULL;
   Transfer *download;
   
   if (data)
     LIST_APPEND(selptr, data);
   else {
      for(sel=GTK_CLIST(w)->selection; sel; sel=sel->next) {
	 temp = (GTK_IS_CTREE(w)) ?
	   gtk_ctree_node_get_row_data(GTK_CTREE(w), sel->data) :
	 gtk_clist_get_row_data(GTK_CLIST(w), INT(sel->data));
	 
	 if (!temp)
	   continue;
	 
	 selptr = g_list_append(selptr, temp);
      }
   }

   for(sel=selptr; sel; sel=sel->next) {
      temp = sel->data;
      if (!temp)
	continue;
      
      if (w == gmain->dt->queue_clist) {
	 download = download_dup((Transfer *)temp);
	 handle_download(download, DOWNLOAD_FORCE);
	 
	 gtk_clist_remove(GTK_CLIST(w),
			  gtk_clist_find_row_from_data(GTK_CLIST(w), (Transfer *)temp));
      } else {
	 download = search_dup((Search *)temp, TRANSFER);
	 
	 /* if we're browsing, reconstruct the data */
	 if (w == gmain->bt->ctree)
	   construct_path(w, (Search *)temp, download);
	 
	 handle_download(download, DOWNLOAD_NORMAL);
      }
   }
}

void cancel_download_cb() {
   Transfer *temp;   
   GtkWidget *clist;
   GList *selection, *selptr = NULL;

   clist = gmain->dt->clist;

   selection = GTK_CLIST(clist)->selection;
   if (!selection) 
     return;

   while(selection) {
      temp = gtk_clist_get_row_data(GTK_CLIST(clist), INT(selection->data));

      if (temp)
	selptr = g_list_append(selptr, temp);

      selection = selection->next;
   }

   selection = selptr;
   while(selection) {
      temp = selection->data;
      
      download_close(temp, TRANSFER_CANCEL);
      
      selection = selection->next;
   }
}

void cancel_remove_cb() {
   Transfer *temp;   
   GtkWidget *clist;
   GList *selection, *selptr = NULL;
   
   clist = gmain->dt->clist;

   selection = GTK_CLIST(clist)->selection;
   if (!selection) 
     return;

   while(selection) {
      temp = gtk_clist_get_row_data(GTK_CLIST(clist), INT(selection->data));

      if (temp)
	selptr = g_list_append(selptr, temp);

      selection = selection->next;
   }

   selection = selptr;
   while(selection) {
      temp = selection->data;
      
      download_close(temp, TRANSFER_CANCEL | TRANSFER_FILE_REMOVE);
      
      selection = selection->next;
   }
}

