/******************************************************************************\
 gnofin/common.h   $Revision: 1.3 $
 Copyright (C) 1999-2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#ifndef COMMON_H
#define COMMON_H

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <glib.h>
#include <libgnome/gnome-defs.h>
#include <libgnome/gnome-i18n.h>  /* defines _() and N_() macros */
#include "gnofin-api.h"
#include "trace.h"

#ifndef HAVE_CONFIG_H
# define PACKAGE "gnofin"
# define VERSION "ALPHA"
#endif

#define APPNAME "Gnofin"

/* safety when accessing data through a GList */
#ifdef ENABLE_SAFE_LIST_DEREF
  static inline gboolean
  safe_list_deref (gconstpointer list, const gchar * file, gint lineno)
  { if (list) return TRUE;
    else { g_error ("Attempt to dereference NULL list node\n==> %s(%d)\n", file, lineno); return FALSE; }
  }
# define LIST_DEREF(type,list)  ((type *)(safe_list_deref(list,__FILE__,__LINE__) ? (list)->data : NULL))
#else
# define LIST_DEREF(type,list)  ((type *)((list)->data))
#endif

/* helper macros */
#define sizeof_array(x)  (sizeof(x) / sizeof((x)[0]))

#include <stdio.h>
static inline void d_pause ()
{
  g_print ("Press RETURN to continue\n");
  getchar ();
}

#endif

// vim: ts=8 sw=2
