/** -*- Mode: C++; tab-width: 4 -*-
 * vim: sw=4 ts=4:
 *
 * Gnome Apt helper methods
 *
 * 	(C) 1998 Havoc Pennington <hp@pobox.com>
 * 	    2002-2004 Filip Van Raemdonck <mechanix@debian.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * 	$Id$
 *
 **/

#include <gtk/gtkmessagedialog.h>

#include "cache.h"
#include "gnome-apt.h"
#include "pkgtree.h"
#include "pkgutil.h"

// Chain from Package* to PkgIterator
bool 
Util::installed(pkgCache::Package* p, GAptPkgTree* tree)
{
  g_return_val_if_fail(p != 0, false);
  pkgCache::PkgIterator i(*(tree->cache()), p);
  return installed(i, tree);
}
  
bool 
Util::removed(pkgCache::Package* p, GAptPkgTree* tree)
{
  g_return_val_if_fail(p != 0, false);
  pkgCache::PkgIterator i(*(tree->cache()), p);
  return removed(i, tree);
}
  
bool 
Util::can_change_install(pkgCache::Package* p, GAptPkgTree* tree)
{
  g_return_val_if_fail(p != 0, false);
  pkgCache::PkgIterator i(*(tree->cache()), p);
  return can_change_install(i, tree);
}
  
bool 
Util::can_change_remove(pkgCache::Package* p, GAptPkgTree* tree)
{
  g_return_val_if_fail(p != 0, false);
  pkgCache::PkgIterator i(*(tree->cache()), p);
  return can_change_remove(i, tree);
}

bool
Util::installed(pkgCache::PkgIterator& i, GAptPkgTree* tree)
{
  pkgDepCache::StateCache & state = (*tree->cache())[i];

  return state.Install();
}
  
bool 
Util::removed(pkgCache::PkgIterator& i, GAptPkgTree* tree)
{
  pkgDepCache::StateCache & state = (*tree->cache())[i];

  return state.Delete();
}
  
bool 
Util::can_change_install(pkgCache::PkgIterator& i, GAptPkgTree* tree)
{
  pkgDepCache::StateCache & state = (*tree->cache())[i];
	if (state.CandidateVer == 0) {
		return false;
	}

  // We render the install check if it's not installed and there's
  // something to install, or it's installed but upgradeable.

  if (state.Upgradable()) 
    {
      pkgCache::VerIterator vi = state.CandidateVerIter(*tree->cache());
      if (vi.end()) return false; // nothing to upgrade to

      return true;
    }
  // otherwise
  else
    {
      return false;
    }
}
  
bool 
Util::can_change_remove(pkgCache::PkgIterator& i, GAptPkgTree* tree)
{
	pkgDepCache::StateCache& state = (*tree->cache())[i];
	if (state.CandidateVer == 0) {
		return false;
	}

  // Render if we're installed
  return (i->CurrentVer != 0);
}
  
bool 
Util::can_change_keep(pkgCache::PkgIterator& i, GAptPkgTree* tree)
{
  pkgDepCache::StateCache & state = (*tree->cache())[i];
	if (state.CandidateVer == 0) {
		return false;
	}

  // Render if we're installed and upgradeable, or installed and deleteable
  return (i->CurrentVer != 0);
}

pkgCache::VerIterator 
Util::display_version(pkgCache::PkgIterator & i,
                      GAptCache* cache)
{
  pkgDepCache::StateCache & state = (*cache)[i];

  // do our best to find a version - kind of hard to say 
  //  which we should find. 
  pkgCache::VerIterator vi = i.CurrentVer();
  if (vi.end()) {
    vi = state.CandidateVerIter(*cache);
  }

  return vi;
}

