/* fedora-installer.c generated by valac 0.17.1.6-d284, the Vala compiler
 * generated from fedora-installer.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/

#include <glib.h>
#include <glib-object.h>
#include <osinfo/osinfo.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <libvirt-gconfig/libvirt-gconfig.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define BOXES_TYPE_INSTALLER_MEDIA (boxes_installer_media_get_type ())
#define BOXES_INSTALLER_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMedia))
#define BOXES_INSTALLER_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMediaClass))
#define BOXES_IS_INSTALLER_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_INSTALLER_MEDIA))
#define BOXES_IS_INSTALLER_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_INSTALLER_MEDIA))
#define BOXES_INSTALLER_MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMediaClass))

typedef struct _BoxesInstallerMedia BoxesInstallerMedia;
typedef struct _BoxesInstallerMediaClass BoxesInstallerMediaClass;
typedef struct _BoxesInstallerMediaPrivate BoxesInstallerMediaPrivate;

#define BOXES_TYPE_UNATTENDED_INSTALLER (boxes_unattended_installer_get_type ())
#define BOXES_UNATTENDED_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_UNATTENDED_INSTALLER, BoxesUnattendedInstaller))
#define BOXES_UNATTENDED_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_UNATTENDED_INSTALLER, BoxesUnattendedInstallerClass))
#define BOXES_IS_UNATTENDED_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_UNATTENDED_INSTALLER))
#define BOXES_IS_UNATTENDED_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_UNATTENDED_INSTALLER))
#define BOXES_UNATTENDED_INSTALLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_UNATTENDED_INSTALLER, BoxesUnattendedInstallerClass))

typedef struct _BoxesUnattendedInstaller BoxesUnattendedInstaller;
typedef struct _BoxesUnattendedInstallerClass BoxesUnattendedInstallerClass;
typedef struct _BoxesUnattendedInstallerPrivate BoxesUnattendedInstallerPrivate;

#define BOXES_TYPE_UNATTENDED_FILE (boxes_unattended_file_get_type ())
#define BOXES_UNATTENDED_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_UNATTENDED_FILE, BoxesUnattendedFile))
#define BOXES_UNATTENDED_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_UNATTENDED_FILE, BoxesUnattendedFileClass))
#define BOXES_IS_UNATTENDED_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_UNATTENDED_FILE))
#define BOXES_IS_UNATTENDED_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_UNATTENDED_FILE))
#define BOXES_UNATTENDED_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_UNATTENDED_FILE, BoxesUnattendedFileClass))

typedef struct _BoxesUnattendedFile BoxesUnattendedFile;
typedef struct _BoxesUnattendedFileClass BoxesUnattendedFileClass;

#define BOXES_TYPE_FEDORA_INSTALLER (boxes_fedora_installer_get_type ())
#define BOXES_FEDORA_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_FEDORA_INSTALLER, BoxesFedoraInstaller))
#define BOXES_FEDORA_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_FEDORA_INSTALLER, BoxesFedoraInstallerClass))
#define BOXES_IS_FEDORA_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_FEDORA_INSTALLER))
#define BOXES_IS_FEDORA_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_FEDORA_INSTALLER))
#define BOXES_FEDORA_INSTALLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_FEDORA_INSTALLER, BoxesFedoraInstallerClass))

typedef struct _BoxesFedoraInstaller BoxesFedoraInstaller;
typedef struct _BoxesFedoraInstallerClass BoxesFedoraInstallerClass;
typedef struct _BoxesFedoraInstallerPrivate BoxesFedoraInstallerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define BOXES_FEDORA_INSTALLER_TYPE_KBD_LAYOUT (boxes_fedora_installer_kbd_layout_get_type ())
typedef struct _BoxesFedoraInstallerKbdLayout BoxesFedoraInstallerKbdLayout;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BoxesFedoraInstallerPrepareDirectBootData BoxesFedoraInstallerPrepareDirectBootData;
typedef struct _BoxesFedoraInstallerNormalCleanUpData BoxesFedoraInstallerNormalCleanUpData;
typedef struct _BoxesFedoraInstallerMountMediaData BoxesFedoraInstallerMountMediaData;
typedef struct _BoxesFedoraInstallerExtractBootFilesData BoxesFedoraInstallerExtractBootFilesData;
typedef struct _BoxesFedoraInstallerCopyFileData BoxesFedoraInstallerCopyFileData;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _BoxesInstallerMedia {
	GObject parent_instance;
	BoxesInstallerMediaPrivate * priv;
	OsinfoOs* os;
	OsinfoResources* resources;
	OsinfoMedia* os_media;
	gchar* label;
	gchar* device_file;
	gchar* mount_point;
	gboolean from_image;
};

struct _BoxesInstallerMediaClass {
	GObjectClass parent_class;
};

typedef enum  {
	UNATTENDED_INSTALLER_ERROR_SETUP_INCOMPLETE
} UnattendedInstallerError;
#define UNATTENDED_INSTALLER_ERROR unattended_installer_error_quark ()
struct _BoxesUnattendedInstaller {
	BoxesInstallerMedia parent_instance;
	BoxesUnattendedInstallerPrivate * priv;
	GDataStreamNewlineType newline_type;
	gchar* disk_path;
	GList* unattended_files;
	GtkTable* setup_table;
	GtkLabel* setup_label;
	GtkHBox* setup_hbox;
	GtkSwitch* express_toggle;
	GtkEntry* username_entry;
	GtkEntry* password_entry;
	gchar* timezone;
	gchar* lang;
};

struct _BoxesUnattendedInstallerClass {
	BoxesInstallerMediaClass parent_class;
	void (*populate_setup_vbox) (BoxesUnattendedInstaller* self, GtkVBox* setup_vbox);
	void (*set_direct_boot_params) (BoxesUnattendedInstaller* self, GVirConfigDomainOs* os);
	GVirConfigDomainDisk* (*get_unattended_disk_config) (BoxesUnattendedInstaller* self);
	void (*check_needed_info) (BoxesUnattendedInstaller* self, GError** error);
	gchar* (*fill_unattended_data) (BoxesUnattendedInstaller* self, const gchar* data, GError** error);
	void (*setup_ui) (BoxesUnattendedInstaller* self);
	void (*clean_up) (BoxesUnattendedInstaller* self, GError** error);
	void (*prepare_direct_boot) (BoxesUnattendedInstaller* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*prepare_direct_boot_finish) (BoxesUnattendedInstaller* self, GAsyncResult* _res_, GError** error);
};

struct _BoxesFedoraInstaller {
	BoxesUnattendedInstaller parent_instance;
	BoxesFedoraInstallerPrivate * priv;
};

struct _BoxesFedoraInstallerClass {
	BoxesUnattendedInstallerClass parent_class;
};

struct _BoxesFedoraInstallerPrivate {
	gboolean mounted;
	GFile* source_dir;
	GFile* kernel_file;
	GFile* initrd_file;
	gchar* kernel_path;
	gchar* initrd_path;
	gchar* kbd;
};

struct _BoxesFedoraInstallerKbdLayout {
	gchar* xkb_layout;
	gchar* xkb_variant;
	gchar* console_layout;
};

struct _BoxesFedoraInstallerPrepareDirectBootData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	BoxesFedoraInstaller* self;
	GCancellable* cancellable;
	GtkSwitch* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	OsinfoMedia* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_;
	OsinfoMedia* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gboolean _tmp13_;
	GCancellable* _tmp14_;
	GCancellable* _tmp15_;
	GCancellable* _tmp16_;
	GError * _inner_error_;
};

struct _BoxesFedoraInstallerNormalCleanUpData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	BoxesFedoraInstaller* self;
	GCancellable* cancellable;
	gboolean _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gchar** argv;
	gint argv_length1;
	gint _argv_size_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	GCancellable* _tmp8_;
	const gchar* _tmp9_;
	GFile* _tmp10_;
	const gchar* _tmp11_;
	GError * _inner_error_;
};

struct _BoxesFedoraInstallerMountMediaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	BoxesFedoraInstaller* self;
	GCancellable* cancellable;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	OsinfoOs* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	GFile* _tmp8_;
	GFile* dir;
	GFile* _tmp9_;
	GError* _error_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar** _tmp19_;
	gchar** argv;
	gint argv_length1;
	gint _argv_size_;
	gchar** _tmp20_;
	gint _tmp20__length1;
	GCancellable* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	GError * _inner_error_;
};

struct _BoxesFedoraInstallerExtractBootFilesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	BoxesFedoraInstaller* self;
	GCancellable* cancellable;
	const gchar* _tmp0_;
	OsinfoMedia* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	GFile* _tmp7_;
	const gchar* _tmp8_;
	OsinfoMedia* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	GFile* _tmp15_;
	gboolean _tmp16_;
	OsinfoOs* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	GFile* _tmp23_;
	const gchar* _tmp24_;
	GCancellable* _tmp25_;
	GFile* _tmp26_;
	GFile* _tmp27_;
	OsinfoOs* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	GFile* _tmp34_;
	const gchar* _tmp35_;
	GCancellable* _tmp36_;
	GFile* _tmp37_;
	GFile* _tmp38_;
	GError * _inner_error_;
};

struct _BoxesFedoraInstallerCopyFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	BoxesFedoraInstaller* self;
	GFile* file;
	gchar* dest_path;
	GCancellable* cancellable;
	GFile* result;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFile* dest_file;
	GFile* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	GFile* _tmp6_;
	GCancellable* _tmp7_;
	GFile* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	GError* _error_;
	GError * _inner_error_;
};


static gpointer boxes_fedora_installer_parent_class = NULL;
static GRegex* boxes_fedora_installer_repo_regex;
static GRegex* boxes_fedora_installer_repo_regex = NULL;
static GRegex* boxes_fedora_installer_kbd_regex;
static GRegex* boxes_fedora_installer_kbd_regex = NULL;

GType boxes_installer_media_get_type (void) G_GNUC_CONST;
GType boxes_unattended_installer_get_type (void) G_GNUC_CONST;
GQuark unattended_installer_error_quark (void);
gpointer boxes_unattended_file_ref (gpointer instance);
void boxes_unattended_file_unref (gpointer instance);
GParamSpec* boxes_param_spec_unattended_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void boxes_value_set_unattended_file (GValue* value, gpointer v_object);
void boxes_value_take_unattended_file (GValue* value, gpointer v_object);
gpointer boxes_value_get_unattended_file (const GValue* value);
GType boxes_unattended_file_get_type (void) G_GNUC_CONST;
GType boxes_fedora_installer_get_type (void) G_GNUC_CONST;
#define BOXES_FEDORA_INSTALLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BOXES_TYPE_FEDORA_INSTALLER, BoxesFedoraInstallerPrivate))
enum  {
	BOXES_FEDORA_INSTALLER_DUMMY_PROPERTY
};
static GType boxes_fedora_installer_kbd_layout_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static BoxesFedoraInstallerKbdLayout* boxes_fedora_installer_kbd_layout_dup (const BoxesFedoraInstallerKbdLayout* self);
static void boxes_fedora_installer_kbd_layout_free (BoxesFedoraInstallerKbdLayout* self);
static void boxes_fedora_installer_kbd_layout_copy (const BoxesFedoraInstallerKbdLayout* self, BoxesFedoraInstallerKbdLayout* dest);
static void boxes_fedora_installer_kbd_layout_destroy (BoxesFedoraInstallerKbdLayout* self);
BoxesFedoraInstaller* boxes_fedora_installer_new_copy (BoxesInstallerMedia* media, GError** error);
BoxesFedoraInstaller* boxes_fedora_installer_construct_copy (GType object_type, BoxesInstallerMedia* media, GError** error);
gchar* boxes_get_unattended_dir (const gchar* file_name);
BoxesUnattendedInstaller* boxes_unattended_installer_construct_copy (GType object_type, BoxesInstallerMedia* media, const gchar* unattended_src_path, const gchar* unattended_dest_name, GError** error);
void boxes_unattended_installer_set_password_mandatory (BoxesUnattendedInstaller* self, gboolean value);
static gchar* boxes_fedora_installer_fetch_console_kbd_layout (BoxesFedoraInstaller* self);
static void boxes_fedora_installer_real_set_direct_boot_params (BoxesUnattendedInstaller* base, GVirConfigDomainOs* os);
const gchar* boxes_unattended_installer_get_unattended_dest_name (BoxesUnattendedInstaller* self);
static void boxes_fedora_installer_real_check_needed_info (BoxesUnattendedInstaller* base, GError** error);
void boxes_unattended_installer_check_needed_info (BoxesUnattendedInstaller* self, GError** error);
static gboolean boxes_fedora_installer_get_use_remote_repos (BoxesFedoraInstaller* self);
static void boxes_fedora_installer_real_prepare_direct_boot_data_free (gpointer _data);
static void boxes_fedora_installer_real_prepare_direct_boot (BoxesUnattendedInstaller* base, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean boxes_fedora_installer_real_prepare_direct_boot_co (BoxesFedoraInstallerPrepareDirectBootData* _data_);
static void boxes_fedora_installer_mount_media (BoxesFedoraInstaller* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void boxes_fedora_installer_mount_media_finish (BoxesFedoraInstaller* self, GAsyncResult* _res_, GError** error);
static void boxes_fedora_installer_prepare_direct_boot_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void boxes_fedora_installer_extract_boot_files (BoxesFedoraInstaller* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void boxes_fedora_installer_extract_boot_files_finish (BoxesFedoraInstaller* self, GAsyncResult* _res_, GError** error);
static void boxes_fedora_installer_normal_clean_up (BoxesFedoraInstaller* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void boxes_fedora_installer_normal_clean_up_finish (BoxesFedoraInstaller* self, GAsyncResult* _res_, GError** error);
static void boxes_fedora_installer_real_clean_up (BoxesUnattendedInstaller* base, GError** error);
void boxes_unattended_installer_clean_up (BoxesUnattendedInstaller* self, GError** error);
static gchar* boxes_fedora_installer_real_fill_unattended_data (BoxesUnattendedInstaller* base, const gchar* data, GError** error);
gchar* boxes_unattended_installer_fill_unattended_data (BoxesUnattendedInstaller* self, const gchar* data, GError** error);
static void boxes_fedora_installer_normal_clean_up_data_free (gpointer _data);
static gboolean boxes_fedora_installer_normal_clean_up_co (BoxesFedoraInstallerNormalCleanUpData* _data_);
void boxes_exec (gchar** argv, int argv_length1, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void boxes_exec_finish (GAsyncResult* _res_, GError** error);
static void boxes_fedora_installer_normal_clean_up_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void boxes_fedora_installer_mount_media_data_free (gpointer _data);
static gboolean boxes_fedora_installer_mount_media_co (BoxesFedoraInstallerMountMediaData* _data_);
gchar* boxes_get_user_unattended_dir (const gchar* file_name);
static void boxes_fedora_installer_mount_media_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void boxes_fedora_installer_extract_boot_files_data_free (gpointer _data);
static gboolean boxes_fedora_installer_extract_boot_files_co (BoxesFedoraInstallerExtractBootFilesData* _data_);
static void boxes_fedora_installer_copy_file (BoxesFedoraInstaller* self, GFile* file, const gchar* dest_path, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static GFile* boxes_fedora_installer_copy_file_finish (BoxesFedoraInstaller* self, GAsyncResult* _res_, GError** error);
static void boxes_fedora_installer_extract_boot_files_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void boxes_fedora_installer_copy_file_data_free (gpointer _data);
static gboolean boxes_fedora_installer_copy_file_co (BoxesFedoraInstallerCopyFileData* _data_);
static void boxes_fedora_installer_copy_file_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
BoxesFedoraInstaller* boxes_fedora_installer_new (void);
BoxesFedoraInstaller* boxes_fedora_installer_construct (GType object_type);
BoxesUnattendedInstaller* boxes_unattended_installer_construct (GType object_type);
gboolean boxes_unattended_installer_get_express_install (BoxesUnattendedInstaller* self);
static void boxes_fedora_installer_finalize (GObject* obj);
static void _vala_boxes_fedora_installer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const BoxesFedoraInstallerKbdLayout BOXES_FEDORA_INSTALLER_kbd_layouts[65] = {{"ara", NULL, "ar-azerty"}, {"ara", "azerty", "ar-azerty"}, {"ara", "azerty_digits", "ar-azerty-digits"}, {"ara", "digits", "ar-digits"}, {"ara", "qwerty", "ar-qwerty"}, {"ara", "qwerty_digits", "ar-qwerty-digits"}, {"be", NULL, "be-latin1"}, {"bg", NULL, "bg_bds-utf8"}, {"bg", "phonetic", "bg_pho-utf8"}, {"bg", "bas_phonetic", "bg_pho-utf8"}, {"br", NULL, "br-abnt2"}, {"ca(fr)", NULL, "cf"}, {"hr", NULL, "croat"}, {"cz", NULL, "cz-us-qwertz"}, {"cz", "qwerty", "cz-lat2"}, {"cz", "", "cz-us-qwertz"}, {"de", NULL, "de"}, {"de", "nodeadkeys", "de-latin1-nodeadkeys"}, {"dev", NULL, "dev"}, {"dk", NULL, "dk"}, {"dk", "dvorak", "dk-dvorak"}, {"es", NULL, "es"}, {"ee", NULL, "et"}, {"fi", NULL, "fi"}, {"fr", NULL, "fr"}, {"fr", "latin9", "fr-latin9"}, {"gr", NULL, "gr"}, {"gur", NULL, "gur"}, {"hu", NULL, "hu"}, {"hu", "qwerty", "hu101"}, {"ie", NULL, "ie"}, {"in", NULL, "us"}, {"in", "ben", "ben"}, {"in", "ben-probhat", "ben_probhat"}, {"in", "guj", "guj"}, {"in", "tam", "tml-inscript"}, {"in", "tam_TAB", "tml-uni"}, {"is", NULL, "is-latin1"}, {"it", NULL, "it"}, {"jp", NULL, "jp106"}, {"kr", NULL, "ko"}, {"latam", NULL, "la-latin1"}, {"mkd", NULL, "mk-utf"}, {"nl", NULL, "nl"}, {"no", NULL, "no"}, {"pl", NULL, "pl2"}, {"pt", NULL, "pt-latin1"}, {"ro", NULL, "ro"}, {"ro", "std", "ro-std"}, {"ro", "cedilla", "ro-cedilla"}, {"ro", "std_cedilla", "ro-std-cedilla"}, {"ru", NULL, "ru"}, {"rs", NULL, "sr-cy"}, {"rs", "latin", "sr-latin"}, {"se", NULL, "sv-latin1"}, {"ch", "de_nodeadkeys", "sg"}, {"ch", "fr", "fr_CH"}, {"sk", NULL, "sk-qwerty"}, {"si", NULL, "slovene"}, {"tj", NULL, "tj"}, {"tr", NULL, "trq"}, {"gb", NULL, "uk"}, {"ua", NULL, "ua-utf"}, {"us", NULL, "us"}, {"us", "intl", "us-acentos"}};

BoxesFedoraInstaller* boxes_fedora_installer_construct_copy (GType object_type, BoxesInstallerMedia* media, GError** error) {
	BoxesFedoraInstaller * self = NULL;
	gchar* _tmp0_ = NULL;
	gchar* source_path;
	BoxesInstallerMedia* _tmp1_;
	gchar* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (media != NULL, NULL);
	_tmp0_ = boxes_get_unattended_dir ("fedora.ks");
	source_path = _tmp0_;
	_tmp1_ = media;
	self = (BoxesFedoraInstaller*) boxes_unattended_installer_construct_copy (object_type, _tmp1_, source_path, "ks.cfg", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (source_path);
		_g_object_unref0 (self);
		return NULL;
	}
	boxes_unattended_installer_set_password_mandatory ((BoxesUnattendedInstaller*) self, TRUE);
	_tmp2_ = boxes_fedora_installer_fetch_console_kbd_layout (self);
	_g_free0 (self->priv->kbd);
	self->priv->kbd = _tmp2_;
	_g_free0 (source_path);
	return self;
}


BoxesFedoraInstaller* boxes_fedora_installer_new_copy (BoxesInstallerMedia* media, GError** error) {
	return boxes_fedora_installer_construct_copy (BOXES_TYPE_FEDORA_INSTALLER, media, error);
}


static void boxes_fedora_installer_real_set_direct_boot_params (BoxesUnattendedInstaller* base, GVirConfigDomainOs* os) {
	BoxesFedoraInstaller * self;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp3_;
	GVirConfigDomainOs* _tmp4_;
	const gchar* _tmp5_;
	GVirConfigDomainOs* _tmp6_;
	const gchar* _tmp7_;
	GVirConfigDomainOs* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	self = (BoxesFedoraInstaller*) base;
	g_return_if_fail (os != NULL);
	_tmp1_ = self->priv->kernel_path;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = self->priv->initrd_path;
		_tmp0_ = _tmp2_ == NULL;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		return;
	}
	_tmp4_ = os;
	_tmp5_ = self->priv->kernel_path;
	gvir_config_domain_os_set_kernel (_tmp4_, _tmp5_);
	_tmp6_ = os;
	_tmp7_ = self->priv->initrd_path;
	gvir_config_domain_os_set_ramdisk (_tmp6_, _tmp7_);
	_tmp8_ = os;
	_tmp9_ = boxes_unattended_installer_get_unattended_dest_name ((BoxesUnattendedInstaller*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strconcat ("ks=hd:sda:/", _tmp10_, NULL);
	_tmp12_ = _tmp11_;
	gvir_config_domain_os_set_cmdline (_tmp8_, _tmp12_);
	_g_free0 (_tmp12_);
}


static void boxes_fedora_installer_real_check_needed_info (BoxesUnattendedInstaller* base, GError** error) {
	BoxesFedoraInstaller * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	self = (BoxesFedoraInstaller*) base;
	BOXES_UNATTENDED_INSTALLER_CLASS (boxes_fedora_installer_parent_class)->check_needed_info (BOXES_UNATTENDED_INSTALLER (self), &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == UNATTENDED_INSTALLER_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp0_ = boxes_fedora_installer_get_use_remote_repos (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	{
		GSocketClient* _tmp2_;
		GSocketClient* client;
		GSocketClient* _tmp3_;
		_tmp2_ = g_socket_client_new ();
		client = _tmp2_;
		_tmp3_ = client;
		g_socket_client_connect_to_host (_tmp3_, "fedoraproject.org", (guint16) 80, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (client);
			goto __catch9_g_error;
		}
		_g_object_unref0 (client);
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gchar* message;
		const gchar* _tmp6_;
		GError* _tmp7_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = _ ("Internet access required for express installation of Fedora 16 and old" \
"er");
		_tmp5_ = g_strdup (_tmp4_);
		message = _tmp5_;
		_tmp6_ = message;
		_tmp7_ = g_error_new_literal (UNATTENDED_INSTALLER_ERROR, UNATTENDED_INSTALLER_ERROR_SETUP_INCOMPLETE, _tmp6_);
		_inner_error_ = _tmp7_;
		_g_free0 (message);
		_g_error_free0 (_error_);
		goto __finally9;
	}
	__finally9:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == UNATTENDED_INSTALLER_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void boxes_fedora_installer_real_prepare_direct_boot_data_free (gpointer _data) {
	BoxesFedoraInstallerPrepareDirectBootData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (BoxesFedoraInstallerPrepareDirectBootData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void boxes_fedora_installer_real_prepare_direct_boot (BoxesUnattendedInstaller* base, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	BoxesFedoraInstaller * self;
	BoxesFedoraInstallerPrepareDirectBootData* _data_;
	BoxesFedoraInstaller* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	self = (BoxesFedoraInstaller*) base;
	_data_ = g_slice_new0 (BoxesFedoraInstallerPrepareDirectBootData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, boxes_fedora_installer_real_prepare_direct_boot);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, boxes_fedora_installer_real_prepare_direct_boot_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = cancellable;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->cancellable = _tmp2_;
	boxes_fedora_installer_real_prepare_direct_boot_co (_data_);
}


static void boxes_fedora_installer_real_prepare_direct_boot_finish (BoxesUnattendedInstaller* base, GAsyncResult* _res_, GError** error) {
	BoxesFedoraInstallerPrepareDirectBootData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void boxes_fedora_installer_prepare_direct_boot_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	BoxesFedoraInstallerPrepareDirectBootData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_fedora_installer_real_prepare_direct_boot_co (_data_);
}


static gboolean boxes_fedora_installer_real_prepare_direct_boot_co (BoxesFedoraInstallerPrepareDirectBootData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = ((BoxesUnattendedInstaller*) _data_->self)->express_toggle;
	_data_->_tmp1_ = gtk_switch_get_active (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	if (!_data_->_tmp2_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = ((BoxesInstallerMedia*) _data_->self)->os_media;
	_data_->_tmp5_ = NULL;
	g_object_get (_data_->_tmp4_, "kernel-path", &_data_->_tmp5_, NULL);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = _data_->_tmp6_;
	_data_->_tmp8_ = _data_->_tmp7_ == NULL;
	_g_free0 (_data_->_tmp7_);
	if (_data_->_tmp8_) {
		_data_->_tmp3_ = TRUE;
	} else {
		_data_->_tmp9_ = ((BoxesInstallerMedia*) _data_->self)->os_media;
		_data_->_tmp10_ = NULL;
		g_object_get (_data_->_tmp9_, "initrd-path", &_data_->_tmp10_, NULL);
		_data_->_tmp11_ = _data_->_tmp10_;
		_data_->_tmp12_ = _data_->_tmp11_;
		_data_->_tmp3_ = _data_->_tmp12_ == NULL;
		_g_free0 (_data_->_tmp12_);
	}
	_data_->_tmp13_ = _data_->_tmp3_;
	if (_data_->_tmp13_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp14_ = _data_->cancellable;
	_data_->_state_ = 1;
	boxes_fedora_installer_mount_media (_data_->self, _data_->_tmp14_, boxes_fedora_installer_prepare_direct_boot_ready, _data_);
	return FALSE;
	_state_1:
	boxes_fedora_installer_mount_media_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp15_ = _data_->cancellable;
	_data_->_state_ = 2;
	boxes_fedora_installer_extract_boot_files (_data_->self, _data_->_tmp15_, boxes_fedora_installer_prepare_direct_boot_ready, _data_);
	return FALSE;
	_state_2:
	boxes_fedora_installer_extract_boot_files_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp16_ = _data_->cancellable;
	_data_->_state_ = 3;
	boxes_fedora_installer_normal_clean_up (_data_->self, _data_->_tmp16_, boxes_fedora_installer_prepare_direct_boot_ready, _data_);
	return FALSE;
	_state_3:
	boxes_fedora_installer_normal_clean_up_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void boxes_fedora_installer_real_clean_up (BoxesUnattendedInstaller* base, GError** error) {
	BoxesFedoraInstaller * self;
	GFile* _tmp0_;
	GFile* _tmp4_;
	GError * _inner_error_ = NULL;
	self = (BoxesFedoraInstaller*) base;
	BOXES_UNATTENDED_INSTALLER_CLASS (boxes_fedora_installer_parent_class)->clean_up (BOXES_UNATTENDED_INSTALLER (self), &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp0_ = self->priv->kernel_file;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		GFile* _tmp2_;
		const gchar* _tmp3_;
		_tmp1_ = self->priv->kernel_path;
		g_debug ("fedora-installer.vala:84: Removing '%s'..", _tmp1_);
		_tmp2_ = self->priv->kernel_file;
		g_file_delete (_tmp2_, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
		_tmp3_ = self->priv->kernel_path;
		g_debug ("fedora-installer.vala:86: Removed '%s'.", _tmp3_);
	}
	_tmp4_ = self->priv->initrd_file;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		GFile* _tmp6_;
		const gchar* _tmp7_;
		_tmp5_ = self->priv->initrd_path;
		g_debug ("fedora-installer.vala:90: Removing '%s'..", _tmp5_);
		_tmp6_ = self->priv->initrd_file;
		g_file_delete (_tmp6_, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
		_tmp7_ = self->priv->initrd_path;
		g_debug ("fedora-installer.vala:92: Removed '%s'.", _tmp7_);
	}
}


static gchar* boxes_fedora_installer_real_fill_unattended_data (BoxesUnattendedInstaller* base, const gchar* data, GError** error) {
	BoxesFedoraInstaller * self;
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* str;
	GRegex* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	const gchar* _tmp10_ = NULL;
	gboolean _tmp11_;
	gboolean _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* repos;
	GRegex* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_;
	GError * _inner_error_ = NULL;
	self = (BoxesFedoraInstaller*) base;
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = data;
	_tmp1_ = BOXES_UNATTENDED_INSTALLER_CLASS (boxes_fedora_installer_parent_class)->fill_unattended_data (BOXES_UNATTENDED_INSTALLER (self), _tmp0_, &_inner_error_);
	str = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = boxes_fedora_installer_kbd_regex;
	_tmp3_ = str;
	_tmp4_ = str;
	_tmp5_ = strlen (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = self->priv->kbd;
	_tmp8_ = g_regex_replace (_tmp2_, _tmp3_, (gssize) _tmp6_, 0, _tmp7_, 0, &_inner_error_);
	_tmp9_ = _tmp8_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (str);
			return NULL;
		} else {
			_g_free0 (str);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_g_free0 (str);
	str = _tmp9_;
	_tmp11_ = boxes_fedora_installer_get_use_remote_repos (self);
	_tmp12_ = _tmp11_;
	if (_tmp12_) {
		_tmp10_ = "repo --name=fedora\nrepo --name=updates";
	} else {
		_tmp10_ = "";
	}
	_tmp13_ = _tmp10_;
	_tmp14_ = g_strdup (_tmp13_);
	repos = _tmp14_;
	_tmp15_ = boxes_fedora_installer_repo_regex;
	_tmp16_ = str;
	_tmp17_ = str;
	_tmp18_ = strlen (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = repos;
	_tmp21_ = g_regex_replace (_tmp15_, _tmp16_, (gssize) _tmp19_, 0, _tmp20_, 0, &_inner_error_);
	_tmp22_ = _tmp21_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (repos);
			_g_free0 (str);
			return NULL;
		} else {
			_g_free0 (repos);
			_g_free0 (str);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp22_;
	_g_free0 (repos);
	_g_free0 (str);
	return result;
}


static void boxes_fedora_installer_normal_clean_up_data_free (gpointer _data) {
	BoxesFedoraInstallerNormalCleanUpData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (BoxesFedoraInstallerNormalCleanUpData, _data_);
}


static void boxes_fedora_installer_normal_clean_up (BoxesFedoraInstaller* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	BoxesFedoraInstallerNormalCleanUpData* _data_;
	BoxesFedoraInstaller* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	_data_ = g_slice_new0 (BoxesFedoraInstallerNormalCleanUpData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, boxes_fedora_installer_normal_clean_up);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, boxes_fedora_installer_normal_clean_up_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = cancellable;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->cancellable = _tmp2_;
	boxes_fedora_installer_normal_clean_up_co (_data_);
}


static void boxes_fedora_installer_normal_clean_up_finish (BoxesFedoraInstaller* self, GAsyncResult* _res_, GError** error) {
	BoxesFedoraInstallerNormalCleanUpData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void boxes_fedora_installer_normal_clean_up_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	BoxesFedoraInstallerNormalCleanUpData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_fedora_installer_normal_clean_up_co (_data_);
}


static gboolean boxes_fedora_installer_normal_clean_up_co (BoxesFedoraInstallerNormalCleanUpData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->mounted;
	if (!_data_->_tmp0_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = ((BoxesInstallerMedia*) _data_->self)->mount_point;
	g_debug ("fedora-installer.vala:110: Unmounting '%s'..", _data_->_tmp1_);
	_data_->_tmp2_ = g_strdup ("fusermount");
	_data_->_tmp3_ = g_strdup ("-u");
	_data_->_tmp4_ = ((BoxesInstallerMedia*) _data_->self)->mount_point;
	_data_->_tmp5_ = g_strdup (_data_->_tmp4_);
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = g_new0 (gchar*, 3 + 1);
	_data_->_tmp6_[0] = _data_->_tmp2_;
	_data_->_tmp6_[1] = _data_->_tmp3_;
	_data_->_tmp6_[2] = _data_->_tmp5_;
	_data_->argv = _data_->_tmp6_;
	_data_->argv_length1 = 3;
	_data_->_argv_size_ = _data_->argv_length1;
	_data_->_tmp7_ = _data_->argv;
	_data_->_tmp7__length1 = _data_->argv_length1;
	_data_->_tmp8_ = _data_->cancellable;
	_data_->_state_ = 1;
	boxes_exec (_data_->_tmp7_, _data_->_tmp7__length1, _data_->_tmp8_, boxes_fedora_installer_normal_clean_up_ready, _data_);
	return FALSE;
	_state_1:
	boxes_exec_finish (_data_->_res_, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp9_ = ((BoxesInstallerMedia*) _data_->self)->mount_point;
	g_debug ("fedora-installer.vala:113: Unmounted '%s'.", _data_->_tmp9_);
	_data_->_tmp10_ = _data_->self->priv->source_dir;
	g_file_delete (_data_->_tmp10_, NULL, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp11_ = ((BoxesInstallerMedia*) _data_->self)->mount_point;
	g_debug ("fedora-installer.vala:116: Removed '%s'.", _data_->_tmp11_);
	_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void boxes_fedora_installer_mount_media_data_free (gpointer _data) {
	BoxesFedoraInstallerMountMediaData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (BoxesFedoraInstallerMountMediaData, _data_);
}


static void boxes_fedora_installer_mount_media (BoxesFedoraInstaller* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	BoxesFedoraInstallerMountMediaData* _data_;
	BoxesFedoraInstaller* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	_data_ = g_slice_new0 (BoxesFedoraInstallerMountMediaData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, boxes_fedora_installer_mount_media);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, boxes_fedora_installer_mount_media_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = cancellable;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->cancellable = _tmp2_;
	boxes_fedora_installer_mount_media_co (_data_);
}


static void boxes_fedora_installer_mount_media_finish (BoxesFedoraInstaller* self, GAsyncResult* _res_, GError** error) {
	BoxesFedoraInstallerMountMediaData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void boxes_fedora_installer_mount_media_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	BoxesFedoraInstallerMountMediaData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_fedora_installer_mount_media_co (_data_);
}


static gboolean boxes_fedora_installer_mount_media_co (BoxesFedoraInstallerMountMediaData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = ((BoxesInstallerMedia*) _data_->self)->mount_point;
	if (_data_->_tmp0_ != NULL) {
		_data_->_tmp1_ = ((BoxesInstallerMedia*) _data_->self)->mount_point;
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = g_file_new_for_path (_data_->_tmp1_);
		_g_object_unref0 (_data_->self->priv->source_dir);
		_data_->self->priv->source_dir = _data_->_tmp2_;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = ((BoxesInstallerMedia*) _data_->self)->os;
	_data_->_tmp4_ = osinfo_product_get_short_id ((OsinfoProduct*) _data_->_tmp3_);
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = boxes_get_user_unattended_dir (_data_->_tmp5_);
	_g_free0 (((BoxesInstallerMedia*) _data_->self)->mount_point);
	((BoxesInstallerMedia*) _data_->self)->mount_point = _data_->_tmp6_;
	_data_->_tmp7_ = ((BoxesInstallerMedia*) _data_->self)->mount_point;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = g_file_new_for_path (_data_->_tmp7_);
	_data_->dir = _data_->_tmp8_;
	{
		_data_->_tmp9_ = _data_->dir;
		g_file_make_directory (_data_->_tmp9_, NULL, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			if (g_error_matches (_data_->_inner_error_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
				goto __catch10_g_io_error_exists;
			}
			goto __finally10;
		}
	}
	goto __finally10;
	__catch10_g_io_error_exists:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_g_error_free0 (_data_->_error_);
	}
	__finally10:
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->dir);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp10_ = _data_->dir;
	_data_->_tmp11_ = _g_object_ref0 (_data_->_tmp10_);
	_g_object_unref0 (_data_->self->priv->source_dir);
	_data_->self->priv->source_dir = _data_->_tmp11_;
	_data_->_tmp12_ = ((BoxesInstallerMedia*) _data_->self)->device_file;
	_data_->_tmp13_ = ((BoxesInstallerMedia*) _data_->self)->mount_point;
	g_debug ("fedora-installer.vala:133: Mounting '%s' on '%s'..", _data_->_tmp12_, _data_->_tmp13_);
	_data_->_tmp14_ = g_strdup ("fuseiso");
	_data_->_tmp15_ = ((BoxesInstallerMedia*) _data_->self)->device_file;
	_data_->_tmp16_ = g_strdup (_data_->_tmp15_);
	_data_->_tmp17_ = ((BoxesInstallerMedia*) _data_->self)->mount_point;
	_data_->_tmp18_ = g_strdup (_data_->_tmp17_);
	_data_->_tmp19_ = NULL;
	_data_->_tmp19_ = g_new0 (gchar*, 3 + 1);
	_data_->_tmp19_[0] = _data_->_tmp14_;
	_data_->_tmp19_[1] = _data_->_tmp16_;
	_data_->_tmp19_[2] = _data_->_tmp18_;
	_data_->argv = _data_->_tmp19_;
	_data_->argv_length1 = 3;
	_data_->_argv_size_ = _data_->argv_length1;
	_data_->_tmp20_ = _data_->argv;
	_data_->_tmp20__length1 = _data_->argv_length1;
	_data_->_tmp21_ = _data_->cancellable;
	_data_->_state_ = 1;
	boxes_exec (_data_->_tmp20_, _data_->_tmp20__length1, _data_->_tmp21_, boxes_fedora_installer_mount_media_ready, _data_);
	return FALSE;
	_state_1:
	boxes_exec_finish (_data_->_res_, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (_data_->dir);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp22_ = ((BoxesInstallerMedia*) _data_->self)->device_file;
	_data_->_tmp23_ = ((BoxesInstallerMedia*) _data_->self)->mount_point;
	g_debug ("fedora-installer.vala:136: '%s' now mounted on '%s'.", _data_->_tmp22_, _data_->_tmp23_);
	_data_->self->priv->mounted = TRUE;
	_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->dir);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void boxes_fedora_installer_extract_boot_files_data_free (gpointer _data) {
	BoxesFedoraInstallerExtractBootFilesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (BoxesFedoraInstallerExtractBootFilesData, _data_);
}


static void boxes_fedora_installer_extract_boot_files (BoxesFedoraInstaller* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	BoxesFedoraInstallerExtractBootFilesData* _data_;
	BoxesFedoraInstaller* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	_data_ = g_slice_new0 (BoxesFedoraInstallerExtractBootFilesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, boxes_fedora_installer_extract_boot_files);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, boxes_fedora_installer_extract_boot_files_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = cancellable;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->cancellable = _tmp2_;
	boxes_fedora_installer_extract_boot_files_co (_data_);
}


static void boxes_fedora_installer_extract_boot_files_finish (BoxesFedoraInstaller* self, GAsyncResult* _res_, GError** error) {
	BoxesFedoraInstallerExtractBootFilesData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void boxes_fedora_installer_extract_boot_files_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	BoxesFedoraInstallerExtractBootFilesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_fedora_installer_extract_boot_files_co (_data_);
}


static gboolean boxes_fedora_installer_extract_boot_files_co (BoxesFedoraInstallerExtractBootFilesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = ((BoxesInstallerMedia*) _data_->self)->mount_point;
	_data_->_tmp1_ = ((BoxesInstallerMedia*) _data_->self)->os_media;
	_data_->_tmp2_ = NULL;
	g_object_get (_data_->_tmp1_, "kernel-path", &_data_->_tmp2_, NULL);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = g_build_filename (_data_->_tmp0_, _data_->_tmp4_, NULL);
	_g_free0 (_data_->self->priv->kernel_path);
	_data_->self->priv->kernel_path = _data_->_tmp5_;
	_g_free0 (_data_->_tmp4_);
	_data_->_tmp6_ = _data_->self->priv->kernel_path;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = g_file_new_for_path (_data_->_tmp6_);
	_g_object_unref0 (_data_->self->priv->kernel_file);
	_data_->self->priv->kernel_file = _data_->_tmp7_;
	_data_->_tmp8_ = ((BoxesInstallerMedia*) _data_->self)->mount_point;
	_data_->_tmp9_ = ((BoxesInstallerMedia*) _data_->self)->os_media;
	_data_->_tmp10_ = NULL;
	g_object_get (_data_->_tmp9_, "initrd-path", &_data_->_tmp10_, NULL);
	_data_->_tmp11_ = _data_->_tmp10_;
	_data_->_tmp12_ = _data_->_tmp11_;
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = g_build_filename (_data_->_tmp8_, _data_->_tmp12_, NULL);
	_g_free0 (_data_->self->priv->initrd_path);
	_data_->self->priv->initrd_path = _data_->_tmp13_;
	_g_free0 (_data_->_tmp12_);
	_data_->_tmp14_ = _data_->self->priv->initrd_path;
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = g_file_new_for_path (_data_->_tmp14_);
	_g_object_unref0 (_data_->self->priv->initrd_file);
	_data_->self->priv->initrd_file = _data_->_tmp15_;
	_data_->_tmp16_ = _data_->self->priv->mounted;
	if (!_data_->_tmp16_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp17_ = ((BoxesInstallerMedia*) _data_->self)->os;
	_data_->_tmp18_ = osinfo_product_get_short_id ((OsinfoProduct*) _data_->_tmp17_);
	_data_->_tmp19_ = _data_->_tmp18_;
	_data_->_tmp20_ = g_strconcat (_data_->_tmp19_, "-kernel", NULL);
	_data_->_tmp21_ = _data_->_tmp20_;
	_data_->_tmp22_ = NULL;
	_data_->_tmp22_ = boxes_get_user_unattended_dir (_data_->_tmp21_);
	_g_free0 (_data_->self->priv->kernel_path);
	_data_->self->priv->kernel_path = _data_->_tmp22_;
	_g_free0 (_data_->_tmp21_);
	_data_->_tmp23_ = _data_->self->priv->kernel_file;
	_data_->_tmp24_ = _data_->self->priv->kernel_path;
	_data_->_tmp25_ = _data_->cancellable;
	_data_->_state_ = 1;
	boxes_fedora_installer_copy_file (_data_->self, _data_->_tmp23_, _data_->_tmp24_, _data_->_tmp25_, boxes_fedora_installer_extract_boot_files_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp26_ = NULL;
	_data_->_tmp26_ = boxes_fedora_installer_copy_file_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	_data_->_tmp27_ = _data_->_tmp26_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->self->priv->kernel_file);
	_data_->self->priv->kernel_file = _data_->_tmp27_;
	_data_->_tmp28_ = ((BoxesInstallerMedia*) _data_->self)->os;
	_data_->_tmp29_ = osinfo_product_get_short_id ((OsinfoProduct*) _data_->_tmp28_);
	_data_->_tmp30_ = _data_->_tmp29_;
	_data_->_tmp31_ = g_strconcat (_data_->_tmp30_, "-initrd", NULL);
	_data_->_tmp32_ = _data_->_tmp31_;
	_data_->_tmp33_ = NULL;
	_data_->_tmp33_ = boxes_get_user_unattended_dir (_data_->_tmp32_);
	_g_free0 (_data_->self->priv->initrd_path);
	_data_->self->priv->initrd_path = _data_->_tmp33_;
	_g_free0 (_data_->_tmp32_);
	_data_->_tmp34_ = _data_->self->priv->initrd_file;
	_data_->_tmp35_ = _data_->self->priv->initrd_path;
	_data_->_tmp36_ = _data_->cancellable;
	_data_->_state_ = 2;
	boxes_fedora_installer_copy_file (_data_->self, _data_->_tmp34_, _data_->_tmp35_, _data_->_tmp36_, boxes_fedora_installer_extract_boot_files_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp37_ = NULL;
	_data_->_tmp37_ = boxes_fedora_installer_copy_file_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	_data_->_tmp38_ = _data_->_tmp37_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->self->priv->initrd_file);
	_data_->self->priv->initrd_file = _data_->_tmp38_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void boxes_fedora_installer_copy_file_data_free (gpointer _data) {
	BoxesFedoraInstallerCopyFileData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->file);
	_g_free0 (_data_->dest_path);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (BoxesFedoraInstallerCopyFileData, _data_);
}


static void boxes_fedora_installer_copy_file (BoxesFedoraInstaller* self, GFile* file, const gchar* dest_path, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	BoxesFedoraInstallerCopyFileData* _data_;
	BoxesFedoraInstaller* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	GCancellable* _tmp5_;
	GCancellable* _tmp6_;
	_data_ = g_slice_new0 (BoxesFedoraInstallerCopyFileData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, boxes_fedora_installer_copy_file);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, boxes_fedora_installer_copy_file_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = file;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->file = _tmp2_;
	_tmp3_ = dest_path;
	_tmp4_ = g_strdup (_tmp3_);
	_data_->dest_path = _tmp4_;
	_tmp5_ = cancellable;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_data_->cancellable = _tmp6_;
	boxes_fedora_installer_copy_file_co (_data_);
}


static GFile* boxes_fedora_installer_copy_file_finish (BoxesFedoraInstaller* self, GAsyncResult* _res_, GError** error) {
	GFile* result;
	BoxesFedoraInstallerCopyFileData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void boxes_fedora_installer_copy_file_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	BoxesFedoraInstallerCopyFileData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_fedora_installer_copy_file_co (_data_);
}


static gboolean boxes_fedora_installer_copy_file_co (BoxesFedoraInstallerCopyFileData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->dest_path;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = g_file_new_for_path (_data_->_tmp0_);
	_data_->dest_file = _data_->_tmp1_;
	{
		_data_->_tmp2_ = _data_->file;
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = g_file_get_path (_data_->_tmp2_);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp5_ = _data_->dest_path;
		g_debug ("fedora-installer.vala:160: Copying '%s' to '%s'..", _data_->_tmp4_, _data_->_tmp5_);
		_g_free0 (_data_->_tmp4_);
		_data_->_tmp6_ = _data_->file;
		_data_->_tmp7_ = _data_->cancellable;
		_data_->_state_ = 1;
		g_file_copy_async (_data_->_tmp6_, _data_->dest_file, 0, G_PRIORITY_DEFAULT, _data_->_tmp7_, NULL, NULL, boxes_fedora_installer_copy_file_ready, _data_);
		return FALSE;
		_state_1:
		g_file_copy_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			if (g_error_matches (_data_->_inner_error_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
				goto __catch11_g_io_error_exists;
			}
			goto __finally11;
		}
		_data_->_tmp8_ = _data_->file;
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = g_file_get_path (_data_->_tmp8_);
		_data_->_tmp10_ = _data_->_tmp9_;
		_data_->_tmp11_ = _data_->dest_path;
		g_debug ("fedora-installer.vala:162: Copied '%s' to '%s'.", _data_->_tmp10_, _data_->_tmp11_);
		_g_free0 (_data_->_tmp10_);
	}
	goto __finally11;
	__catch11_g_io_error_exists:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_g_error_free0 (_data_->_error_);
	}
	__finally11:
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->dest_file);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->dest_file;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->dest_file);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gchar* boxes_fedora_installer_fetch_console_kbd_layout (BoxesFedoraInstaller* self) {
	gchar* result = NULL;
	GSettings* _tmp0_;
	GSettings* settings;
	GSettings* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_ = NULL;
	gchar** layouts;
	gint layouts_length1;
	gint _layouts_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* layout_str;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_;
	gboolean _tmp10_;
	const gchar* _tmp12_;
	gchar** _tmp13_;
	gchar** _tmp14_ = NULL;
	gchar** tokens;
	gint tokens_length1;
	gint _tokens_size_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* xkb_layout;
	gchar** _tmp18_;
	gint _tmp18__length1;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* xkb_variant;
	gchar* _tmp21_;
	gchar* console_layout;
	const gchar* _tmp45_;
	const gchar* _tmp48_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_settings_new ("org.gnome.libgnomekbd.keyboard");
	settings = _tmp0_;
	_tmp1_ = settings;
	_tmp3_ = _tmp2_ = g_settings_get_strv (_tmp1_, "layouts");
	layouts = _tmp3_;
	layouts_length1 = _vala_array_length (_tmp2_);
	_layouts_size_ = layouts_length1;
	_tmp4_ = layouts;
	_tmp4__length1 = layouts_length1;
	_tmp5_ = _tmp4_[0];
	_tmp6_ = g_strdup (_tmp5_);
	layout_str = _tmp6_;
	_tmp8_ = layout_str;
	if (_tmp8_ == NULL) {
		_tmp7_ = TRUE;
	} else {
		const gchar* _tmp9_;
		_tmp9_ = layout_str;
		_tmp7_ = g_strcmp0 (_tmp9_, "") == 0;
	}
	_tmp10_ = _tmp7_;
	if (_tmp10_) {
		gchar* _tmp11_;
		g_warning ("fedora-installer.vala:179: Failed to fetch prefered keyboard layout fr" \
"om user settings, falling back to 'us'..");
		_tmp11_ = g_strdup ("us");
		result = _tmp11_;
		_g_free0 (layout_str);
		layouts = (_vala_array_free (layouts, layouts_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (settings);
		return result;
	}
	_tmp12_ = layout_str;
	_tmp14_ = _tmp13_ = g_strsplit (_tmp12_, "\t", 0);
	tokens = _tmp14_;
	tokens_length1 = _vala_array_length (_tmp13_);
	_tokens_size_ = tokens_length1;
	_tmp15_ = tokens;
	_tmp15__length1 = tokens_length1;
	_tmp16_ = _tmp15_[0];
	_tmp17_ = g_strdup (_tmp16_);
	xkb_layout = _tmp17_;
	_tmp18_ = tokens;
	_tmp18__length1 = tokens_length1;
	_tmp19_ = _tmp18_[1];
	_tmp20_ = g_strdup (_tmp19_);
	xkb_variant = _tmp20_;
	_tmp21_ = g_strdup ((const gchar*) NULL);
	console_layout = _tmp21_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp22_;
			_tmp22_ = TRUE;
			while (TRUE) {
				gboolean _tmp23_;
				gint _tmp25_;
				const gchar* _tmp26_;
				gint _tmp27_;
				BoxesFedoraInstallerKbdLayout _tmp28_;
				const gchar* _tmp29_;
				_tmp23_ = _tmp22_;
				if (!_tmp23_) {
					gint _tmp24_;
					_tmp24_ = i;
					i = _tmp24_ + 1;
				}
				_tmp22_ = FALSE;
				_tmp25_ = i;
				if (!(_tmp25_ < G_N_ELEMENTS (BOXES_FEDORA_INSTALLER_kbd_layouts))) {
					break;
				}
				_tmp26_ = xkb_layout;
				_tmp27_ = i;
				_tmp28_ = BOXES_FEDORA_INSTALLER_kbd_layouts[_tmp27_];
				_tmp29_ = _tmp28_.xkb_layout;
				if (g_strcmp0 (_tmp26_, _tmp29_) == 0) {
					const gchar* _tmp30_;
					gint _tmp31_;
					BoxesFedoraInstallerKbdLayout _tmp32_;
					const gchar* _tmp33_;
					_tmp30_ = xkb_variant;
					_tmp31_ = i;
					_tmp32_ = BOXES_FEDORA_INSTALLER_kbd_layouts[_tmp31_];
					_tmp33_ = _tmp32_.xkb_variant;
					if (g_strcmp0 (_tmp30_, _tmp33_) == 0) {
						gint _tmp34_;
						BoxesFedoraInstallerKbdLayout _tmp35_;
						const gchar* _tmp36_;
						gchar* _tmp37_;
						_tmp34_ = i;
						_tmp35_ = BOXES_FEDORA_INSTALLER_kbd_layouts[_tmp34_];
						_tmp36_ = _tmp35_.console_layout;
						_tmp37_ = g_strdup (_tmp36_);
						_g_free0 (console_layout);
						console_layout = _tmp37_;
						break;
					} else {
						gint _tmp38_;
						BoxesFedoraInstallerKbdLayout _tmp39_;
						const gchar* _tmp40_;
						_tmp38_ = i;
						_tmp39_ = BOXES_FEDORA_INSTALLER_kbd_layouts[_tmp38_];
						_tmp40_ = _tmp39_.xkb_variant;
						if (_tmp40_ == NULL) {
							gint _tmp41_;
							BoxesFedoraInstallerKbdLayout _tmp42_;
							const gchar* _tmp43_;
							gchar* _tmp44_;
							_tmp41_ = i;
							_tmp42_ = BOXES_FEDORA_INSTALLER_kbd_layouts[_tmp41_];
							_tmp43_ = _tmp42_.console_layout;
							_tmp44_ = g_strdup (_tmp43_);
							_g_free0 (console_layout);
							console_layout = _tmp44_;
						}
					}
				}
			}
		}
	}
	_tmp45_ = console_layout;
	if (_tmp45_ == NULL) {
		const gchar* _tmp46_;
		gchar* _tmp47_;
		_tmp46_ = layout_str;
		g_debug ("fedora-installer.vala:200: Couldn't find a console layout for X layout" \
" '%s', falling back to 'us'..", _tmp46_);
		_tmp47_ = g_strdup ("us");
		_g_free0 (console_layout);
		console_layout = _tmp47_;
	}
	_tmp48_ = console_layout;
	g_debug ("fedora-installer.vala:203: Using '%s' keyboard layout.", _tmp48_);
	result = console_layout;
	_g_free0 (xkb_variant);
	_g_free0 (xkb_layout);
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (layout_str);
	layouts = (_vala_array_free (layouts, layouts_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (settings);
	return result;
}


BoxesFedoraInstaller* boxes_fedora_installer_construct (GType object_type) {
	BoxesFedoraInstaller * self = NULL;
	self = (BoxesFedoraInstaller*) boxes_unattended_installer_construct (object_type);
	return self;
}


BoxesFedoraInstaller* boxes_fedora_installer_new (void) {
	return boxes_fedora_installer_construct (BOXES_TYPE_FEDORA_INSTALLER);
}


static guint64 uint64_parse (const gchar* str) {
	guint64 result = 0ULL;
	const gchar* _tmp0_;
	guint64 _tmp1_ = 0ULL;
	g_return_val_if_fail (str != NULL, 0ULL);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtoull (_tmp0_, NULL, (guint) 0);
	result = _tmp1_;
	return result;
}


static gboolean boxes_fedora_installer_get_use_remote_repos (BoxesFedoraInstaller* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp7_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = boxes_unattended_installer_get_express_install ((BoxesUnattendedInstaller*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		OsinfoOs* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		guint64 _tmp6_ = 0ULL;
		_tmp3_ = ((BoxesInstallerMedia*) self)->os;
		_tmp4_ = osinfo_product_get_version ((OsinfoProduct*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = uint64_parse (_tmp5_);
		_tmp0_ = _tmp6_ < ((guint64) 17);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp7_ = _tmp0_;
	result = _tmp7_;
	return result;
}


static void boxes_fedora_installer_kbd_layout_copy (const BoxesFedoraInstallerKbdLayout* self, BoxesFedoraInstallerKbdLayout* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	_tmp0_ = (*self).xkb_layout;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).xkb_layout);
	(*dest).xkb_layout = _tmp1_;
	_tmp2_ = (*self).xkb_variant;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).xkb_variant);
	(*dest).xkb_variant = _tmp3_;
	_tmp4_ = (*self).console_layout;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 ((*dest).console_layout);
	(*dest).console_layout = _tmp5_;
}


static void boxes_fedora_installer_kbd_layout_destroy (BoxesFedoraInstallerKbdLayout* self) {
	_g_free0 ((*self).xkb_layout);
	_g_free0 ((*self).xkb_variant);
	_g_free0 ((*self).console_layout);
}


static BoxesFedoraInstallerKbdLayout* boxes_fedora_installer_kbd_layout_dup (const BoxesFedoraInstallerKbdLayout* self) {
	BoxesFedoraInstallerKbdLayout* dup;
	dup = g_new0 (BoxesFedoraInstallerKbdLayout, 1);
	boxes_fedora_installer_kbd_layout_copy (self, dup);
	return dup;
}


static void boxes_fedora_installer_kbd_layout_free (BoxesFedoraInstallerKbdLayout* self) {
	boxes_fedora_installer_kbd_layout_destroy (self);
	g_free (self);
}


static GType boxes_fedora_installer_kbd_layout_get_type (void) {
	static volatile gsize boxes_fedora_installer_kbd_layout_type_id__volatile = 0;
	if (g_once_init_enter (&boxes_fedora_installer_kbd_layout_type_id__volatile)) {
		GType boxes_fedora_installer_kbd_layout_type_id;
		boxes_fedora_installer_kbd_layout_type_id = g_boxed_type_register_static ("BoxesFedoraInstallerKbdLayout", (GBoxedCopyFunc) boxes_fedora_installer_kbd_layout_dup, (GBoxedFreeFunc) boxes_fedora_installer_kbd_layout_free);
		g_once_init_leave (&boxes_fedora_installer_kbd_layout_type_id__volatile, boxes_fedora_installer_kbd_layout_type_id);
	}
	return boxes_fedora_installer_kbd_layout_type_id__volatile;
}


static void boxes_fedora_installer_class_init (BoxesFedoraInstallerClass * klass) {
	GError * _inner_error_ = NULL;
	boxes_fedora_installer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BoxesFedoraInstallerPrivate));
	BOXES_UNATTENDED_INSTALLER_CLASS (klass)->set_direct_boot_params = boxes_fedora_installer_real_set_direct_boot_params;
	BOXES_UNATTENDED_INSTALLER_CLASS (klass)->check_needed_info = boxes_fedora_installer_real_check_needed_info;
	BOXES_UNATTENDED_INSTALLER_CLASS (klass)->prepare_direct_boot = boxes_fedora_installer_real_prepare_direct_boot;
	BOXES_UNATTENDED_INSTALLER_CLASS (klass)->prepare_direct_boot_finish = boxes_fedora_installer_real_prepare_direct_boot_finish;
	BOXES_UNATTENDED_INSTALLER_CLASS (klass)->clean_up = boxes_fedora_installer_real_clean_up;
	BOXES_UNATTENDED_INSTALLER_CLASS (klass)->fill_unattended_data = boxes_fedora_installer_real_fill_unattended_data;
	G_OBJECT_CLASS (klass)->get_property = _vala_boxes_fedora_installer_get_property;
	G_OBJECT_CLASS (klass)->finalize = boxes_fedora_installer_finalize;
	{
		GRegex* _tmp0_;
		GRegex* _tmp1_;
		GRegex* _tmp2_;
		GRegex* _tmp3_;
		_tmp0_ = g_regex_new ("BOXES_FEDORA_REPOS", 0, 0, &_inner_error_);
		_tmp1_ = _tmp0_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch12_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_g_regex_unref0 (boxes_fedora_installer_repo_regex);
		boxes_fedora_installer_repo_regex = _tmp1_;
		_tmp2_ = g_regex_new ("BOXES_FEDORA_KBD", 0, 0, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch12_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_g_regex_unref0 (boxes_fedora_installer_kbd_regex);
		boxes_fedora_installer_kbd_regex = _tmp3_;
	}
	goto __finally12;
	__catch12_g_regex_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (_error_);
	}
	__finally12:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
}


static void boxes_fedora_installer_instance_init (BoxesFedoraInstaller * self) {
	self->priv = BOXES_FEDORA_INSTALLER_GET_PRIVATE (self);
}


static void boxes_fedora_installer_finalize (GObject* obj) {
	BoxesFedoraInstaller * self;
	self = BOXES_FEDORA_INSTALLER (obj);
	_g_object_unref0 (self->priv->source_dir);
	_g_object_unref0 (self->priv->kernel_file);
	_g_object_unref0 (self->priv->initrd_file);
	_g_free0 (self->priv->kernel_path);
	_g_free0 (self->priv->initrd_path);
	_g_free0 (self->priv->kbd);
	G_OBJECT_CLASS (boxes_fedora_installer_parent_class)->finalize (obj);
}


GType boxes_fedora_installer_get_type (void) {
	static volatile gsize boxes_fedora_installer_type_id__volatile = 0;
	if (g_once_init_enter (&boxes_fedora_installer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BoxesFedoraInstallerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_fedora_installer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesFedoraInstaller), 0, (GInstanceInitFunc) boxes_fedora_installer_instance_init, NULL };
		GType boxes_fedora_installer_type_id;
		boxes_fedora_installer_type_id = g_type_register_static (BOXES_TYPE_UNATTENDED_INSTALLER, "BoxesFedoraInstaller", &g_define_type_info, 0);
		g_once_init_leave (&boxes_fedora_installer_type_id__volatile, boxes_fedora_installer_type_id);
	}
	return boxes_fedora_installer_type_id__volatile;
}


static void _vala_boxes_fedora_installer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	BoxesFedoraInstaller * self;
	self = BOXES_FEDORA_INSTALLER (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



